/**

Description: Chunks (Elements) are used by the PDF and HTML parser to
render different types of elements.

-------------------------------<br />
This library is provided free of charge by Benjamin E. Coe and PLink. Simply
be kind and reference your use of our library.
-------------------------------<br />

*/

package com.plink.plextile;
import com.plink.plextile.util.*;
import com.lowagie.text.*;
import java.util.*;
import java.awt.Color;

public class TextileChunk extends AbstractTextileChunk{

	private int settings[]=new int[11];//On off switches indicate what tags *,_,-,etc, are currently on.
	private String data="";
	private TextileBlock TB=null;//A textile block representing this element's style.
	private TextileParser MyTextileParser=null;//A central textile parser that we can check for data
	
	//Constructor.
	public TextileChunk(int settings[],String data,TextileBlock TB,TextileParser MyTextileParser){
	
		for(int i=0;i<11;i++)
			this.settings[i]=settings[i];
		this.data=data;
		
		this.TB=TB;
		this.MyTextileParser=MyTextileParser;
	}
	
	//Generate Chunk based on tags.
	public Element getChunk(){
	
		String tempdata=data;
		
		if(!TB.getTag().equals("bc"))
			tempdata=MyTextileParser.quoteConversion(tempdata);
		
		tempdata=MyTextileParser.finalReplacement(tempdata);
		tempdata=HTMLFilter.reconvertString(tempdata);
		
		Chunk chunk = new Chunk(tempdata); 
		Font f = null;
		
		//Get settings from TB.
		boolean bold=false;
		
		//Apply size.
		int size=TB.getFontSize();
		if(TB.isBold()){
			bold=true;
		}
		
		//Apply text transform.
		if(settings[3]>0)
			f = new Font(Font.TIMES_ROMAN,size,Font.UNDERLINE);
		else if(settings[2]>0)
			f = new Font(Font.TIMES_ROMAN,size,Font.STRIKETHRU);
		else if((settings[0]>0||settings[8]>0||bold)&&(settings[1]>0||settings[9]>0||settings[10]>0)){
			f = new Font(Font.TIMES_ROMAN,size,Font.BOLDITALIC);
		}else if(settings[0]>0||settings[8]>0||bold){
			f = new Font(Font.TIMES_ROMAN,size,Font.BOLD);
		}else if(settings[1]>0||settings[9]>0||settings[10]>0){
			f = new Font(Font.TIMES_ROMAN,size,Font.ITALIC);
		}else
			f = new Font(Font.TIMES_ROMAN,size,Font.NORMAL);
			
		//Apply color.
		int color[]=TB.getColor();
		f.setColor(new Color(color[0],color[1],color[2]));
			
		if(settings[4]>0){
			chunk.setTextRise(5.0f);
			f.setSize(size-4);
		}
		
		if(settings[5]>0){
			chunk.setTextRise(-3.0f);
			f.setSize(size-4);
		}
		if(settings[6]>0||TB.isMono()){
			f.setFamily("Courier");
		}
				
		chunk.setFont(f);
		return(chunk);
	}
	
	/**
	Return a reference to this block.
	*/
	public TextileBlock getBlock(){
		return(TB);
	}
	
	/*
	toString()
	*/
	public String toString(){
		return("CHUNK: ["+data+"]");
	}
}