/**

Description: This class provides parsing support for Textile meta information {STYLE}(CLASS)[Language].
It is used by both the PDF and text parser.
Benjamin E. Coe 2007.

-------------------------------<br />
This library is provided free of charge by Benjamin E. Coe and PLink. Simply
be kind and reference your use of our library.
-------------------------------<br />
caminatored
*/
package com.plink.plextile;
import com.plink.plextile.util.*;
import java.util.*;

public class TextileBlock{
	//Specific data for parsing parts of Table blocks.
	private boolean isHeader=false;
	private int colspan=0;
	private int rowspan=0;

	private String data="";//The tag free text data.
	private String blocktag="p";//The tag associated with this block.
	private int alignment=0;//Values follow
	
	public static final int LEFT=0;
	public static final int RIGHT=1;
	public static final int CENTER=2;
	public static final int JUSTIFY=3;
	
	private int color[]={0,0,0};//RGB Color value.
	private int fontsize=12;//Font size.
	private int leftpadding=0;//For PDF stye.
	private int rightpadding=0;
	//Color specific constants.
	public static final String ColorName[]={"BLUE","RED","GREEN","PURPLE","DARK BLUE","DARK RED","GRAY","PINK"};
	public static final int ColorValue[][]={{0,0,255},{255,0,0},{51,153,0},{153,51,153},{0,0,153},{153,0,0},{204,204,204},{255,51,255}};
	/*
		HTML Color Constants
		color="#0000FF"' Blue
		color="#FF0000"' Red
		color="#339900"' Green
		color="#993399"' Purple
		color="#000099"' Dark Blue
		color="#990000"' Dark Red
		color="#CCCCCC"' Gray
		color="#000000"' Black
		color="#FF33FF"' Pink 
	*/
	
	private boolean bold=false;//Bold this block?
	private boolean mono=false;//Monospace this block?
	private boolean colorset=false;//Have we parsed a color value?
	
	//HTML Specific.
	private String style="";//Style data.{}
	private String language="";//Language data [].
	private String Class="";//What is the class of this block.
	private String id="";//What is the ID of this block.
	private boolean footnote=false;
	
	/**
	Constructor used for parser based usage.
	*/
	public TextileBlock(){
	//Used when we require an instance simply for parsing attributes.
	}
	
	/**
	Copy Constructor.
	*/
	public TextileBlock(TextileBlock Block){
		data=Block.getData();
		blocktag=Block.getTag();
		alignment=Block.getAlignment();
		color=Block.getColor();
		fontsize=Block.getFontSize();
		leftpadding=Block.getLeftPadding();
		bold=Block.isBold();
		mono=Block.isMono();
		colorset=Block.isColorSet();
		style=Block.getStyle();
		language=Block.getLanguage();
		Class=Block.getBlockClass();
		id=Block.getID();
	}
	
	private int breakcount=0;//How many leading \n characters do we find?
	public TextileBlock(String parsedata){
		int skip=0;
		
		if(parsedata==null||parsedata.length()==0)
			return;
		
		//Check for leading \n characters.
		while(parsedata.charAt(skip)=='\n'){
			skip++;
		}
			
		if(skip>0){
			breakcount++;
			parsedata=parsedata.substring(skip,parsedata.length());
		}
	
		/*These two characters are provided escaped but are
		required for the parsing step.*/
		try{
	
			String attrib="";
		
			if(parsedata.length()<3){
				this.data=parsedata;
			}else{
				boolean match=false;
				
				/**
				The following checks for the block meta data.
				*/
				
				//Blockquote.
				String MatchMe=parsedata.substring(0,2);
				if(MatchMe.equals("bq")){
					boolean extractdata=false;
					String extracteddata="";
					for(int ii=0;ii<parsedata.length();ii++){
						if(extractdata){
							extracteddata+=parsedata.charAt(ii);
						}else if(ii>1){
							if(parsedata.charAt(ii)!='.')
								attrib+=parsedata.charAt(ii);
						}
						if(parsedata.charAt(ii)=='.'){
							extractdata=true;
						}
					}
					if(extractdata){
						leftpadding=50;
						data=extracteddata;
						match=true;
						blocktag="blockquote";
					}
				}
				
				//Blockcode.
				MatchMe=parsedata.substring(0,2);
				if(MatchMe.equals("bc")){
					boolean extractdata=false;
					String extracteddata="";
					for(int ii=0;ii<parsedata.length();ii++){
						if(extractdata){
							extracteddata+=parsedata.charAt(ii);
						}else if(ii>1){
							if(parsedata.charAt(ii)!='.')
								attrib+=parsedata.charAt(ii);
						}
						if(parsedata.charAt(ii)=='.'){
							extractdata=true;
						}
					}
					if(extractdata){
						data=extracteddata;
						match=true;
						blocktag="bc";
					}
				}
				
				//paragraph.
				MatchMe=parsedata.substring(0,1);
				if(MatchMe.equals("p")){
					boolean extractdata=false;
					String extracteddata="";
					for(int ii=0;ii<parsedata.length();ii++){
						if(extractdata){
							extracteddata+=parsedata.charAt(ii);
						}else if(ii>0){
							if(parsedata.charAt(ii)!='.')
								attrib+=parsedata.charAt(ii);
						}
						if(parsedata.charAt(ii)=='.'){
							extractdata=true;
						}
					}
					if(extractdata){
						data=extracteddata;
						match=true;
						blocktag="p";
					}
				}
				
				//paragraph.
				MatchMe=parsedata.substring(0,3);
				if(MatchMe.equals("pre")){
					boolean extractdata=false;
					String extracteddata="";
					for(int ii=0;ii<parsedata.length();ii++){
						if(extractdata){
							extracteddata+=parsedata.charAt(ii);
						}else if(ii>2){
							if(parsedata.charAt(ii)!='.')
								attrib+=parsedata.charAt(ii);
						}
						if(parsedata.charAt(ii)=='.'){
							extractdata=true;
						}
					}
					if(extractdata){
						data=extracteddata;
						match=true;
						blocktag="pre";
					}
				}
				
				//is it a header. 1-6.
				MatchMe=parsedata.substring(0,2);
				for(int i=0;i<6;i++){
					if(MatchMe.equals("h"+i)){
						boolean extractdata=false;
						String extracteddata="";
						for(int ii=0;ii<parsedata.length();ii++){
							if(extractdata){
								extracteddata+=parsedata.charAt(ii);
							}else if(ii>1){
								if(parsedata.charAt(ii)!='.')
									attrib+=parsedata.charAt(ii);
							}
							if(parsedata.charAt(ii)=='.'){
								extractdata=true;
							}
						}
						if(extractdata){
							data=extracteddata;
							fontsize=18-i;
							bold=true;
							match=true;
							blocktag="h"+i;
							break;
						}
					}
				}
				
				//Footnote between 100 and 256;
				if(!match){
					//is it a footnote?
					if(parsedata.length()>=6){
						MatchMe=parsedata.substring(0,5);
						for(int i=100;i<256;i++){
							if(MatchMe.equals("fn"+i)){
								boolean extractdata=false;
								String extracteddata="";
								for(int ii=0;ii<parsedata.length();ii++){
									if(extractdata){
										extracteddata+=parsedata.charAt(ii);
									}else if(ii>4){
										if(parsedata.charAt(ii)!='.')
											attrib+=parsedata.charAt(ii);
									}
									if(parsedata.charAt(ii)=='.'){
										extractdata=true;
									}
								}
								if(extractdata){
									data=extracteddata;
									match=true;
									id="fn"+i;
									Class="footnote";
									footnote=true;
									blocktag="p";
									break;
								}
							}
						}
					}
				}
				
				//Footnote between 10 and 99;
				if(!match){
					//is it a footnote?
					if(parsedata.length()>=5){
						MatchMe=parsedata.substring(0,4);
						for(int i=10;i<100;i++){
							if(MatchMe.equals("fn"+i)){
								boolean extractdata=false;
								String extracteddata="";
								for(int ii=0;ii<parsedata.length();ii++){
									if(extractdata){
										extracteddata+=parsedata.charAt(ii);
									}else if(ii>3){
										if(parsedata.charAt(ii)!='.')
											attrib+=parsedata.charAt(ii);
									}
									if(parsedata.charAt(ii)=='.'){
										extractdata=true;
									}
								}
								if(extractdata){
									data=extracteddata;
									match=true;
									id="fn"+i;
									Class="footnote";
									footnote=true;
									blocktag="p";
									break;
								}
							}
						}
					}
				}
				
				//Footnote between 1 and 9;
				if(!match){
					//is it a footnote?
					if(parsedata.length()>=4){
						MatchMe=parsedata.substring(0,3);
						for(int i=1;i<10;i++){
							if(MatchMe.equals("fn"+i)){
								boolean extractdata=false;
								String extracteddata="";
								for(int ii=0;ii<parsedata.length();ii++){
									if(extractdata){
										extracteddata+=parsedata.charAt(ii);
									}else if(ii>2){
										if(parsedata.charAt(ii)!='.')
											attrib+=parsedata.charAt(ii);
									}
									if(parsedata.charAt(ii)=='.'){
										extractdata=true;
									}
								}
								if(extractdata){
									data=extracteddata;
									match=true;
									id="fn"+i;
									Class="footnote";
									footnote=true;
									blocktag="p";
									break;
								}
							}
						}
					}
				}
				
				if(!match)
					data=parsedata;
			}
			
			if(attrib.length()>0)
				parseAttrib(attrib+" ");
			
		}catch(Exception e){
		
		}
	}
	
	/**
	Add a parent block to this block, merging the parents attributes
	with its own.
	*/
	public void merge(TextileBlock Merge){
		//Color values are the only thing currently copied.
		if(!Merge.isColorSet()){
			Merge.setColor(this.color);
		}
	}
	
	/**
	Parse the (CLASS) [LANG] [STYLE] >Alignment, data for a block level element.
	*/
	public void parseAttrib(String attrib){
		//Initialize variables.
		String language="";
		String style="";
		String Class="";
		String id="";
		int alignment=0;
	
		//Parse some table specific attributes.
		
		//Check for row and colspan.
		for(int i=1;i<20;i++){
			if(attrib.indexOf("\\"+i)>-1){
				colspan=i;
				attrib=attrib.replaceAll("\\\\"+i,"");
			}
			if(attrib.indexOf("/"+i)>-1){
				rowspan=i;
				attrib=attrib.replaceAll("/"+i,"");
			}
		}
		
		//Table header.
		if(attrib.indexOf("_")>-1){
			attrib=attrib.replaceAll("_","");
			isHeader=true;
		}
		//Align top.
		if(attrib.indexOf("~")>-1){
			attrib=attrib.replaceAll("~","");
			style+="vertical-align:bottom;";
		}
		//Align bottom.
		if(attrib.indexOf("^")>-1){
			attrib=attrib.replaceAll("\\^","");
			style+="vertical-align:top;";
		}
	
		try{
		
		//Get the language.
		String split[]=attrib.split("\\[");
		if(split.length>1){
			for(int i=0;i<split.length;i++){
				String s2[]=split[i].split("]");
				if(s2.length>1){
					language=s2[0];
					break;
				}
			}
		}
		
		//Get the styles.
		split=attrib.split("\\{");
		if(split.length>1){
			for(int i=0;i<split.length;i++){
				String s2[]=split[i].split("\\}");
				if(s2.length>1){
					style+=s2[0];
					break;
				}
			}
		}
		
		//Get class.
		String temp="";
		boolean on=false;
		for(int i=0;i<attrib.length();i++){
			if(attrib.charAt(i)==')'&&on)
				break;
			if(on)
				temp+=attrib.charAt(i);
			if(attrib.charAt(i)=='('&&(i==0||(attrib.charAt(i-1)!='b'&&attrib.charAt(i-1)!='B')))
				on=true;
		}
		if(temp.length()>0){
			if(temp.charAt(0)=='#')
				id=temp.substring(1,temp.length());
			else{
				split=temp.split("#");
				if(split.length>1){
					Class=split[0];
					id=split[1];
				}else
					Class=temp;
			}
		}
		
		//Get justification.
		temp="";
		on=true;
		for(int i=0;i<attrib.length();i++){
			if(attrib.charAt(i)=='('||attrib.charAt(i)=='['||attrib.charAt(i)=='{')
				on=false;
			if(attrib.charAt(i)==')'||attrib.charAt(i)==']'||attrib.charAt(i)=='}')
				on=true;
			if(on&&!(attrib.charAt(i)==')'||attrib.charAt(i)==']'||attrib.charAt(i)=='}'||attrib.charAt(i)=='('||attrib.charAt(i)=='['||attrib.charAt(i)=='{'||attrib.charAt(i)==' '))
				temp+=attrib.charAt(i);
		}
		
		if(temp.equals("&lt;")){
			alignment=LEFT;
			style+=";text-align:left";
		}
		else if(temp.equals("&gt;")){
			alignment=RIGHT;
			style+=";text-align:right";
		}
		else if(temp.equals("=")){
			alignment=CENTER;
			style+=";text-align:center";
		}
		else if(temp.equals("&lt;&gt;")){
			alignment=JUSTIFY;
			style+=";text-align:justify";
		}
		
		//Parse padding.
		int left=0;
		int right=0;
		for(int i=0;i<attrib.length();i++){
			if(attrib.charAt(i)=='(')
				left++;
			if(attrib.charAt(i)==')')
				right++;
		}
		if((Class.length()>0||id.length()>0)&&!footnote){
			left--;
			right--;
		}
		
		if(left>0){
			leftpadding+=left*8;
			style+=";padding-left:"+left+"em";
		}
		if(right>0){
			rightpadding+=right*8;
			style+=";padding-right:"+right+"em";
		}
		
		//Set variables only if needed.
		if(Class.length()>0)
			this.Class=Class;
		if(id.length()>0)
			this.id=id;
		if(style.length()>0)
			this.style=style;
			
		this.alignment=alignment;
		
		if(language.length()>0)
			this.language=language;
		
		//Parse the color values.
		if(style.length()>0){
			parseColor(style.toUpperCase()+" ");
		}
		
		}catch(Exception e){
		
		}
	}
	
	/**
	Parse the color value of a CSS snipet, used for PDF.
	*/
	public void parseColor(String parseme){
		try{
	
		String split[]=parseme.split("COLOR:");
		if(!(split.length>1))
			return;
			
		colorset=true;
			
		//Color type 1. #235353
		String color=split[1];
		split=color.split("#");
		if(split.length>1){
			String temp=split[1];
			if(temp.length()<6)
				return;
			String sval="";
			int index=0;
			for(int i=0;i<6;i++){
				sval+=temp.charAt(i);
				if((i+1)%2==0){
					char c1=sval.charAt(0);
					if(c1>='A')
						c1-=7;
					char c2=sval.charAt(1);
					if(c2>='A')
						c2-=7;
					this.color[index]=((c1-'0')*16)+(c2-'0');
					sval="";
					index++;
				}
			}
		}
		
		//Color type 2. RGB.
		else{
				split=color.split("RGB\\(");
				if(split.length>1){
					String val="";
					String temp=split[1];
					int index=0;
					for(int i=0;i<temp.length();i++){
						if(!(temp.charAt(i)==','||temp.charAt(i)==')'))
							val+=temp.charAt(i);
						if(temp.charAt(i)==','||temp.charAt(i)==')'){
							try{
								this.color[index]=new Integer(val);
							}catch(Exception e2){
							
							}
							val="";
							index++;
							if(temp.charAt(i)==')')
								break;
						}
					}
				}else{
					for(int i=0;i<ColorName.length;i++){
						if(parseme.indexOf(ColorName[i])!=-1){
							this.color=ColorValue[i];
							break;
						}
					}
				}
		}
		
		}catch(Exception e){
		
		}
	}
	
	/**
	Paragraph alignment.
	*/
	public int getAlignment(){
		return(alignment);
	}
	
	/**
	A String representing HTML style.
	*/
	public String getStyle(){
		return(style);
	}
	
	/**
	Get the language associated with this block.
	*/
	public String getLanguage(){
		return(language);
	}
	
	/**
	What size should we make the font?
	*/
	public int getFontSize(){
		return(fontsize);
	}
	
	/**
	Set the font size.
	*/
	public void setFontSize(int fontsize){
		this.fontsize=fontsize;
	}
	
	/**
	How much padding should there be to the left.
	*/
	public int getLeftPadding(){
		return(leftpadding);
	}
	
	/**
	Set the left padding of this block.
	*/
	public void setLeftPadding(int leftpadding){
		this.leftpadding=leftpadding;
	}
	
	/**
	How much padding should there be to the right?
	*/
	public int getRightPadding(){
		return(rightpadding);
	}
	
	/**
	Set the rightpadding value.
	*/
	public void setRightPadding(int rightpadding){
		this.rightpadding=rightpadding;
	}
	
	/**
	Get the text data of this block.
	*/
	public String getData(){
		StringBuffer SB=new StringBuffer(data.length()+50);
		for(int i=0;i<breakcount;i++){
			SB.append("\n");
		}
		SB.append(data);
		return(SB.toString());
	}
	
	/**
	What HTML tag represents this block?
	*/
	public String getTag(){
		return(blocktag);
	}
	
	/**
	Get the color of this block.
	*/
	public int[] getColor(){
		return(color);
	}
	
	/**
	Set the color of this block.
	*/
	public void setColor(int color[]){
		this.color=color;
	}
	
	/**
	Should this block be bold.
	*/
	public boolean isBold(){
		return(bold);
	}
	
	public void setBold(boolean bold){
		this.bold=bold;
	}
	
	/**
	Should this block be monospaced - code spaced.
	*/
	public boolean isMono(){
		return(mono);
	}
	
	public void setMono(boolean mono){
		this.mono=mono;
	}
	
	/**
	Returns whether this block has set the color value.
	*/
	public boolean isColorSet(){
		return(colorset);
	}
	
	/**
	The in document ID of this item.
	*/
	public String getID(){
		return(id);
	}
	
	/**
	Get the class of this block.
	*/
	public String getBlockClass(){
		return(Class);
	}
	
	/**
	Get whether this Table describing block is a header block
	*/
	public boolean isHeader(){
		return(isHeader);
	}
	
	/**
	Get the colspan of this table describing block.
	*/
	public int getColspan(){
		return(colspan);
	}
	
	/**
	Get the rowspan of this table describing block.
	*/
	public int getRowspan(){
		return(rowspan);
	}
}