/**

Description: Used to return meta information about the tags we parse. It is essentially
just a wrapper for a TextileBlock, but with some additional information.

Benjamin E. Coe 2007.

-------------------------------<br />
This library is provided free of charge by Benjamin E. Coe and PLink. Simply
be kind and reference your use of our library.
-------------------------------<br />
*/
package com.plink.plextile;
import com.plink.plextile.util.*;
import com.lowagie.text.*;
import com.lowagie.text.pdf.PdfWriter;
import java.util.*;
import java.io.*;
import java.awt.Color;

//Used to return a TextileBlock representing the meta data for a given tag.
public class TagMetaData{
	private TextileBlock MetaBlock=null;
	private int skip=0;
	private int position=0;
	
	public TagMetaData(TextileBlock MetaBlock,int position,int skip){
		this.MetaBlock=MetaBlock;
		this.position=position;
		this.skip=skip;
	}
	
	/**
	Get the style block associated with this tag.
	*/
	public TextileBlock getBlock(){
		return(MetaBlock);
	}
	
	/**
	Get the index of the tag that this should be applied to.
	*/
	public int getPosition(){
		return(position);
	}
	
	/**
	Get the length of the original tag parsed so that we can skip it when parsing data.
	*/
	public int getSkip(){
		return(skip);
	}
}