/**

Generates a series of chunks for a PDF document, based on Textile input.
Outputs it to a lowagie PDF document.<br /><br />

Benjamin E. Coe. (c)2007<br />

-------------------------------<br />
This library is provided free of charge by Benjamin E. Coe and PLink. Simply
be kind and reference your use of our library.
-------------------------------<br />
caminatored
*/
package com.plink.plextile;
import com.lowagie.text.*;
import com.plink.plextile.util.*;
import java.util.*;

public class PdfParser{
	private TextileParser MyTextileParser=new TextileParser();
	
	/**
	Parses the data and outputs it to the open PDF provided.
	*/
	public void parseTextile(String data,com.lowagie.text.Document doc){
		//Apply Filter.
		data=HTMLFilter.convertString(data);
		data=HTMLFilter.filter(data);//Replace dangerous characters.
	
		//Some initial data processing.
		data=data.replaceAll("&amp;","&");
		data=data.replaceAll("&#"+((int)'\n')+";","\n");
		data=data.replaceAll("&#13;","");
		
		//Make sure that \n\n in code blocks doesn't break flow.
		data=MyTextileParser.makeCodeSafe(data);
		
		//First parse all the aliases in the document.
		data=MyTextileParser.findLinkAliases(data+" ");
		
		//Split the data.
		String chunks[]=data.split("\n\n");
	
		ArrayList Chunks=new ArrayList();
		//Split into blocks and parse each.
		for(int i=0;i<chunks.length;i++){
			Chunks.add(parseTextileBlock(chunks[i]));
		}
		
		//Process at end to allow for inner links.
		for(int i=0;i<Chunks.size();i++){
			BlockRenderer BR=(BlockRenderer)Chunks.get(i);
			BR.render(doc);
		}
	}
	
	/**
	Parse data and output to the PDF provided. Only apply if data
	is stored in a filtered form.
	*/
	public void parseTextileNoFilter(String data,com.lowagie.text.Document doc){
	
		//Initlal processing.
		data=data.replaceAll("&amp;","&");
		data=data.replaceAll("&#"+((int)'\n')+";","\n");
		data=data.replaceAll("&#13;","");

		//Make sure that \n\n in code blocks doesn't break flow.
		data=MyTextileParser.makeCodeSafe(data);

		//First parse all the aliases in the document.
		data=MyTextileParser.findLinkAliases(data+" ");
		
		//Split data.
		String chunks[]=data.split("\n\n");
		ArrayList Chunks=new ArrayList();
		
		//Split into blocks and parse each.
		for(int i=0;i<chunks.length;i++){
			Chunks.add(parseTextileBlock(chunks[i]));
		}
		
		//Process at end to allow for inner links.
		for(int i=0;i<Chunks.size();i++){
			BlockRenderer BR=(BlockRenderer)Chunks.get(i);
			BR.render(doc);
		}
	}

	/**
	Parse a block fo Textile markup and output it to a PDF.
	*/
	private BlockRenderer parseTextileBlock(String data){
		MyTextileParser.resetLinks();
		MyTextileParser.resetSkip();
		TextileBlock Block=new TextileBlock(data+" ");
		String parseMe=Block.getData();
		ComplexBlockRenderer MyBlockRenderer=(ComplexBlockRenderer)(new ComplexBlockRenderer(Block,MyTextileParser,false));
			
		int tagon[]={0,0,0,0,0,0,0,0,0,0,0};
		String tags[]={"strong","em","del","ins","sup","sub","code","span","b","i","cite"};
		
		//Is it a block of code?
		if(Block.getTag().equals("bc")){
			MyBlockRenderer.add(new TextileChunk(tagon,parseMe,Block,MyTextileParser),0);
			return(MyBlockRenderer);
		}
		
		//Get our rules list.
		ArrayList Rules=MyTextileParser.ParseTextile(parseMe,MyBlockRenderer);
		String freedata=MyTextileParser.getTagFreeData();
		
		//freedata=MyBlockRenderer.registerData(freedata);
		String returnMe="";
		
		//Get our Links list.
		ArrayList Links=MyTextileParser.parseLinks(freedata,Block.getFontSize());
		
		int skip=0;
		boolean colorSet=false;
		boolean	inTable=false;
		int color[]=null;
		
		try{
		
		for(int i=0;i<freedata.length();i++){
		
			//Fixes incomming data if we happen to be within a table.
			if(inTable)
			if(MyBlockRenderer.isEvent(i+1)){
				int check=MyBlockRenderer.lastEvent();
				if(check==BlockRenderer.ROW_END||check==BlockRenderer.TABLE_END)
					skip++;
			}
		
			//Check for complex events.
			if(MyBlockRenderer.isEvent(i)&&i!=0){
				int check=MyBlockRenderer.lastEvent();
				if(check==BlockRenderer.NUMERIC_LIST_START||check==BlockRenderer.BULLETED_LIST_START||check==BlockRenderer.BULLETED_LIST_END||check==BlockRenderer.NUMERIC_LIST_END||check==BlockRenderer.ENTRY_START){
					if(!(check==BlockRenderer.NUMERIC_LIST_END||check==BlockRenderer.BULLETED_LIST_END))
						MyBlockRenderer.add(new TextileChunk(tagon,returnMe+freedata.charAt(i),Block,MyTextileParser),i-1);
					else{
						MyBlockRenderer.add(new TextileChunk(tagon,returnMe+freedata.charAt(i),Block,MyTextileParser),i-2);
					}
					returnMe="";
				}
				
				//Table events.
				if(check==BlockRenderer.TABLE_START){
					inTable=true;
					MyBlockRenderer.add(new TextileChunk(tagon,returnMe,Block,MyTextileParser),i-1);
					returnMe="";
				}else if(check==BlockRenderer.TABLE_END||check==BlockRenderer.ROW_END||check==BlockRenderer.CELL_END){
					MyBlockRenderer.add(new TextileChunk(tagon,returnMe,Block,MyTextileParser),i-1);
					returnMe="";
				}
			}
			
			//Skip portions of the string we are copying.
			if(MyTextileParser.getSkip(i)>0)
				skip+=MyTextileParser.getSkip(i);
		
			//Check for block level modifiers that are ending.
			for(int ii=Rules.size()-1;ii>=0;ii--){
				int ranges[][]=(int[][])Rules.get(ii);
				if(ranges[0][1]==i){
					TextileBlock TB=new TextileBlock(Block);
					if(colorSet){
						TB.setColor(color);
					}
				
					MyBlockRenderer.add(new TextileChunk(tagon,returnMe,TB,MyTextileParser),i);
					returnMe="";
					
					if(tagon[ranges[1][0]]>0)
						tagon[ranges[1][0]]--;
					if(tagon[ranges[1][0]]==0)
							skip=1;
					
					colorSet=false;
				}
			}
			
			//Check for block level modifiers that are starting.
			for(int ii=0;ii<Rules.size();ii++){
				int ranges[][]=(int[][])Rules.get(ii);
				if(ranges[0][0]==i){
					
					if(returnMe.length()-1>=0)
						returnMe=returnMe.substring(0,returnMe.length()-1);
						
					TagMetaData TMD=null;
					if((TMD=MyTextileParser.hasAttrib(i))!=null){
						skip=TMD.getSkip();
							
						if(TMD.getBlock().isColorSet()){
							color=TMD.getBlock().getColor();
							colorSet=true;
						}
					}
				
					MyBlockRenderer.add(new TextileChunk(tagon,returnMe,Block,MyTextileParser),i);
					returnMe="";
						
					tagon[ranges[1][0]]++;
				}
			}
			if(skip==0)
				returnMe+=freedata.charAt(i);
			if(skip>0)
				skip--;
				
			//Check for links.
			for(int ii=0;ii<Links.size();ii++){
				TextileLink LI=(TextileLink)Links.get(ii);
				if(LI.getPosition()==i){
					skip=LI.getSkip();
					
					if(returnMe.length()>0)
						MyBlockRenderer.add(new TextileChunk(tagon,returnMe.substring(0,returnMe.length()-1),Block,MyTextileParser),i-1);
					else	
						MyBlockRenderer.add(new TextileChunk(tagon,returnMe,Block,MyTextileParser),i-1);
						
					MyBlockRenderer.add(LI,i);
					returnMe="";
				}
			}
		}
		
		}catch(Exception e){
			e.printStackTrace();
		}
		
		if(returnMe.length()>0){
			MyBlockRenderer.add(new TextileChunk(tagon,returnMe,Block,MyTextileParser),freedata.length());
		}
		
		return(MyBlockRenderer);
	}
}