/**

Description: The renderer observes the parsing process, and renders
the processed data either (it may be simple data a table or a list).<br /><br />

Benjamin E. Coe. (c)2007<br />

-------------------------------<br />
This library is provided free of charge by Benjamin E. Coe and PLink. Simply
be kind and reference your use of our library.
-------------------------------<br />

*/
package com.plink.plextile;
import com.plink.plextile.util.*;
import java.util.*;
import com.lowagie.text.*;


public class ComplexBlockRenderer extends BlockRenderer{

	private ArrayList Chunks=new ArrayList();//Our chunk data.
	private Paragraph p;
	private TextileBlock MyTextileBlock;
	private TextileParser MyTextileParser;
	private int lastEvent=-1;
	//List specific data.
	private ArrayList ListChunks=new ArrayList();
	private ArrayList TableChunks=new ArrayList();

	/**
	Initialize a SimpleBlockRenderer using the initial Bock class provided.
	*/
	public ComplexBlockRenderer(TextileBlock MyTextileBlock,TextileParser MyTextileParser,boolean TextRender){
	
		this.MyTextileParser=MyTextileParser;
		this.MyTextileBlock=MyTextileBlock;
		
		//If we are just rendering text avoid this step.
		if(!TextRender){
			p=new Paragraph();
			
			//Add in document link identifiers.
			p.setIndentationLeft(MyTextileBlock.getLeftPadding());
			p.setIndentationRight(MyTextileBlock.getRightPadding());
		
			if(MyTextileBlock.getID().length()>0){
				String ts[]=new String[2];
				ts[0]=MyTextileBlock.getID();
				ts[1]="";
				MyTextileParser.addDestination(ts);
				p.add(new Chunk(" ").setLocalDestination(MyTextileBlock.getID()));
			}
			
			//Set the alignment of this block.
			int alignment=MyTextileBlock.getAlignment();
			
			if(alignment==MyTextileBlock.LEFT)
					p.setAlignment(Image.LEFT);
			if(alignment==MyTextileBlock.RIGHT){
					p.setAlignment(Image.ALIGN_RIGHT);
			}if(alignment==MyTextileBlock.CENTER)
					p.setAlignment(Image.MIDDLE);
			if(alignment==MyTextileBlock.JUSTIFY)
					p.setAlignment(Element.ALIGN_JUSTIFIED);
		}
	}
	
	
	/**
	Parse lists and tables out of the incremental data provided. This approach is useed so that
	it can be combined with another pass through the document.
	*/
	//List parsing.
	private boolean inList=false;//Are we currently parsing a list?
	private TextileList TL=null;//The current List we're building.
	private int start=0;//Starting position of list.
	private int type=TL.NUMERIC;
	
	private int StartToken[]=null;//Depth of list/length of style information.
	private int EndToken[]=null;//Depth of list/length of style informatiion.
		
	public synchronized boolean buildComplexElements(char c,int i,String data){
			
	
			if(inList){//Are we already parsing a list?
			
				//Have we reached the end of this list?
				if((data.charAt(i)=='\n'&&(EndToken=checkForToken(i,data))==null)||i==data.length()-1){
					ListChunks.add(TL);
					if(data.charAt(i)=='\n'){
						TL.insertElement(StartToken[0],start,i-2,StartToken[1]);
					}else{
						TL.insertElement(StartToken[0],start,i-1,StartToken[1]);
					}
					
					TL.setStop(i);
					inList=false;
				}else{//Otherwise add new elements to the list when we reach tokens.
					//Parse Each Token.
					if((EndToken=checkForToken(i,data))!=null){
					
						//Skip leading\n and ###
						int skip[]=new int[2];
						skip[0]=i;
						skip[1]=EndToken[0]+2;
						MyTextileParser.addSkip(skip);
					
						TL.insertElement(StartToken[0],start,i-1,StartToken[1]);
						
						start=i;
						StartToken=EndToken;
					}
				}
			}else{
				
				if((StartToken=checkForToken(i,data))!=null){//Begin parsing a list when starting point is reached.
					if(i!=0||i==0&&data.charAt(0)=='\n'){
						TL=new TextileList(getListAttrib(i,i+StartToken[0]+2,data),MyTextileParser,StartToken[1],StartToken[0]);
					}else{
						TL=new TextileList(getListAttrib(i,i+StartToken[0]+1,data),MyTextileParser,StartToken[1],StartToken[0]);
					}
									
					TL.setStart(i);
					inList=true;
					start=i;
				}
		
			}
			
			//Parse table data inline.
			return(parseTable(c,i,data));
	}
	
	/**
	Check for a list token at the beginning of a line.
	*/
	public int[] checkForToken(int position,String data){
		
		int returnMe[]=new int[2];
		int i;
		if((i=isNumericToken(position,data))>=0){
			returnMe[0]=i;
			returnMe[1]=TextileList.NUMERIC;
			return(returnMe);
		}
		
		if((i=isBulletToken(position,data))>=0){
			returnMe[0]=i;
			returnMe[1]=TextileList.BULLET;
			return(returnMe);
		}
		
		return(null);
	}
	
	//Check for numeric list tokens.
	private int isNumericToken(int position,String data){
		char c=data.charAt(position);
		String P="#";
		for(int i=0;i<8;i++){
		
			String Check="";
			if(position==0&&data.charAt(0)!='\n')
				Check=P;
			else{
				Check="\n"+P;
			}
				
			if(MyTextileParser.findString(position,c,data,Check+" ")!=null){
				return(i);
			}
				
			if(MyTextileParser.findString(position,c,data,Check+"(")!=null)
				return(i);
				
			if(MyTextileParser.findString(position,c,data,Check+"[")!=null)
				return(i);
				
			if(MyTextileParser.findString(position,c,data,Check+"{")!=null)
				return(i);
				
			P+="#";
		}
		return(-1);
	}
	
	//Check for bulleted list tokens.
	private int isBulletToken(int position,String data){
		char c=data.charAt(position);
		String P="*";
		for(int i=0;i<8;i++){
			String Check="";
			if(position==0&&data.charAt(0)!='\n')
				Check=P;
			else{
				Check="\n"+P;
			}
		
			if(MyTextileParser.findString(position,c,data,Check+" ")!=null){
				
				return(i);
			}
				
			if(MyTextileParser.findString(position,c,data,Check+"(")!=null)
				return(i);
				
			if(MyTextileParser.findString(position,c,data,Check+"[")!=null)
				return(i);
				
			if(MyTextileParser.findString(position,c,data,Check+"{")!=null)
				return(i);
				
			P+="*";
		}
		return(-1);
	}
	
	/**
	Fetch list attributes and register a skip with the central parser.
	*/
	public TextileBlock getListAttrib(int start,int position,String data){
		TextileBlock Block=new TextileBlock();
		String Temp=MyTextileParser.parseAttrib(position,data);
		
		//Skip header and tag data.
		int skip[]=new int[2];
	
		skip[0]=start;
		
		if(Temp!=null&&Temp.length()!=0){
			skip[1]+=Temp.length()-1;
		}

		skip[1]+=(position-start);
		MyTextileParser.addSkip(skip);
		////
		
		if(Temp!=null)
			Block.parseAttrib(Temp);
		return(Block);
	}
	
	/**
	Parse the complex table elemnt. Putting it into a structure used by a PDF
	and text parser.
	*/
	//Table parsing.
	private TextileTable TB=null;//The current Table object being created.
	private TextileBlock CellStyle=null;//Cell style blcok.
	
	private boolean inTable=false;//Are we currently within a table?
	
	private String tableParse="";//The data currently parsed for a cell of a table.
	
	private String parseRowStyle="";//String representing the row style parsed.
	private int cstart=0;//Starting position of current cell.
	private int rstart=0;//Starting position of current row.
	
	private int cellcount=0;//Table Cells.
	private int rowcount=0;//Table Rows.
	
	private boolean validTableStart=true;//Is the current position in the data valid for starting a table?
	
	private boolean on=false;//True if we are still parsing meta informatioin.
	private char onStart=' ';//Keep track of tokens in meta inforamtion being parsed.
	
	private boolean parseTable(char c,int i,String data){
		boolean skipNext=false;
	
		if(inTable){//Are we currently in a table?
			if(c=='\n'||i==data.length()-1){//We have reached the end of a row.
			
				if(i==data.length()-1||data.charAt(i+1)!='|'){
				
					if(data.charAt(i-1)=='|'){
						TB.setStop(i);
						TB.addRow(rstart,i);//Add a row to the table object.
					}else{
						inTable=false;
						TB.setStop(cstart);
						TB.addRow(rstart,cstart);//Add a row to the table object.
					}
				
					TableChunks.add(TB);
				}else{
					TB.addRow(rstart,i);//Add a row to the table object.
					rstart=i;
				}
				
				tableParse="";
				cstart=i+1;
				cellcount=0;
				parseRowStyle="";
				rowcount++;
			}else{
			
				//We've hit a | token.
				if(c=='|'&&cellcount!=0){//Add another cell aslong as this is an ending | token.
					
						
					//Parse the cell header info.
					CellStyle=new TextileBlock();
					String Temp=null;
					
					//Parse cell attributes.
					if(tableParse.charAt(0)!='\n'){
						Temp=MyTextileParser.parseAttribComplex(1,tableParse);
					}else{
						Temp=MyTextileParser.parseAttribComplex(2,tableParse);
					}
					
					//Begin creating a skip value to register based on parsing length.
					int skip[]=new int[2];
					skip[0]=cstart;
					if(Temp!=null&&Temp.length()>0){
						skip[1]=Temp.length();
					}
					
					//Parse row style and modify skipping values.
					if(parseRowStyle.length()>1)
						TB.setRowStyle(parseRowStyle);
					
					if(parseRowStyle.length()>0&&!(cellcount==1&&rowcount==0)){
						skip[1]+=parseRowStyle.length()-1;
					}else  if(cellcount==1&&rowcount==0&&parseRowStyle.length()>0){
						skip[0]-=parseRowStyle.length()-1;
						skip[1]+=parseRowStyle.length()-1;
					}
					
					//Quick fix for an off by one error with skip value.
					if(skip[0]>0)
						skip[0]--;
						
					skip[1]++;
					
					//Modify the skip value based on current position in table.
					if(cellcount==1&&(rowcount!=0||parseRowStyle.length()>0)){
						skip[1]+=1;
					}

					MyTextileParser.addSkip(skip);//Register the skip with the central parser.
					
					if(Temp!=null){
						if(Temp!=null)
							Temp=Temp.substring(0,Temp.length()-1)+" ";
						CellStyle.parseAttrib(Temp);
					}
					
					TB.addCell(cstart,i,CellStyle);//Add the new cell that has been created to the Table object.
					
					tableParse="";
					cstart=i+1;
					cellcount++;
					parseRowStyle="";
				}else if(cellcount==0&&c=='|'){
					cellcount++;
				}
			}
			
			if(cellcount==0&&rowcount!=0){
				parseRowStyle+=c;
			}
					
			if(cellcount>0){
				tableParse+=c;
			}
			
			return(true);
			
		}else{//We are not currently parsing a table.
			if(c=='|'&&validTableStart){//Hit a new table to parse.
				TB=new TextileTable(MyTextileParser);//Make a new table object.
				TB.setStart(i);//Set the starting index.
				cstart=i;//Cell Start.
				rstart=i;//Row Start.
				rowcount=0;
				cellcount=1;//How many cells hav been parsed.
				inTable=true;
				tableParse="|";//Normalize the tokens.
				return(true);
			}else{
			
			//Are we parsing table style?
			if(c=='{'&&!on){
				on=true;
				onStart='{';
			}else if(c=='('&&!on){
				on=true;
				onStart='(';
			}else if(c=='['&&!on){
				on=true;
				onStart='[';
			}else if(c=='}'&&onStart=='{')
				on=false;
			else if(c==')'&&onStart=='(')
				on=false;
			else if(c==']'&&onStart=='[')
				on=false;
			
			if(c==' '&&!on){
				parseRowStyle="";
				validTableStart=false;
			}else if(c=='\n'){
				validTableStart=true;
			}
			
			if(validTableStart){
				parseRowStyle+=c;
			}
			
			}
			return(false);
		}	
	}
	
	/**
	Provide a new parsed 
	*/
	public void add(AbstractTextileChunk TC,int position){
		boolean added=false;
		
		//Check whether this new chunk should be added to a list.
		TextileList LC=null;
		for(int i=0;i<ListChunks.size();i++){
			LC=(TextileList)ListChunks.get(i);
			if(LC.inList(position)){
				LC.addChunk(position,TC);
				added=true;
			}
			
			if(added){
				TC=LC;
				break;
			}
		}
		
		//Check whether this new chunk... or list should be added to a table.
		TextileTable TB=null;
		for(int i=0;i<TableChunks.size();i++){
			TB=(TextileTable)TableChunks.get(i);
			if(TB.inTable(position)){
				TB.addChunk(position,TC);
				LC=null;
				added=true;
			}
			if(added)
				break;
		}
		
		//Add these elements to the rendered elements list.
		if(!added)
			Chunks.add(TC);
		else{
			if(added){
				if(LC!=null&&!LC.isHandled()){
					LC.setHandled(true);
					Chunks.add(LC);
				}else if(TB!=null&&!TB.isHandled()){
					TB.setHandled(true);
					Chunks.add(TB);
				}
			}
		}
	}
	
	/**
	Return whether the given position throws an event.
	*/
	public boolean isEvent(int position){
	
		//Check for list events.
		for(int i=0;i<ListChunks.size();i++){
			TextileList LC=(TextileList)ListChunks.get(i);
			int event=-1;
			if((event=LC.isEvent(position))>=0){
				currentHTML=LC.getHTML();
				this.lastEvent=event;
				return(true);
			}
		}
		
		//Check for table events.
		for(int i=0;i<TableChunks.size();i++){
			TextileTable TT=(TextileTable)TableChunks.get(i);
			int event=-1;
			if((event=TT.isEvent(position))>=0){
				currentHTML=TT.getHTML();
				this.lastEvent=event;
				return(true);
			}
		}
		
		return(false);
	}
	
	/**
	Fetch the given HTML event at the position provided.
	*/
	private String currentHTML="";
	public String getHTML(int position){
		return(currentHTML);
	}
	
	/**
	Render the elements in the render list.
	*/
	public void render(com.lowagie.text.Document doc){
		try{
			for(int i=0;i<Chunks.size();i++){
				Object o=Chunks.get(i);
				if(o instanceof AbstractTextileChunk){
					AbstractTextileChunk temp=(AbstractTextileChunk)o;
					p.add(temp.getChunk());
				}
			}
			doc.add(p);
			doc.add(Chunk.NEWLINE);
		}catch(Exception e){
			e.printStackTrace();
		}
	}
	
	/**
	Return the type of event that has been fired.
	*/
	public int lastEvent(){
		return(lastEvent);
	}
}