/**

Description: The renderer observes the parsing process, and
performs functions for fancy block elements like tables and lists.<br /><br />

Benjamin E. Coe. (c)2007<br />

-------------------------------<br />
This library is provided free of charge by Benjamin E. Coe and PLink. Simply
be kind and reference your use of our library.
-------------------------------<br />
caminatored
*/
package com.plink.plextile;
import com.plink.plextile.util.*;
import java.util.*;

public abstract class BlockRenderer{

	/*Most of the parsing takes place during one sweep of the document, these
	events get thrown at positions within the data.*/
	public static final int BULLETED_LIST_START=0;
	public static final int NUMERIC_LIST_START=1;
	public static final int BULLETED_LIST_END=2;
	public static final int NUMERIC_LIST_END=3;
	public static final int ENTRY_START=4;
	public static final int ENTRY_END=5;
	public static final int CELL_START=6;
	public static final int CELL_END=7;
	public static final int TABLE_END=8;
	public static final int TABLE_START=9;
	public static final int ROW_END=10;

	//Constructor.
	public BlockRenderer(){
	
	}
	/**
	Provide a partial chunk of data to the renderer.
	*/
	public abstract void add(AbstractTextileChunk TC,int position);
	
	/**
	Return whether the given position should be treated as a stopping event.
	*/
	public abstract boolean isEvent(int position);
	
	/**
	Return the type of event that has been fired.
	*/
	public abstract int lastEvent();
	
	/**
	Render the data stored.
	*/
	public abstract void render(com.lowagie.text.Document doc);
	
	/**
	Fetch the given HTML event at the position provided. This is used
	by some datatypes to communicate with the text parser.
	*/
	public abstract String getHTML(int position);
}