//alert("LKJ");
/**
 * Cookie plugin
 *
 * Copyright (c) 2006 Klaus Hartl (stilbuero.de)
 * Dual licensed under the MIT and GPL licenses:
 * http://www.opensource.org/licenses/mit-license.php
 * http://www.gnu.org/licenses/gpl.html
 *
 */

/**
 * Create a cookie with the given name and value and other optional parameters.
 *
 * @example $.cookie('the_cookie', 'the_value');
 * @desc Set the value of a cookie.
 * @example $.cookie('the_cookie', 'the_value', {expires: 7, path: '/', domain: 'jquery.com', secure: true});
 * @desc Create a cookie with all available options.
 * @example $.cookie('the_cookie', 'the_value');
 * @desc Create a session cookie.
 * @example $.cookie('the_cookie', null);
 * @desc Delete a cookie by passing null as value.
 *
 * @param String name The name of the cookie.
 * @param String value The value of the cookie.
 * @param Object options An object literal containing key/value pairs to provide optional cookie attributes.
 * @option Number|Date expires Either an integer specifying the expiration date from now on in days or a Date object.
 *                             If a negative value is specified (e.g. a date in the past), the cookie will be deleted.
 *                             If set to null or omitted, the cookie will be a session cookie and will not be retained
 *                             when the the browser exits.
 * @option String path The value of the path atribute of the cookie (default: path of page that created the cookie).
 * @option String domain The value of the domain attribute of the cookie (default: domain of page that created the cookie).
 * @option Boolean secure If true, the secure attribute of the cookie will be set and the cookie transmission will
 *                        require a secure protocol (like HTTPS).
 * @type undefined
 *
 * @name $.cookie
 * @cat Plugins/Cookie
 * @author Klaus Hartl/klaus.hartl@stilbuero.de
 */

/**
 * Get the value of a cookie with the given name.
 *
 * @example $.cookie('the_cookie');
 * @desc Get the value of a cookie.
 *
 * @param String name The name of the cookie.
 * @return The value of the cookie.
 * @type String
 *
 * @name $.cookie
 * @cat Plugins/Cookie
 * @author Klaus Hartl/klaus.hartl@stilbuero.de
 */
jQuery.cookie = function(name, value, options) {
    if (typeof value != 'undefined') { // name and value given, set cookie
        options = options || {};
        if (value === null) {
            value = '';
            options.expires = -1;
        }
        var expires = '';
        if (options.expires && (typeof options.expires == 'number' || options.expires.toUTCString)) {
            var date;
            if (typeof options.expires == 'number') {
                date = new Date();
                date.setTime(date.getTime() + (options.expires * 24 * 60 * 60 * 1000));
            } else {
                date = options.expires;
            }
            expires = '; expires=' + date.toUTCString(); // use expires attribute, max-age is not supported by IE
        }
        var path = options.path ? '; path=' + options.path : '';
        var domain = options.domain ? '; domain=' + options.domain : '';
        var secure = options.secure ? '; secure' : '';
        document.cookie = [name, '=', encodeURIComponent(value), expires, path, domain, secure].join('');
    } else { // only name given, get cookie
        var cookieValue = null;
        if (document.cookie && document.cookie != '') {
            var cookies = document.cookie.split(';');
            for (var i = 0; i < cookies.length; i++) {
                var cookie = jQuery.trim(cookies[i]);
                // Does this cookie string begin with the name we want?
                if (cookie.substring(0, name.length + 1) == (name + '=')) {
                    cookieValue = decodeURIComponent(cookie.substring(name.length + 1));
                    break;
                }
            }
        }
        return cookieValue;
    }
};


/**
 * .cookieJar - Cookie Jar Plugin
 *
 * Version: 1.0.1
 * Updated: 2007-08-14
 *
 * Used to store objects, arrays or multiple values in one cookie, under one name
 *
 * Copyright (c) 2007 James Dempster (letssurf@gmail.com, http://www.jdempster.com/category/jquery/cookieJar/)
 *
 * Dual licensed under the MIT (MIT-LICENSE.txt)
 * and GPL (GPL-LICENSE.txt) licenses.
 **/

/**
 * Requirements:
 * - jQuery (John Resig, http://www.jquery.com/)
 * - cookie (Klaus Hartl, http://www.stilbuero.de/2006/09/17/cookie-plugin-for-jquery/)
 * - toJSON (Mark Gibson, http://jollytoad.googlepages.com/json.js)
 **/
(function($) {
    $.cookieJar = function(name, options) {
        if (!$.parseJSON) return false;
        if (!$.toJSON) return false;
        if (!$.cookie) return false;
        return new function() {
            /**
             * @access private
             **/
            function log(s) {
                if (typeof console != 'undefined' && typeof console.log != 'undefined') {
                    console.log('cookiejar:' + self.cookieName + ' ' + s);
                } else {
                    alert(s);
                }
            }
            ;

            /**
             * @access private
             **/
            function save() {
                if (self.options.debug) log('save ' + $.toJSON(self.cookieObject));
                return $.cookie(self.cookieName, $.toJSON(self.cookieObject), self.options.cookie);
            }
            ;

            /**
             * @access private
             **/
            function load() {
                var cookieJSON = $.cookie(self.cookieName);
                if (typeof cookieJSON == 'string') {
                    if (self.options.debug) log('load ' + cookieJSON);
                    self.cookieObject = $.parseJSON(cookieJSON, true);
                } else {
                    if (self.options.debug) log('load new');
                    self.cookieObject = {};
                    save();
                }
            }

            /**
             * cookieJar.set(name, value)
             *
             * Sets a value in the cookie jar using a name to identify it
             *
             * @access public
             * @param string name value identifier
             * @param mixed value any value, array or object
             * @return bool
             **/
            this.set = function(name, value) {
                if (self.options.debug) log('set ' + name + ' = ' + value);
                self.cookieObject[name] = value;
                return save();
            };

            /**
             * cookieJar.get(name)
             *
             * Gets a value from the cookie jar using a name to identify it
             *
             * @access public
             * @param string name value identifier
             * @return mixed stored value
             **/
            this.get = function(name) {
                if (!self.options.cacheCookie) {
                    load();
                }
                if (self.options.debug) log('get ' + name + ' = ' + self.cookieObject[name]);
                return self.cookieObject[name];
            };

            /**
             * cookieJar.remove([name])
             *
             * Removes a value from the cookie jar using a name to identify it
             * No name will clear the cookie jar of all values
             *
             * @access public
             * @param string name value identifier
             * @return bool
             **/
            this.remove = function(name) {
                if (self.options.debug) log('remove ' + name);
                if (typeof name != 'undefined') {
                    delete(self.cookieObject[name]);
                } else {
                    self.setFromObject({});
                }
                return save();
            };

            /**
             * cookieJar.setFromObject(object)
             *
             * Uses the object as the set of values to store in the cookie jar
             *
             * @access public
             * @param object object new values for the cookie jar
             * @return bool
             **/
            this.setFromObject = function(object) {
                if (typeof object == 'object') {
                    if (self.options.debug) log('setFromObject');
                    self.cookieObject = object;
                    return save();
                }
            };

            /**
             * cookieJar.toObject()
             *
             * Returns the contents of the cookie jar as an object
             *
             * @access public
             * @return object contents of the cookie jar
             **/
            this.toObject = function() {
                if (self.options.debug) log('toObject');
                return self.cookieObject;
            };

            /**
             * cookieJar.toString()
             *
             * Returns the contents of the cookie jar as a JSON encoded string
             *
             * @access public
             * @return string contents of the cookie jar as JSON
             **/
            this.toString = function() {
                if (self.options.debug) log('toString = ' + $.toJSON(self.cookieObject));
                return $.toJSON(self.cookieObject);
            };

            /**
             * cookieJar.destroy()
             *
             * Removes the cookie containing the cookie jar from the server
             *
             * @access public
             * @return bool
             **/
            this.destroy = function() {
                if (self.options.debug) log('destroy');
                self.cookieObject = {};
                return $.cookie(self.cookieName, null, self.options.cookie);
            };

            /**
             * cookieJar(name, [options])
             *
             * loads a cookie jar for the name provided, creates new if none found
             *
             * @param string name
             * @param object options
             * @return object cookieJar
             **/
            this.construct = function(name, options) {
                self.options = $.extend({
                    cookie: {
                        expires: 365,
                        path: '/'
                    },
                    cacheCookie:    true,
                    cookiePrefix:   'jqCookieJar_',
                    debug:          false
                }, options);

                self.cookieName = self.options.cookiePrefix + name;
                load();
                return self;
            };

            var self = this;
            self.construct(name, options);
        };
    };
})(jQuery);


/* Client-side access to querystring name=value pairs
    Version 1.2.3
    22 Jun 2005
    Adam Vandenberg
*/
function Querystring(qs) { // optionally pass a querystring to parse
    this.params = new Object()
    this.get = Querystring_get

    if (qs == null)
        qs = location.search.substring(1, location.search.length)

    if (qs.length == 0) return

// Turn <plus> back to <space>
    // See: http://www.w3.org/TR/REC-html40/interact/forms.html#h-17.13.4.1
    qs = qs.replace(/\+/g, ' ')
    var args = qs.split('&') // parse out name/value pairs separated via &

    // split out each name=value pair
    for (var i = 0; i < args.length; i++) {
        var value;
        var pair = args[i].split('=')
        var name = unescape(pair[0])

        if (pair.length == 2)
            value = unescape(pair[1])
        else
            value = name

        this.params[name] = value
    }
}

function Querystring_get(key, default_) {
    // This silly looking line changes UNDEFINED to NULL
    if (default_ == null) default_ = null;

    var value = this.params[key]
    if (value == null) value = default_;

    return value
}

(function ($) {
    var m = {
            '\b': '\\b',
            '\t': '\\t',
            '\n': '\\n',
            '\f': '\\f',
            '\r': '\\r',
            '"' : '\\"',
            '\\': '\\\\'
        },
        s = {
            'array': function (x) {
                var a = ['['], b, f, i, l = x.length, v;
                for (i = 0; i < l; i += 1) {
                    v = x[i];
                    f = s[typeof v];
                    if (f) {
                        v = f(v);
                        if (typeof v == 'string') {
                            if (b) {
                                a[a.length] = ',';
                            }
                            a[a.length] = v;
                            b = true;
                        }
                    }
                }
                a[a.length] = ']';
                return a.join('');
            },
            'boolean': function (x) {
                return String(x);
            },
            'null': function (x) {
                return "null";
            },
            'number': function (x) {
                return isFinite(x) ? String(x) : 'null';
            },
            'object': function (x) {
                if (x) {
                    if (x instanceof Array) {
                        return s.array(x);
                    }
                    var a = ['{'], b, f, i, v;
                    for (i in x) {
                        v = x[i];
                        f = s[typeof v];
                        if (f) {
                            v = f(v);
                            if (typeof v == 'string') {
                                if (b) {
                                    a[a.length] = ',';
                                }
                                a.push(s.string(i), ':', v);
                                b = true;
                            }
                        }
                    }
                    a[a.length] = '}';
                    return a.join('');
                }
                return 'null';
            },
            'string': function (x) {
                if (/["\\\x00-\x1f]/.test(x)) {
                    x = x.replace(/([\x00-\x1f\\"])/g, function(a, b) {
                        var c = m[b];
                        if (c) {
                            return c;
                        }
                        c = b.charCodeAt();
                        return '\\u00' +
                            Math.floor(c / 16).toString(16) +
                            (c % 16).toString(16);
                    });
                }
                return '"' + x + '"';
            }
        };

	$.toJSON = function(v) {
		var f = isNaN(v) ? s[typeof v] : s['number'];
		if (f) return f(v);
	};

	$.parseJSON = function(v, safe) {
		if (safe === undefined) safe = $.parseJSON.safe;
		if (safe && !/^("(\\.|[^"\\\n\r])*?"|[,:{}\[\]0-9.\-+Eaeflnr-u \n\r\t])+?$/.test(v))
			return undefined;
		return eval('('+v+')');
	};

	$.parseJSON.safe = false;

})(jQuery);

