$(function(){
    //  Implement tab pane
     new TabPane({
        element:'div#divProjectPropertiesTabPane',
        tabs:'div.Tabs ul li',
        pane:'div.Pane',
        current:'current',
        hide:'hide'
    });

    //  General editable list options
    var options={
                editableItem:'div.EditableItem',
                itemTemplate:'div.EditableItemTemplate',
                addAction:'a.actAddFilter',
                cancelAction:'input.actCancel',
                infoView:'span.InfoView',
                editView:'span.EditView'
                };

    //  Create a new editable list instance
    new AreasManager(options);
    new VersionsManager(options);
    new ResolutionsManager(options);
    new IssueTypesManager(options);
    new ClientsManager(options);
    new UsersManager(options);
});


function AreasManager(options){
    options.editableList='div#manageAreas div.EditableList';

    options.onItemAdded=function(item){
        alert("Added new area : "+item)
        
    }
    
    new EditableList(options);
}

function VersionsManager(options){
    options.editableList='div#manageVersions div.EditableList';

    options.onItemAdded=function(item){
        alert("Added new version : "+item)

    }

    new EditableList(options);
}

function ResolutionsManager(options){
    options.editableList='div#manageResolutions div.EditableList';

    options.onItemAdded=function(item){
        alert("Added new resolution: "+item)

    }

    new EditableList(options);
}

function IssueTypesManager(options){
    options.editableList='div#manageIssueTypes div.EditableList';

    options.onItemAdded=function(item){
    }

    new EditableList(options);
}

function ClientsManager(options){
    options.editableList='div#manageClients div.EditableList';

    options.onItemAdded=function(item){
        alert("Added new client : "+item)

    }

    new EditableList(options);
}

function UsersManager(options){
    options.editableList='div#manageUsers div.EditableList';

    options.onItemAdded=function(item){
        alert("Added new user : "+item)

    }

    new EditableList(options);
}

/**
*   Editable List
*/

function EditableList(options){
    var _editableList=$(options.editableList);
    var _existingItems=$(options.editableItem,_editableList);

//    console.log(_editableList.html());
    //  On the add action clicked

    //  Define general editable items settings
    var itemOptions={
        editAction:'li.actEdit',
        doneAction:'li.actDone',
        cancelAction:'li.actCancel',
        removeAction:'li.actRemove',
        action:'a',
        infoView:options.infoView,
        editView:options.editView,
        editableList:_editableList
    };

    //  Iterate through each editable item DOM element
    _existingItems.each(function(i,n){
        //  Configure settings for this editable item
        var settings={
            editableItem:n
        };

        //  Extend this items settings with default settings
        $.extend(settings,itemOptions);

        //  Create a new editable item instance
        new EditableListItem(settings);
    });

    function onAddNew(){
        //
        $(_editableList).fadeOut(function(){
            $('div.New form',_editableList).show();
        $('div.Items',_editableList).hide();
            _editableList.fadeIn();
        });

        return false;
    }

    function onCancelNew(){
        $('div.New form',_editableList).fadeOut(function(){
        $(options.addAction,_editableList).show();
        $('div.Items',_editableList).show();    
        });

        return false;
    }

    $(options.addAction,_editableList).bind('click',onAddNew);

    $(options.cancelAction,_editableList).bind('click',onCancelNew);
}

/**
*   Editable List Item
*/
function EditableListItem(options){
    var _form=$('form',options.editableItem);
    
    function ShowEditStuff(){
        $(options.editView,options.editableItem).slideDown();
        $(options.doneAction+","+options.cancelAction,options.editableItem).removeClass('hide');

        $(options.editableItem).addClass('editing');
        
        $(options.editAction+","+options.removeAction,options.editableItem).addClass('hide');
    }


    function ShowInfoStuff(){
        $(options.editAction+","+options.removeAction,options.editableItem).removeClass('hide');

        $(options.editView,options.editableItem).slideUp();
        $(options.editableItem).removeClass('editing');
        $(options.doneAction+","+options.cancelAction,options.editableItem).addClass('hide');
    }

    function copyValuesFromSpanToField(){
        //  Iterate all spans in the infoview
        $(options.infoView+' span',options.editableItem).each(function(i,n){
            var spanName=$(n).attr('rel');
            var query=options.editView+" input[name='"+spanName+"']";
            $(query,options.editableItem).val($(n).html());
        });
    }
    
    //  On edit action clicked
    function onEditClicked(){
        ShowEditStuff();
        return false;
    }

    //  On done action clicked
    function onDoneClicked(){
       
        //  Ajax submit here!!!

        function showRequest(formData, jqForm, options) {
            // formData is an array; here we use $.param to convert it to a string to display it
            // but the form plugin does this for you automatically when it submits the data
            var queryString = $.param(formData);

            return true;
        }

        // post-submit callback
        function showResponse(responseText, statusText)  {
        
        }

         var options = {
            beforeSubmit:  showRequest,  // pre-submit callback
            success:showResponse,  // post-submit callback
             
             type:'post'
         }

       
        _form.submit();



        return false;
    }

    //  On cancel action clicked
    function onCancelClicked(){
        copyValuesFromSpanToField();
        ShowInfoStuff();
        return false;
    }

    //  On remove action clicked
    function onRemoveClicked(){
        //return false;
    }

    //  Bind event delegates to action elements
    $(options.editAction+' '+options.action,options.editableItem).bind('click',onEditClicked);
    $(options.doneAction+' '+options.action,options.editableItem).bind('click',onDoneClicked);
    $(options.cancelAction+' '+options.action,options.editableItem).bind('click',onCancelClicked);
    $(options.removeAction+' '+options.action,options.editableItem).bind('click',onRemoveClicked);

    //  Bind event delegates to action elements
    $(options.editAction+' '+options.action,options.editableItem).bind('keydown',function(eventObject){
        wasSpaceOrEnterKey(eventObject,onEditClicked);
    });
    $(options.doneAction+' '+options.action,options.editableItem).bind('keydown',function(eventObject){
        wasSpaceOrEnterKey(eventObject,onDoneClicked);
    });
    $(options.cancelAction+' '+options.action,options.editableItem).bind('keydown',function(eventObject){
        wasSpaceOrEnterKey(eventObject,onCancelClicked);
    });
    $(options.removeAction+' '+options.action,options.editableItem).bind('keydown',function(eventObject){
        wasSpaceOrEnterKey(eventObject,onRemoveClicked);
    });

    function wasSpaceOrEnterKey(eventObject,callback){
        if(eventObject.keyCode==32 || eventObject.keyCode==13){
          callback();
        }
    }


}

