$(function(){
    var userid=$('input#current_user_id').val();
    
    //  If the user chooses themselves as assignee, hide and disable the notify checkbox
    function onAssigneeChange(){
        if(userid==$(this).val()){
            $('span#iNotifyAssignee').hide()
            $('span#iNotifyAssignee input').attr('disabled','disabled');
        }else{
            $('span#iNotifyAssignee input').attr('disabled','');
            $('span#iNotifyAssignee').show();

        }
    }
    
    $('select#frmCreateIssue_frmAssignedTo_id').bind('change',onAssigneeChange);

    //  Trigger onload
    $('select#frmCreateIssue_frmAssignedTo_id').trigger('change');

    var oDescriptionOptions={partDescription:$('div#iBasicDescription')[0],
                             fullDescription:$('div#iFullDescription')[0]
                            };
    var oDescriptionController=new DescriptionController(oDescriptionOptions);

    $('a#lnkHelpWithDesc').bind('click',function(){
        $('li#liDescriptionHelpContainer').hide();
        oDescriptionController.showFullDescription();
    });

    //  Add More Detail
    var _oMoreDetailOptions={detailPanel:$('div#iMoreDetailPanel')[0]}
    var _oMoreDetailController=new MoreDetailController(_oMoreDetailOptions);

    $('a#lnkAddMoreDetail').bind('click',function(){
        _oMoreDetailController.showMoreDetail();
        $('a#lnkAddMoreDetail').addClass('hide');

        if($('a#lnkAddAnAttachment').hasClass('hide')==true){
            $('div.protoMenuBar').addClass('hide');
        }

        return false;
    });

    //  Action to close attachment panel
    function closeAttachmentPanel(){
        $('a#lnkAddAnAttachment').addClass('show');
        $('div#iAttachmentContainer').hide();
        _oCloneableTemplate.onCancel();
        return false;
    }

    $('a#lnkCancelAddAttachment').bind('click',closeAttachmentPanel);

    var attachmentPanelOptions={
            rootNode:$('div#iFileUploadContainer')[0],
            removeClass:'a._actRemove',
            onAdded:function(oNode){
                enableFieldsInDiv($('div#iAttachmentContainer')[0]);
            },
            onAllRemoved:function(){
                $('a#lnkAddAnAttachment').show();
                $('div#iAttachmentContainer').hide();
                $('div.protoMenuBar').removeClass('hide');
                //}
                disableFieldsInDiv($('div#iAttachmentContainer')[0]);
            }
        }

    var _oCloneableTemplate=new CloneableTemplateDecorator(attachmentPanelOptions);

    $('a#lnkAddAnAttachment').bind('click',function(){
        $('a#lnkAddAnAttachment').addClass('hide');
        $('div#iAttachmentContainer').show();

        if($('a#lnkAddMoreDetail').hasClass('hide')==true){
            $('div.protoMenuBar').addClass('hide');
        }
        _oCloneableTemplate.begin();
        return false;
    });

    
    $('a#lnkAddAnotherFile').bind('click',function(){
            _oCloneableTemplate.clone();
            return false;
        });


    //$('select#frmCreateIssue_frmProject_id')[0].selectedIndex=0;
    $('select#frmCreateIssue_frmProject_id').bind('change',function(){
        $('select#subProject_id').attr('disabled','true');
        $('select#frmCreateIssue_frmIssueType_id').attr('disabled','true');
         
        
        var projectId=this.options[this.selectedIndex].value;
        //  @todo Need to be able to access this ajax method without being an admin, need to refactor servierside code into a reachable class
        new JsonCall('/subprojects.json?projectId='+projectId,{},function(oData){
            var oSelect=$('select#subProject_id')[0];
            $(oSelect).html("");
            $.each(oData,function(i,n){
                var oOption=document.createElement('option');
                $(oOption).html(n.name);
                $(oOption).val(n.id);
                oSelect.appendChild(oOption);
            });
            $('select#subProject_id').attr('disabled','');
        });

        //  Issue Types
        new JsonCall('/issuetypes.json?project='+projectId,{},function(oData){
            var oSelect=$('select#frmCreateIssue_frmIssueType_id')[0];
            $(oSelect).html("");
            $.each(oData,function(i,n){
                var oOption=document.createElement('option');
                $(oOption).html(n.name);
                $(oOption).val(n.id);
                oSelect.appendChild(oOption);
            });
            $('select#frmCreateIssue_frmIssueType_id').attr('disabled','');
        });

        //  Versions
        new JsonCall('/versions/fixfor.json?project='+projectId,{},function(oData){
            
            var oSelect=$('select#frmCreateIssue_frmFixFor_id')[0];
            var oSelect2=$('select#frmCreateIssue_frmFixIn_id')[0];
            if(oSelect && oSelect2){
            	$(oSelect).html("");
                $(oSelect2).html("");

                $.each(oData,function(i,n){
                    var oOption=document.createElement('option');
                    $(oOption).html(n.name);
                    $(oOption).val(n.id);
                    oSelect.appendChild(oOption);

                    var oOption2=document.createElement('option');
                    $(oOption2).html(n.name);
                    $(oOption2).val(n.id);
                    oSelect2.appendChild(oOption2);

                });

                $(oSelect).attr('disabled','');
                $(oSelect2).attr('disabled','');
            }
        });

    })

});

//  Class's go down here
function DescriptionController(options){
    var _options=options;

    this.showFullDescription=function(){
        $(_options.partDescription).hide();
        $(_options.fullDescription).show();
    }

    this.showPartDescription=function(){
        $(_options.fullDescription).hide();
        $(_options.partDescription).show();
    }
}

function AttachmentController(){
    this.showAttachmentsPanel
}

function MoreDetailController(options){
    var _options=options;
    this.showMoreDetail=function(){
        $(_options.detailPanel).removeClass('hide');
        enableFieldsInDiv(_options.detailPanel);
    }

    this.hideMoreDetail=function(){
        $(_options.detailPanel).addClass('hide');
        disableFieldsInDiv(_options.detailPanel);
    }
}


