$(function(){
    new Hoverable({
        elements:$('div.ProjectListPanel table tbody tr'),
        class:'itemHover'
    });

    new Clickable({
        elements:$('div.ProjectListPanel table tbody tr'),
        callback:function(object){
            location.href=$('td:eq(0) a',object).attr('href');
        }
    });
});


function Hoverable(options){
    var _last=null;
    var _current=null;
    
    function forEachElement ( i , n ){
        $(this).bind('mouseover',onMouseOver);
    }

    function onMouseOver(){
        _current=this;

        if(_last){
            $(_last).removeClass(options.class);
        }

        $(_current).addClass(options.class);
        _last=_current;
    }
    $(options.elements).each(forEachElement);
}

function Clickable(options){
    var _last=null;
    var _current=null;

    function forEachElement ( i , n ){
        $(this).bind('click',onClick);
    }

    function onClick(){
        options.callback(this);
    }
    
    $(options.elements).each(forEachElement);
}