<%@ include file="/common/taglibs.jsp" %>

<head>
    <title>${name} [<fmt:message key="title.projects.overview"/>]</title>
    <meta name="menu" content="projects"/>
    <script type="text/javascript" src="/scripts/com/hedgehoglab/fixx/controller/ProjectController.js?<fmt:message key="webapp.version"/>"></script>
</head>


<c:set var="panelContent">
    <div class="Pane">
        <h2>${fn:escapeXml(name)}</h2>
            <div class="Project">
					<div class="Summary" id="project_${id}">
					<h3 class="vcard"><span class="fn"><fmt:message key="label.project.lead"/>: <a href="${ctx}/profile/${owner.id}">${fn:escapeXml(owner.fullName)}</a></span></h3>
					<p>
					<c:choose>
					<c:when test="${fn:length(description) > 250}">
					${fn:substring(description, 0, 250)}...
					</c:when>
					<c:otherwise>
					${fn:escapeXml(description)}
					</c:otherwise>
					</c:choose>
					</p>
					</div>

					<div class="Metadata">
                        <dl>
                            <dt><a href="${ctx}/issues?qProject=${id}"><fmt:message key="label.open.issues"/></a></dt>
                            <dd><em><s:property value="getOpenIssueCount(model)"/></em></dd>

                            <dt><a href="${ctx}/issues?qProject=${id}&qStatus=Resolved"><fmt:message key="label.closed.issues"/></a></dt>
                            <dd><em><s:property value="getClosedIssueCount(model)"/></em></dd>
                        </dl>
										</div>
					<div class="Metadata">
						<ul>
							<c:if test="${currentUser != null && !archived}">
								<li><a class="actCreateIssue" href="${ctx}/issues/new?frmProject.id=${id}"><fmt:message key="action.projects.newissue"/></a></li>
							</c:if>
								<li><a class="actViewRoadmap" href="${ctx}/projects/${id}/?view=roadmap"><fmt:message key="action.projects.roadmap"/></a></li>
						</ul>
					</div>

					</div>
        
    </div>

    <div class="Pane">
             <h2><fmt:message key="heading.open.issues"/></h2>
            <c:if test="${fn:length(subprojects) > 0}">
                <div class="ProjectInfoPanel ppFirst">
                    <h3><fmt:message key="heading.by.areas"/></h3>
                    <dl>
                        <s:iterator value="subprojects" id="subProject">
                            <s:if test="getOpenIssueCount(#subProject) > 0">
                                <dt>
                                    <a href="${ctx}/issues?qArea=${subProject.id}&qProject=${model.id}">${fn:escapeXml(subProject.name)}</a>
                                </dt>
                                <dd>
                                    <em><s:property value="getOpenIssueCount(#subProject)"/></em>
                                </dd>
                            </s:if>
                        </s:iterator>



                    </dl>
                </div>
            </c:if>
            <c:if test="${fn:length(versions) > 0}">
                <div class="ProjectInfoPanel">
                    <h3><fmt:message key="heading.by.versions"/></h3>
                    <dl>
                        <s:iterator value="versions" id="version">
                            <s:if test="getOpenIssueCount(#version) > 0">
                                <dt>
                                    <a href="${ctx}/issues?qFixFor=${version.id}&qProject=${model.id}">${fn:escapeXml(version.name)}</a>
                                </dt>
                                <dd>
                                    <em><s:property value="getOpenIssueCount(#version)"/></em>
                                </dd>
                            </s:if>
                        </s:iterator>
                    </dl>
                </div>
            </c:if>

            <c:if test="${fn:length(priorities) > 0}">
                <div class="ProjectInfoPanel">
                    <h3><fmt:message key="heading.by.priorities"/></h3>
                    <dl>
                        <s:iterator value="priorities" id="priority">
                            <s:if test="getOpenIssueCount(#priority,model) > 0">
                                <dt>
                                    <a href="${ctx}/issues?qPriority=${priority.id}&qProject=${model.id}">${fn:escapeXml(priority.name)}</a>
                                </dt>
                                <dd>
                                    <em><s:property value="getOpenIssueCount(#priority,model)"/></em>
                                </dd>
                            </s:if>
                        </s:iterator>
                    </dl>
                </div>
            </c:if>

            <c:if test="${fn:length(assignees) > 0}">
                <div class="ProjectInfoPanel">
                    <h3><fmt:message key="heading.by.assignees"/></h3>
                    <dl>
                        <s:iterator value="assignees" id="user">
                            <s:if test="getOpenIssueCount(#user,model) > 0">
                                <dt>
                                    <a href="${ctx}/issues?qAssignedTo=${user.id}&qProject=${model.id}">${fn:escapeXml(user.fullName)}</a>
                                </dt>
                                <dd>
                                    <em><s:property value="getOpenIssueCount(#user,model)"/></em>
                                </dd>
                            </s:if>
                        </s:iterator>
                    </dl>
                </div>
            </c:if>
    </div>
</c:set>


<div class="fullContent">
    <c:import url="/WEB-INF/pages/includes/projects/menu/edit.jsp">
        <c:param name="pageName" value="Projects"/>
        <c:param name="content" value="${panelContent}"/>
        <c:param name="id" value="${id}"/>
    </c:import>
</div>
