<%@ include file="/common/taglibs.jsp" %>

<head>
    <title>${name} [<fmt:message key="title.projects.releasenotes"/>]</title>
    <meta name="menu" content="projects"/>
</head>

<c:set var="panelContent">
    <s:set var="prjct" value="name"/>
    <c:if test="${fn:length(orderedVersions) > 0}">
    	<s:iterator value="orderedVersions" id="version" status="versionStatus">
    	  <c:set var="versionOpenIssuesCount">
	        <s:property value="getOpenIssueCount(#version)"/>
	      </c:set>
	      <c:set var="versionClosedIssuesCount">
	      	<s:property value="getClosedIssueCount(#version)"/>
	      </c:set>
	      <c:set var="versionTotalIssuesCount">${versionOpenIssuesCount+versionClosedIssuesCount}</c:set>

            <div class="Pane  <s:if test="#versionStatus.last">lastPane</s:if>">
            <div class="versionHeader ">
              <h2 id="${id}">
			 <span class="perma"><a rel="bookmark" href="#${id}" title="Permalink">#</a></span>               
              ${fn:escapeXml(prjct)} &rarr; Version : ${fn:escapeXml(name)}

                <span>&nbsp;-&nbsp;
                    <c:if test="${release==null}">[ No release date available ]</c:if>
                      <c:if test="${release!=null}">Released [<s:date name="release" format="dd MMMM yyyy"/>]</c:if>
                  </span>
              </h2>

                <div class="versionMetaData">
                  <c:choose>
                    <c:when test="${versionTotalIssuesCount > 0}">
                      <p><fmt:message key="label.infobar.closed.issues">
                        <fmt:param value="${versionClosedIssuesCount}"/>
                        <fmt:param value="${versionTotalIssuesCount}"/>
                      </fmt:message></p>
                    </c:when>
                    <c:otherwise>
                         <div class="feedback notification">
                        <p><fmt:message key="label.version.closed.issues.null"/></p>
                        </div>
                    </c:otherwise>
                  </c:choose>
                </div>
                <c:if test="${(versionClosedIssuesCount) > 0}">
				<div class="GenericTable">                
                  <table id="tblRoadmap">
                    <tbody>
                      <s:set name="myClosedIssues" value="getClosedIssues(#version)"/>
                      <s:iterator value="myClosedIssues" id="versionIssue">
                        <tr class="hentry">
                          <td class="issue entry-title"><a href="/issues/${id}">${id}</a></td>
                          <td class="priority">${fn:escapeXml(type.name)}</td>
                          <td class="title entry-content">${fn:escapeXml(title)}</td>
                          <td class="assigned vcard"><span class="fn author">${fn:escapeXml(assignedTo.fullName)}</span></td>
                        </tr>
                      </s:iterator>
                    </tbody>
                  </table>
				</div>
                </c:if>
            </div>
            </div>

        </s:iterator>
    </c:if>
</c:set>

<div class="fullContent ">
    <c:import url="/WEB-INF/pages/includes/projects/menu/edit.jsp">
        <c:param name="pageName" value="Releasenotes"/>
        <c:param name="content" value="${panelContent}"/>
        <c:param name="id" value="${id}"/>
    </c:import>
</div>