<%@ include file="/common/taglibs.jsp" %>

<head>
    <title><fmt:message key="title.projects.list"/></title>
    <meta name="menu" content="projects"/>
    <script type="text/javascript" src="/scripts/com/hedgehoglab/fixx/controller/ProjectIndexController.js?<fmt:message key="webapp.version"/>"></script>
</head>

	<div class="rightPanel">
        <c:if test="${currentUser != null}">

        <div class="PropertyPane">
               <h2><fmt:message key="heading.projects.archived"/> (${fn:length(archivedProjects)})</h2>
                <div class="Pane">
                    <ul>
                    <s:iterator value="archivedProjects" id="project">
                        <li><a href="${ctx}/projects/${id}">${fn:escapeXml(name)}</a></li>
                    </s:iterator>
                </ul>
                </div>
        </div>
        </c:if>
        
        <div class="PropertyPane">
            <h2><fmt:message key="heading.help"/></h2>
            <div class="Pane">
                    <p><fmt:message key="text.projects.inactive.explain"/></p>
            </div>
        </div>
    </div>
	
	<div class="realContent">
        <div class="TabPanel">

            <div class="Pane ProjectListPanel">
				 <h2 class="Section"><fmt:message key="heading.projects.active"/> (${fn:length(activeProjects)})</h2>
                <c:if test="${fn:length(activeProjects) > 0}">
                    <div class="GenericTable GreyTable">
                        <display:table name="activeProjects" decorator="com.hedgehoglab.fixx.renderer.decorator.ProjectListTableDecorator" id="activeproject" requestURI="${ctx}/projects" defaultorder="descending">
                            <display:column titleKey="label.project.name" class="Name first" property="projectName" sortable="true" sortProperty="name" escapeXml="false"/>
                            <display:column titleKey="label.project.description" class="Description" property="description" sortable="true" escapeXml="true"/>
                            <display:column titleKey="label.project.owner" class="Owner" headerClass="Owner" property="owner.fullName" sortable="true" escapeXml="true"/>
                            <display:column titleKey="label.project.issuesresolved" class="last darker">
                                <div class="graph">
                                        <s:set var="activeProjectId">${activeproject.id}</s:set>
                                        <strong class="bar" style="width: <s:property value="100-getOpenIssuePercentageById(#activeProjectId)"/>%">
                                        <span><s:property value="100-getOpenIssuePercentageById(#activeProjectId)"/>%</span>
                                        </strong>
                                    </div>
                            </display:column>
                        </display:table>
                    </div>
                </c:if>
                <c:if test="${fn:length(activeProjects) == 0}">
                    <div class="feedback notification">
                        <p>No active projects</p>
                    </div>
                </c:if>
            </div><!-- end .pane -->
            <div class="Pane ProjectListPanel">
                <h2 class="Section InactiveProjects"><fmt:message key="heading.projects.inactive"/> (${fn:length(inactiveProjects)}) </h2>
                <c:if test="${fn:length(inactiveProjects) > 0}">
                <div class="GenericTable GreyTable">
                    <display:table name="inactiveProjects" decorator="com.hedgehoglab.fixx.renderer.decorator.ProjectListTableDecorator" id="inactiveproject" requestURI="${ctx}/projects" sort="list" defaultorder="descending">
                            <display:column titleKey="label.project.name" class="Name first" property="projectName" sortProperty="name" sortable="true"/>
                            <display:column titleKey="label.project.description" class="Description" property="description" sortable="true" escapeXml="true"/>
                            <display:column titleKey="label.project.owner" class="Owner" headerClass="Owner" property="owner.fullName" sortable="true" escapeXml="true"/>
                            <display:column titleKey="label.project.issuesresolved" class="last darker" escapeXml="false">
                            <div class="graph">
                                    <s:set var="inactiveProjectId">${inactiveproject.id}</s:set>
                                    <strong class="bar" style="width: <s:property value="100-getOpenIssuePercentageById(#inactiveProjectId)"/>%">
                                    <span><s:property value="100-getOpenIssuePercentageById(#inactiveProjectId)"/>%</span>
                                    </strong>
                                </div>
                        </display:column>
                    </display:table>
                </div>
                    </c:if>
                <c:if test="${fn:length(inactiveProjects) == 0}">
                    <div class="feedback notification">
                        <p>No in-active projects</p>
                    </div>
                </c:if>
            </div>
        </div>
    </div>
    
                
                
                


           
          