<%@ include file="/common/taglibs.jsp" %>
<head><title>${name} [<fmt:message key="title.projects.changelog"/>]</title>
<meta name="menu" content="projects"/>
</head>

<c:set var="panelContent">
    <div class="Pane lastPane">
    <h2><fmt:message key="heading.project.changelog"><fmt:param value="${name}"/></fmt:message></h2>
    <c:choose>
        <c:when test="${fn:length(changeLogs) > 0}">
            <div class="GenericTable">
                <table id="tblChangeLog">
                <tbody>
                <s:iterator value="changeLogs" status="changelogStatus" id="changeLogItem">
                    <tr class="hentry">
                    <td class="event entry-summary">
                        <c:import url="/common/controls/IssueChangeLogEvent.jsp">
                            <c:param name="event" value="${event}"/>
                        </c:import>
                    </td>
                    <td class="issue entry-title">
                        <span><a href="${ctx}/issues/${object_reference}">${object_reference}</a></span>
                    </td>                    
                    <td class="comment entry-content">
                        <fixx:textileFilter>${comment}</fixx:textileFilter>
                    </td>
                    <td class="assigned vcard">
                    	<span class="fn author">
                        <c:choose>
                            <c:when test="${user != null}">
                                ${user.fullName}
                            </c:when>
                            <c:otherwise>
                                ${staticUserName}
                            </c:otherwise>
                        </c:choose>
                        	</span>
                    </td>
                    <td class="date">
            		<abbr class="updated" title="<s:date name="created" format="yyyyMMdd"/>T<s:date name="created" format="HHmmZ"/>">
            			<s:date name="created" format="struts.date.format.past" nice="true"/>
            		</abbr>
            		</td>
                    </tr>
                </s:iterator>
                </tbody>
                </table>
            </div>
        </c:when>
        <c:otherwise>
            <div class="feedback notification">
            <p>There have been no changes logged for this project.</p>
            </div>
        </c:otherwise>
    </c:choose>

    </div>
</c:set>
	
<div class="fullContent">
        <c:import url="/WEB-INF/pages/includes/projects/menu/edit.jsp">
          <c:param name="pageName" value="Changelog"/>
          <c:param name="content" value="${panelContent}"/>
          <c:param name="id" value="${id}"/>
        </c:import>		
  </div>


