<%@ include file="/common/taglibs.jsp" %>

<head>
    <title><fmt:message key="title.profile"/></title>
    <meta name="menu" content="Profile"/>
</head>
<div class="realContent">
    <div class="TabPanel">
        <div class="Pane">
            <h2>
                <fmt:message key='heading.profile'/>
            </h2>

            <div class="Panel Cleared">
                <p class="PanelRow"><span><fmt:message key="label.user.username"/></span> ${fn:escapeXml(username)}</p>
                
                <c:if test="${currentUser != null && (currentUser.normalUser || currentUser.administrator)}">
                	<p class="PanelRow"><span><fmt:message key="label.user.email"/></span> <a href="mailto:${email}">${email}</a></p>
                </c:if>
                <p class="PanelRow"><span><fmt:message key="label.user.firstName"/></span> ${fn:escapeXml(firstName)}</p>

                <p class="PanelRow"><span><fmt:message key="label.user.lastName"/></span> ${fn:escapeXml(lastName)}</p>

                <c:if test="${currentUser != null && (currentUser.normalUser || currentUser.administrator)}">
                	<p class="PanelRow"><span><fmt:message key="label.user.phoneNumber"/></span> ${fn:escapeXml(phoneNumber)}</p>
                </c:if>

                <p class="PanelRow"><span><fmt:message key="label.user.website"/></span> <s:a href="%{website}">${fn:escapeXml(website)}</s:a></p>
            </div>
        </div>
    </div>
</div>

