<%@ include file="/common/taglibs.jsp" %>

<head>
    <title><fmt:message key="title.profile"/></title>
    <meta name="menu" content="Profile"/>
</head>
<div class="realContent">
    <div class="TabPanel">
        <div class="Pane">
            <s:form method="post" action="profile/%{id}">
                <s:hidden name="_method" value="put"/>
                <h2>
                    <fmt:message key='heading.profile.accountinfo'/>
                </h2>
                <span class="Field ClearedField"><s:textfield key="label.user.username" name="username" required="true" theme="xhtml" readonly="true" cssClass="noborder"/></span>
                <span class="Field ClearedField"><s:textfield key="label.user.firstName" name="firstName" theme="xhtml" /></span>
                <span class="Field ClearedField"><s:textfield key="label.user.lastName" name="lastName" theme="xhtml"/></span>
                <span class="Field MediumField ClearedField"><s:textfield key="label.user.email" name="email" required="true" theme="xhtml"/></span>
        </div>
        <div class="Pane">
        	<h2><fmt:message key="heading.profile.changepassword"/></h2>
        	<p><fmt:message key="text.profile.changepassword"/></p>
        	<span class="Field ClearedField"><s:password key="label.user.password" name="new_password" theme="xhtml" /></span>
        	<span class="Field ClearedField"><s:password key="label.user.confirmPassword" name="confirmPassword" theme="xhtml" /></span>
        </div>
        <div class="Pane">
                <h2><fmt:message key='heading.profile.optionalinfo'/></h2>
                <p><fmt:message key="text.profile.openid"/></p>
                <span class="Field MediumField ClearedField"><s:textfield key="label.user.openid" name="openid" theme="xhtml"/></span>
                <s:if test="twitterEnabled">
	                <p><fmt:message key="text.profile.twitter"/></p>
	                <span class="Field LargeField ClearedField"><s:textfield key="label.user.twitterid" name="twitterid" theme="xhtml"/></span>
	            </s:if>
                <span class="Field ClearedField"><s:textfield key="label.user.phoneNumber" name="phoneNumber" theme="xhtml"/></span>
                <span class="Field MediumField ClearedField"><s:textfield key="label.user.website" name="website" theme="xhtml"/></span>
                <div class="Actions">
                    <ul>
                        <li><s:submit theme="xhtml" key="action.updateprofile"/></li>
                    </ul>

                </div>
            </s:form>
        </div>
        
        <div class="Pane">
            <s:form method="post" action="profile/%{id}" enctype="multipart/form-data">
                <s:hidden name="_method" value="put"/>
                <h2><fmt:message key='heading.profile.photo'/></h2>
                <span class="Field MediumField">
                    <label class="img"><img src="<s:property value="getUserAvatar(id)"/>"/></label>
                    <s:file name="frmAvatar" theme="xhtml"/>
                </span>

                <div class="Actions">
                    <ul>
                        <li><s:submit theme="xhtml" key="action.uploadphoto"/></li>
                    </ul>

                </div>
            </s:form>
        </div>
    </div>
</div>