<%@ include file="/common/taglibs.jsp" %>
<head>
    <title><fmt:message key="menu.login"/></title>
    <meta name="menu" content="login"/>
    <script type="text/javascript" src="/scripts/com/hedgehoglab/fixx/controller/LoginController.js?<fmt:message key="webapp.version"/>"></script>
</head>
<c:if test="${!empty pageContext.request.remoteUser}">
	<c:redirect url="${ctx}/"/>
</c:if>
<div class="smallContent " id="LoginDialog">
    <div class="TabPanel">
        <div id="iLogin" class="Pane">
            <form method="post" id="loginForm" action="<c:url value='/j_spring_security_check'/>">
            <h2><fmt:message key="heading.login"/><c:if test="${publicMode && validLicense}"><fmt:message key="text.or"/>&nbsp;<a href="${ctx}/signup" title="<fmt:message key="action.login.signup"/>"><fmt:message key="action.login.signup"/></a></c:if>
            </h2>
            <c:if test="${param.forced != null}">
            	<div class="feedback">
            		<p><fmt:message key="text.forcedlogout"/></p>
            	</div>
            </c:if>
            <c:if test="${param.reset != null}">
                <div class="feedback">
                    <p><fmt:message key="text.resetpassword.success"/></p>
                </div>
            </c:if>
            <c:if test="${param.signup != null}">
	            <div class="feedback">
	                <p><fmt:message key="text.signup.success"/></p>
	            </div>
	        </c:if>
            <c:if test="${param.resetemail != null}">
                <div class="feedback">
                    <p><fmt:message key="text.resetpassword.emailsent"/></p>
                </div>
            </c:if>
            <c:if test="${param.error != null}">
                <div class="feedback error">
                    <p><fmt:message key="errors.password.mismatch"/></p>
                </div>
            </c:if>
            <c:if test="${param.from != null && param.from == 'setup'}">
            	<div class="feedback">
            		<p><fmt:message key="text.setup.success"/></p>
            	</div>
                <input type="hidden" id="pFromSetup" value="true"/>
            </c:if>
            <span class="Field ClearedField">
                <label for="j_username" class="required desc"><fmt:message key="label.username"/><!-- <span class="req">*</span>--></label>
                <input type="text" class="text medium" name="j_username" id="j_username" tabindex="1"/>
            </span>
            <span class="Field ClearedField">
                <label for="j_password" class="required desc"><fmt:message key="label.password"/><!-- <span
                        class="req">*</span>--></label>
                <input type="password" class="text medium" name="j_password" id="j_password" tabindex="2"/><a href="#" id="aResetPassword"><fmt:message key="action.forgotpassword"/></a>

            </span>
            <span class="Field ClearedField rememberMeCheckBox">
            		            <input type="checkbox" class="checkbox" name="_spring_security_remember_me" id="rememberMe" tabindex="3"/>
            		            <label for="rememberMe" class="choice"><fmt:message key="label.login.rememberme"/></label>

            </span>
            <div class="ButtonGroup Cleared">
                <input type="submit" class="button" name="login" value="<fmt:message key='action.login'/>"
                       tabindex="4"/>&nbsp;
                                      <fmt:message key="text.or"/>&nbsp;
                <a href="#" id="aOpenidLogin"><fmt:message key="action.login.openid"/></a>

            </div>          
            <c:if test="${publicMode}">
	            <div>
	            <!--	<p><fmt:message key="text.login.noaccount"/> <a href="${ctx}/signup" title="<fmt:message key="action.login.signup"/>"><fmt:message key="action.login.signup"/></a></p>-->

	            </div>
	        </c:if>
            </form>
        </div>
        <div id="iResetPassword" class="Pane hide">
        <form method="post" id="resetPasswordForm" action="<c:url value='/password'/>">
            <h2><fmt:message key="heading.resetpassword"/></h2>
             <p id="dlgResetPasswordHelp"><fmt:message key="help.resetpassword"/></p>
             <c:if test="${param.resetfail != null}">
                 <div class="feedback error">
                            <p><fmt:message key="text.resetpassword.fail"/></p>
                            <input type="hidden" id="pResetFail" value="true"/>
                 </div>
             </c:if>
            <div id="dlgEmailConfirmation" class="hide">
                <p><fmt:message key="text.resetpassword.emailsent"/></p>
            </div>

            <c:if test="${param.resetnotempty != null}">
            <div class="feedback error">
                    <p><fmt:message key="text.resetpassword.notempty"/></p>
                    <input type="hidden" id="pResetFail" value="true"/>
            </div>
            </c:if>
            <span class="Field ClearedField">
                <label for="username" class="required desc"><fmt:message key="label.user.username"/><!-- <span class="req">*</span>--></label>
                <input type="text" class="text medium" name="username" id="username" tabindex="1" value="${param.username}"/>
            </span>

            <div class="ButtonGroup Cleared">
                        <input type="submit" class="button" name="reset" value="<fmt:message key='action.resetpassword'/>" tabindex="2"/>&nbsp;<fmt:message key="text.or"/>&nbsp;<a href="#" id="aLogin" ><fmt:message key="action.cancel"/></a>

            </div>
        </form>
        </div>
        <div id="iOpenidLogin" class="Pane hide">
            <c:choose>
                <c:when test="false">
                    <p><fmt:message key="help.login.openid.localhost"/></p>
                    <a href="#" id="aNormalLogin"><fmt:message key="action.login.normal"/></a>
                </c:when>
                <c:otherwise>
                    <form method="post" id="openidLoginForm" action="<c:url value='/j_spring_openid_security_check'/>">
                    <h2><fmt:message key="heading.login"/></h2>
                        <c:if test="${param.openiderror != null}">
                 <div class="feedback error">
                    <p><fmt:message key="text.openiderror"/></p>
                    <input type="hidden" id="pOpenidFail" value="true"/>
                 </div>
             </c:if>
                    <span class="Field ClearedField">
                        <label for="j_username" class="required desc"><fmt:message key="label.user.username.openid"/><!-- <span class="req">*</span>--></label>
                        <input type="text" class="text medium" name="j_username" id="j_username" tabindex="1"/>
                    </span>
                    <div class="ButtonGroup Cleared">
						<input type="submit" class="button" name="login" value="<fmt:message key='action.signin'/>" tabindex="4"/>&nbsp;<fmt:message key="text.or"/>&nbsp;<a href="#" id="aNormalLogin"><fmt:message key="action.login.normal"/>  
                    </div>
                    </form>
                </c:otherwise>
            </c:choose>
        </div>
    </div>
</div>
