<%@ include file="/common/taglibs.jsp" %>
<head>
    <title><fmt:message key="title.issues.list"/></title>
    <meta name="menu" content="issues"/>
    <script type="text/javascript" src="/scripts/com/hedgehoglab/fixx/controller/IssueIndexController.js?<fmt:message key="webapp.version"/>"></script>
</head>

<c:set var="panelContent">
<c:if test="${query!=null}">
	<div class="feedback notification">
		<ul><li>
		<fmt:message key="text.search.issues">
		    <fmt:param value="${fn:escapeXml(query)}"/>
		    <fmt:param value="${issuesSearchCount}"/>
		</fmt:message>
		</li></ul>
	</div>
</c:if>

<c:if test="${query==null}">
<div id="iFilterPanelDialog" class="hide">
    <div class="DropItem">
        <div id="FilterPanel">
            <h2>Filter these issues.</h2>
            <p><fmt:message key="help.filter.explain"/></p>
            <div class="oops" style="margin:1em;">
                <div class="FilterList">
                <div class="AddedFilter hide ClonableFilter">
                    <span class="delete"><a id="iRemoveFilter" href="#removeFilterParam"><fmt:message key="action.filter.remove"/></a></span>
                    <select id="FilterParamSelection">
                        <option><fmt:message key="label.selectone"/></option>
                        <option value="qProject"><fmt:message key="label.filter.project"/></option>
                        <option value="qStatus" class="toHide"><fmt:message key="label.filter.status"/></option>
                        <option value="qPriority"><fmt:message key="label.filter.priority"/></option>
                        <option value="qDueOn"><fmt:message key="label.filter.dueon"/></option>
                        <option value="qAssignedTo"><fmt:message key="label.filter.assignedto"/></option>
                        <option value="qCreatedBy"><fmt:message key="label.filter.createdby"/></option>
                        <option value="qCreatedOn"><fmt:message key="label.filter.createdon"/></option>
                        <option value="qResolvedBy"><fmt:message key="label.filter.resolvedby"/></option>
                        <option value="qResolvedOn"><fmt:message key="label.filter.resolvedon"/></option>
                    </select>
                    <span class="ParamField"></span>
                </div>
            </div>
            </div>
        </div>
        <div style="margin:1em;">
        <div class="AddedFilter"><span class="add"><a id="lnkAddFilter" href="#addFilterParam"><fmt:message key="action.filter.add"/></a></span></div>
            </div>
        <c:if test="${currentUser != null && !currentUser.client}">
	        <p><fmt:message key="text.filter.save"/></p>
	        <div style="margin:1em;">
	        <div class="AddedFilter"><span class="MediumField"><label><fmt:message key="label.filter.name"/></label><input type="text" name="fldFilterName" id="fldFilterName" value=""/></span>
	            </div>
	        </div>
	    </c:if>
        <div class="Actions" id="divActions">
	        <ul>
	            <li><input type="submit" value="<fmt:message key="action.filter.apply"/>" id="btnApplyFilter"/></li>
	            <li><fmt:message key="text.or"/></li>
	            <li><a id="lnkCancelApplyFilter" href="#cancel"><fmt:message key="action.cancel"/></a></li>
	        </ul>
	    </div>
    </div>

    <form method="post" action="${ctx}/issueFilters" id="frmFilterResults" class="hide">
    </form>

    <div id="templateFilterParams" class="hide Cleared">

        <!-- Main Select -->

        <span id="qStatus" class="restricted">
            <select name="qStatus" id="qStatus">
                <option value="Open"><fmt:message key="label.issue.filter.status.open"/></option>
                <option value="Resolved"><fmt:message key="label.issue.filter.status.resolved"/></option>
                <option value="Closed"><fmt:message key="label.issue.filter.status.closed"/></option>
                <option value="All"><fmt:message key="label.issue.filter.status.all"/></option>
            </select>
        </span>

        <span id="qProject">
            <s:select list="projects" listValue="name" listKey="id" name="qProject" theme="simple" headerKey="-1" headerValue="%{getText('label.filter.project.default')}"/>

            <span><a id="actMore" class="hide" href="#more">more</a><a id="actLess" class="hide" href="#less">less</a></span>

            <div class="hide bonus" >
                <dl class="area">
                    <dt><fmt:message key="label.issue.subProject"/></dt>
                    <dd>
                        <input name="qArea" type="checkbox"/><label></label>
                    </dd>

                </dl>
                <dl class="type">
                    <dt><fmt:message key="label.issue.type"/></dt>
                    <dd>
                        <input name="qType" type="checkbox"/><label></label>
                    </dd>

                </dl>
                <dl class="found_in">
                    <dt><fmt:message key="label.issue.affectedVersion"/></dt>
                    <dd>
                        <input name="qAffected" type="checkbox"/><label></label>
                    </dd>

                </dl>
                <dl class="fixed_for">
                    <dt><fmt:message key="label.issue.fixforVersion"/></dt>
                    <dd>
                        <input name="qFixFor" type="checkbox"/><label></label>
                    </dd>

                </dl>
            </div>
        </span>
        <span id="qPriority">
        <s:select list="priorities" listValue="name" listKey="id" name="qPriority" theme="simple"
                              headerKey="-1" headerValue="%{getText('label.filter.priority.default')}"/>
        </span>
        <span id="qDueOn">
        	<fmt:message key="text.isbetween"/>
            <s:textfield name="qDueOnLowerRange" theme="simple" cssClass="DateField"/>
            <fmt:message key="text.and"/>
            <s:textfield name="qDueOnUpperRange" theme="simple" cssClass="DateField"/>
        </span>
        <span id="qAssignedTo">
            <s:select list="users" listValue="fullName" listKey="id" name="qAssignedTo" theme="simple"
                                  headerKey="-1" headerValue="%{getText('label.filter.assignedto.default')}"/>
        </span>
        <span id="qCreatedBy">
	        <s:select list="users" listValue="fullName" listKey="id" name="qCreatedBy" theme="simple"
	                              headerKey="-1" headerValue="%{getText('label.filter.createdby.default')}"/>
	    </span>
        <span id="qCreatedOn">
        	<fmt:message key="text.isbetween"/>
            <s:textfield name="qCreatedOnLowerRange" theme="simple" cssClass="DateField"/>
            <fmt:message key="text.and"/>
            <s:textfield name="qCreatedOnUpperRange" theme="simple" cssClass="DateField"/>
        </span>
        <span id="qResolvedBy">
	        <s:select list="users" listValue="fullName" listKey="id" name="qResolvedBy" theme="simple"
	                              headerKey="-1" headerValue="%{getText('label.filter.resolvedby.default')}"/>
	    </span>
        <span id="qResolvedOn">
        	<fmt:message key="text.isbetween"/>
	        <s:textfield name="qResolvedOnLowerRange" theme="simple"/>
	        <fmt:message key="text.and"/>
	        <s:textfield name="qResolvedOnUpperRange" theme="simple"/>
	    </span>

    </div>
</div><!-- End of iFilterPanelDialog -->
</c:if>

<jsp:scriptlet>
request.setAttribute("issueListDecorator", new org.displaytag.decorator.TableDecorator()
{
    public String addRowId()
    {
        return "issue_" + evaluate("id");
    }
});
</jsp:scriptlet>
<jsp:scriptlet>
request.setAttribute("idColumnDecorator", new com.hedgehoglab.fixx.renderer.decorator.IdColumnDecorator());
</jsp:scriptlet>



<div class="IssuesListPanel  ">
        <c:if test="${issueFilter.title!=null && query == null}">
            <h2 class="filterApplied">
            	<span class="removeFilter"><a class="" href="${ctx}/issues/?qFilterRemove=true" title="<fmt:message key="action.removefilter"/>"><fmt:message key="action.removefilter"/></a></span>
            	${fn:escapeXml(issueFilter.title)}
            </h2>
        </c:if>
        <s:if test="%{issueFilter != null && issueFilter.title==null && !issueFilter.empty && query == null}">
	    	<h2 id="IssueFilterSummary" class="filterApplied">
    			<span class="removeFilter">
                    <a class="" href="${ctx}/issues/?qFilterRemove=true" title="<fmt:message key="action.removefilter"/>" class="actRemoveFilter"><fmt:message key="action.removefilter"/></a>
                    <c:if test="${currentUser != null && !currentUser.client}">
                    	<a id="saveOldFilter" class="" href="#" title="<fmt:message key="action.savefilter"/>" class="actSaveFilter"><fmt:message key="action.savefilter"/></a>
                    </c:if>
                </span>

                <c:set var="txtOr"><fmt:message key="text.or"/></c:set>
		    	<fmt:message key="text.filter.viewing"/>
	    		<c:choose>
	    			<c:when test="${issueFilter.status != null}">
	        			<c:choose>
		            		<c:when test="${issueFilter.status == 'Open'}">
		            			<fmt:message key="text.filter.status.open"/>
		            		</c:when>
		            		<c:when test="${issueFilter.status == 'Closed'}">
		            			<fmt:message key="text.filter.status.closed"/>
		            		</c:when>
		            		<c:when test="${issueFilter.status == 'Resolved'}">
	            				<fmt:message key="text.filter.status.resolved"/>
	            			</c:when>
	            			<c:when test="${issueFilter.status == 'All'}">
	            				<fmt:message key="text.filter.status.all"/>
	            			</c:when>
		            	</c:choose>
	    			</c:when>
	    			<c:otherwise>
	        			<fmt:message key="text.filter.status.open"/>
	        		</c:otherwise>
	    		</c:choose>
	    		<c:choose>
	    			<c:when test="${fn:length(issueFilter.issueType) > 0}">
		    			<fmt:message key="text.filter.issuetype">
			    			<fmt:param>
				    			<c:forEach items="${issueFilter.issueType}" var="tmpType" varStatus="tmpStatus" step="1">
									${fn:escapeXml(tmpType.name)}
									<c:if test="${!tmpStatus.last}">
										${txtOr}
									</c:if>
								</c:forEach>
			    			</fmt:param>
						</fmt:message>
	    			</c:when>
	    			<c:otherwise>
	    				<fmt:message key="text.filter.issuetype.all"/>
	    			</c:otherwise>
	    		</c:choose>
	    		<c:if test="${fn:length(issueFilter.priority) > 0}">
	    			<fmt:message key="text.filter.priority">
	    				<fmt:param>
			    			<c:forEach items="${issueFilter.priority}" var="tmpPriority" varStatus="tmpStatus" step="1">
								${fn:escapeXml(tmpPriority.name)}<c:if test="${!tmpStatus.last}"> <fmt:message key="text.or"/> </c:if>
							</c:forEach>
	    				</fmt:param>
	    			</fmt:message>
	    		</c:if>
	    		<c:if test="${fn:length(issueFilter.project) > 0}">
	    			<fmt:message key="text.filter.project">
	    				<fmt:param>
			    			<c:forEach items="${issueFilter.project}" var="tmpProject" varStatus="tmpStatus" step="1">
								${fn:escapeXml(tmpProject.name)}<c:if test="${!tmpStatus.last}">, </c:if>
							</c:forEach>
	    				</fmt:param>
	    			</fmt:message>
	    		</c:if>
	    		<c:if test="${fn:length(issueFilter.subProject) > 0}">
    			<fmt:message key="text.filter.area">
    				<fmt:param>
		    			<c:forEach items="${issueFilter.subProject}" var="tmpSubProject" varStatus="tmpStatus" step="1">
							${fn:escapeXml(tmpSubProject.name)}<c:if test="${!tmpStatus.last}"> <fmt:message key="text.or"/> </c:if>
						</c:forEach>
    				</fmt:param>
    			</fmt:message>
    		</c:if>
	    		<c:if test="${fn:length(issueFilter.assignedTo) > 0}">
	    			<fmt:message key="text.filter.assignedto">
	    				<fmt:param>
			    			<c:forEach items="${issueFilter.assignedTo}" var="tmpUser" varStatus="tmpStatus" step="1">
								${fn:escapeXml(tmpUser.fullName)}<c:if test="${!tmpStatus.last}"> <fmt:message key="text.or"/></c:if>
							</c:forEach>
	    				</fmt:param>
	    			</fmt:message>
    			</c:if>
    			<c:if test="${fn:length(issueFilter.assignedTo) > 0 && fn:length(issueFilter.createdBy) > 0}">
    				<fmt:message key="text.and"/>
    			</c:if>
    			<c:if test="${fn:length(issueFilter.owner) > 0}">
	    			<fmt:message key="text.filter.createdby">
	    				<fmt:param>
			    			<c:forEach items="${issueFilter.owner}" var="tmpUser" varStatus="tmpStatus" step="1">
								${fn:escapeXml(tmpUser.fullName)}<c:if test="${!tmpStatus.last}"> <fmt:message key="text.or"/></c:if>
							</c:forEach>
	    				</fmt:param>
	    			</fmt:message>
    			</c:if>
    			<fmt:message key="text.filter.sortedby">
    				<fmt:param>
    					<c:choose>
    						<c:when test="${issueFilter.sortOrder == 2}">
    							<fmt:message key="text.filter.sortedby.descending"/>
    						</c:when>
    						<c:otherwise>
    							<fmt:message key="text.filter.sortedby.ascending"/>
    						</c:otherwise>
    					</c:choose>
    				</fmt:param>
    				<fmt:param>
    					<c:choose>
    						<c:when test="${issueFilter.sortBy == 'id'}">
    							<fmt:message key="text.filter.sortedby.type.id"/>
    						</c:when>
    						<c:when test="${issueFilter.sortBy == 'type'}">
								<fmt:message key="text.filter.sortedby.type.type"/>
							</c:when>
							<c:when test="${issueFilter.sortBy == 'title'}">
								<fmt:message key="text.filter.sortedby.type.title"/>
							</c:when>
							<c:when test="${issueFilter.sortBy == 'assignedTo'}">
								<fmt:message key="text.filter.sortedby.type.assignedto"/>
							</c:when>
							<c:otherwise>
								<fmt:message key="text.filter.sortedby.type.priority"/>
							</c:otherwise>
    					</c:choose>
    				</fmt:param>
    			</fmt:message>
	    	</h2>
            <c:if test="${filter.name==null}">
                <div class="Pane hide "  id="saveOldFilterPanel">
                    <form method="post" action="${ctx}/issueFilters" id="frmFilterResults_after" class="">
                        <span class="Field MediumField"><label for="fldFilterName"><fmt:message key="label.filter.name"/></label><input type="text" name="fldFilterName" id="fldFilterName" value=""/></span>

                    <div class="Actions">
                        <ul>
                            <li><s:submit theme="xhtml" key="action.save" id="btnSaveOldFilter"/></li>
                            <li><s:submit key="action.cancel" id="cancelSaveFilter" theme="xhtml"/></li>
                        </ul>
                        </div>
                        </form>
                </div>
            </c:if>

        </s:if>
	    <s:else>
	    	<s:if test="%{issueFilter.empty && query == null}">
			    <h2 class="filterApplied">
			    	<fmt:message key="action.filter.post.allissues"/>
			    </h2>
			</s:if>
	    </s:else>
     <c:if test="${fn:length(model) > 0}">

        <!-- -rey -->
         <div class="GenericTable GreyTable">
        <display:table name="model"  id="issueList" export="${currentUser != null}" requestURI="${ctx}/issues" excludedParams="qFilterRemove"
                       defaultsort="2" defaultorder="descending" sort="external" partialList="true" pagesize="${issueFilter.pageSize}" size="${totalFilterResults}">
	        <display:setProperty name="decorator.media.html"  value="issueListDecorator" />
	        <display:column decorator="idColumnDecorator" class="colID" headerClass="first" property="id" sortable="true" sortName="id" titleKey="label.issue.id"/>
            <display:column class="Priority darker" property="priority.name" titleKey="label.issue.priority" sortable="true" sortName="priority" escapeXml="true"/>
            <display:column headerClass="" class="Status" titleKey="label.issue.status" sortable="false">
            	<c:choose>
            		<c:when test="${issueList.closed}">
            			<fmt:message key="label.issue.status.closed"/>
            		</c:when>
            		<c:when test="${issueList.resolution != null}">
            			${fn:escapeXml(issueList.resolution.name)}
            		</c:when>
            		<c:otherwise>
            			<fmt:message key="label.issue.status.open"/>
            		</c:otherwise>
            	</c:choose>
            </display:column>
            <display:column titleKey="label.issue.type" class="Type darker" property="type" sortable="true" sortName="type" escapeXml="true"/>
            <display:column headerClass="first" class="Title" property="title" titleKey="label.issue.title"
                            sortable="true" sortName="title" escapeXml="true"></display:column>
            <display:column class="AssignedTo" property="assignedTo.fullName" titleKey="label.issue.assignedto"
                            sortable="true" sortName="assignedTo" escapeXml="true"/>
        </display:table>
         </div>
    </c:if>
    <c:if test="${fn:length(model) == 0 && query == null}">
        <div class="feedback notification">
        <p><fmt:message key="text.filter.results.nonFound">
            <fmt:param value="issueFilter"/>
        </fmt:message></p>
        </div>
    </c:if>



</div>
</c:set>

<c:set var="pageType">
	<c:choose>
		<c:when test="${currentUser != null }">realContent</c:when>
		<c:otherwise>fullContent</c:otherwise>
	</c:choose>
</c:set>


<div class="rightPanel">
    <c:if test="${currentUser != null }">
		<%@ include file="/common/controls/SavedFilterPanel.jsp" %>
	</c:if>
</div>


<div class="<c:out value="${pageType}"/>">
    <c:import url="/WEB-INF/pages/includes/issues/menu/list.jsp">
        <c:param name="content" value="${panelContent}"/>
    </c:import>
</div>

<script type="text/javascript">
var glblAnyCategory = '<fmt:message key="label.filter.area.default"/>';
var glblAnyIssueType = '<fmt:message key="label.filter.issuetype.default"/>';
var glblAnyVersion = '<fmt:message key="label.filter.version.default"/>';
</script>
