<%@ include file="/common/taglibs.jsp" %>
<head>
    <title><fmt:message key="title.issues.new"/></title>
    <meta name="menu" content="newissue"/>
    <script type="text/javascript" src="/scripts/com/hedgehoglab/fixx/controller/NewIssueController.js?<fmt:message key="webapp.version"/>"></script>
</head>

<c:set var="panelContent">
    <input type="hidden" id="current_user_id" value="${currentUser.id}"/>
    <s:form method="post" action="issues" id="frmCreateIssue" enctype="multipart/form-data">
	<div class="Pane">
		<h2><fmt:message key="heading.issue.create.info"/></h2> 
	
		<span class="Field MediumField"><s:textfield id="lol" name="title" key="label.issue.title" theme="xhtml"/></span>
		<span class="Field MediumField HugeField"><s:textarea name="description" key="label.issue.description" theme="xhtml"/></span>

	</div><!-- end pane -->


	<div class="Pane" id="grpLogicalGroup1">
            <h2><fmt:message key='heading.issue.create.projectinfo'/></h2>
            <span class="Field "><s:select value="frmProject.id" name="frmProject.id" key="label.issue.project" list="projects" listKey="id" listValue="name" multiple="false" size="1" theme="xhtml"/></span>
            <span class="Field "><s:select id="subProject_id" value="subProject.id" name="frmSubProject.id" key="label.issue.subProject" list="subProjects" listKey="id" listValue="name" multiple="false" size="1" theme="xhtml"/></span>
	</div><!-- end pane -->

<!-- -rey -->
<div class="Pane">
	<h2><fmt:message key="heading.issue.create.keyinfo"/></h2>
		<c:if test="${!notNormalUser}">
	        <span class="Field"><s:select value="priority.id" name="frmPriority.id" key="label.issue.priority" list="priorities" listKey="id" listValue="label" multiple="false" size="1" theme="xhtml" headerKey="-1" headerValue="%{getText('label.selectone')}"/></span>
	        <span class="Field"><s:select value="assignedTo.id" name="frmAssignedTo.id" key="label.issue.assignedto" list="users" listKey="id" listValue="fullName" multiple="false" size="1" theme="xhtml" headerKey="-1" headerValue="%{getText('label.selectone')}"/></span>
		</c:if>
	    <s:set name="issueTypesList" value="frmProject.issueTypes"/>
        <span class="Field"><s:select value="type.id" name="frmIssueType.id" key="label.issue.issueType" list="issueTypesList" listKey="id" listValue="name" multiple="false" size="1" theme="xhtml" headerKey="-1" headerValue="%{getText('label.selectone')}"/></span>
</div>      
        <div class=" hide " id="iMoreDetailPanel">
        	<div class="Pane">
            <h2><fmt:message key="heading.issue.create.estimateinfo"/></h2>
            <c:if test="${!notNormalUser}">
                    <span class="Field"><s:textfield disabled="true" title="%{getText('i18n.date.key')}" name="frmDueOn" key="label.issue.dueOn" theme="xhtml"
                                                     id="txtDueOn"
                                                     cssClass="DateFieldGreaterThan"/></span>
            <span class="Field"><s:textfield disabled="true" name="estimated_time" key="label.issue.estimated"
                                             theme="xhtml" title="%{getText('domtitle.estimatedtime')}"/> <fmt:message key="help.estimatedtime.format"/></span>                                                     
                    <span class="Field"><s:select disabled="true" name="frmFixFor.id"
                                                  key="label.issue.fixforVersion"
                                                  list="fixForVersions" value="fixfor.id" listKey="id" listValue="name"
                                                  multiple="false" size="1"
                                                  theme="xhtml" headerKey="-1"
                                                  headerValue="%{getText('label.selectone')}"/></span>
            </c:if>

                    <span class="Field"><s:select disabled="true" name="frmFixIn.id" key="label.issue.affectedVersion"
                                                  list="versionList"
                                                  value="affected.id" listKey="id" listValue="name" multiple="false" size="1"
                                                  theme="xhtml"
                                                  headerKey="-1" headerValue="%{getText('label.selectone')}"/></span>

            <span class="Field MediumField TagField"><s:textfield disabled="true" name="frmTags" key="label.issue.tags"
                                                         theme="xhtml"/></span>
            	<p class="note Cleared"><fmt:message key="text.tags.addmessage"/></p>
            </div>
        </div>


        <div class="Pane hide" id="iAttachmentContainer">
     
        	<h2><fmt:message key="heading.issue.addattachment"/></h2>
            <div class="Panel Cleared hide LargePanel" id="iFileUploadContainer">
                                <span class="Field"><s:file disabled="true" name="frmFile" cssClass="text file" required="false" theme="xhtml" value="" key="label.issue.attach"/><a href="#" class=" _actRemove actRemove"><fmt:message key="action.remove"/></a></span>
                            </div>
           <div class="Actions">
               <ul style="float: left;">
                <li style="float: left;">
                <a id="lnkAddAnotherFile" class="actAttachFile" href="#"><fmt:message key="action.addattachment.another"/></a>
                </li>
                </ul>
                
            </div>
        </div>
        
        
  <div class="Pane">      
        
<div class="protoMenuBar">
	<div class="protoMenuTitle"><h2><fmt:message key="heading.issue.addattachment"/></h2></div>
	<div class="protoMenuOpts">
	
					<ul>
						<li><a href="#" id="lnkAddAnotherFile"><a href="#" id="lnkAddMoreDetail"><fmt:message key="action.addmoredetail"/></a></a></li>
						<li><a href="#" id="lnkAddAnotherFile"><a href="#" id="lnkAddAnAttachment"><fmt:message key="action.addattachment"/></a></a></li>

											</ul>
	</div>
</div>     
            
                    
      </div>  
        
        
        
   <div class="Pane">
       <h2><fmt:message key="heading.issue.create.notify"/></h2>

		  <span class="Field">
			  <input type="checkbox" name="watchIssue" id="watchIssue" value="true" class="Checkbox Inline"/>
			  <label for="watchIssue" class="Inline"><fmt:message key="label.issue.addtowatchers"/></label>
		  </span>
           <c:if test="${!notNormalUser}">
              <span class="Field" id="iNotifyAssignee">
                  <input type="checkbox" name="notifyAssignee" id="notifyAssignee" value="true" class="Checkbox"/>
                  <label for="notifyAssignee" class="Inline"><fmt:message key="label.issue.notifyassignee"/></label>
              </span>
          </c:if>
        <div class="Actions">
            <ul id="submit">
                <li>
                    <s:submit key="action.createIssue"/></li>
            </ul>
        </div>
    </div>
   
    </s:form>

</c:set>

<div class="realContent">
    <c:import url="/WEB-INF/pages/includes/issues/menu/default.jsp">
        <c:param name="pageName" value="${newViewType}"/>
        <c:param name="content" value="${panelContent}"/>
    </c:import>
</div>
