<%@ include file="/common/taglibs.jsp" %>

<head>
    <title>${type.name} #${id} - ${fn:escapeXml(title)}</title>
    <meta name="menu" content="issues"/>
    <script type="text/javascript" src="/scripts/com/hedgehoglab/fixx/controller/IssueController.js?<fmt:message key="webapp.version"/>"></script>
</head>
<input type="hidden" id="this_issue_id" value="${model.id}"/>
<input type="hidden" id="this_issue_title" value="${model.title}"/>

<div class="rightPanel">
    <c:if test="${!subProject.project.archived && currentUser != null && validLicense}">
        <div class="PropertyPane">
            <h2><fmt:message key="heading.actions"/></h2>
            <div class="Pane">
                <ul>
                    <c:if test="${!closed}">
                    	<li><a class="actAddComment" href="#" id="lnkAddAnAttachment"><fmt:message key="action.commentOrAttach"/></a></li>
                    	<c:if test="${fn:length(model.attachments) > 0}">
                    		<li><a class="actDownloadZip" href="${ctx}/issues/${id}/downloadZip"><fmt:message key="action.downloadzip"/></a></li>
                    	</c:if>
                    	<li class="divider">
		                    <c:choose>
		                        <c:when test="${userWatchingIssue}">
		                            <a  class="actUnWatch" id="lnkStopWatching" href="${ctx}/issues/${id}/stopwatch" title="<fmt:message key="action.stopwatch"/>"><fmt:message key="action.stopwatch"/></a>
		                        </c:when>
		                        <c:otherwise>
		                            <a  class="actWatch" id="lnkStartWatching" href="${ctx}/issues/${id}/watch" title="<fmt:message key="action.watch"/>"><fmt:message key="action.watch"/></a>
		                        </c:otherwise>
		                    </c:choose>
		                </li>
		                <c:if test="${!currentUser.publicUser && !currentUser.client}">
	                        <li><a class="actReassign" href="#" id="lnkReassign"><fmt:message key="action.reassign"/></a></li>
	                    	<li><a class="actEdit" href="#" id="lnkEditIssue"><fmt:message key="action.edit"/></a></li>
	                        <li><a class="actLogTime" href="#" id="lnkLogTime"><fmt:message key="action.logTime"/></a></li>
	                        <li class="divider"><a class="actChangeEstimates" href="#" id="lnkReestimate"><fmt:message key="action.reestimate"/></a></li>
	                    </c:if>
	                 </c:if>
		             <c:if test="${!currentUser.publicUser && !currentUser.client}">                                                    
	                     <c:choose>
	                        <c:when test="${(closed) && !subProject.project.archived}">
	                        	<li><a  id="lnkEditIssue_" class="actReopen" href="${ctx}/issues/${id}/reopen" title="<fmt:message key="action.reopen"/>"><fmt:message key="action.reopen"/></a></li>
	                        </c:when>
	                        <c:when test="${!closed && !subProject.project.archived && resolution !=null}">
	                        	<li><a id="lnkMarkUnresolved" class="actUnresolve" href="${ctx}/issues/${id}/unresolve" title="<fmt:message key="action.unresolveIssue"/>"><fmt:message key="action.unresolveIssue"/></a></li>
	                        	<c:if test="${(currentUser.administrator || projectLead)}">
	                        		<li><a id="lnkCloseIssue" class="actClose" href="#" title="<fmt:message key="action.close"/>"><fmt:message key="action.close"/></a></li>
	                        	</c:if>
	                        </c:when>
	                        <c:otherwise>
	                            <li><a id="lnkResolveIssue" class="actResolve" href="#" title="<fmt:message key="action.resolve"/>"><fmt:message key="action.resolve"/></a>
	                        </c:otherwise>
	                    </c:choose>
	                </c:if>
                    
                    <c:if test="${(currentUser.administrator || projectLead)}">
                    	<c:if test="${fn:length(projectsToMove) > 0}">
                   			<li><a class="actMove" href="#" id="lnkMoveIssue"><fmt:message key="action.moveissue"/></a></li>
                        </c:if>
                   		<li><a class="actRemove" href="#" id="lnkDeleteIssue"><fmt:message key="action.delete"/></a></li>
                    </c:if>
                </ul>
            </div>	
        </div>
    </c:if>
    <c:if test="${currentUser != null && validLicense}">
        <div class="PropertyPane">
        <h2><fmt:message key="label.issue.tags"/></h2>
            <div class="Pane" id="tags">
            	<c:if test="${!currentUser.client && !subProject.project.archived}">
	                    <form action="${ctx}/issues/${id}" method="post" class="Spaced">
	                        <input type="hidden" name="_method" value="put"/>
	                        <span class="TagField"><input type="text" name="frmTags" class="addTags"></span>
	                        <s:submit key="action.addTag" theme="simple"/>
	                    </form>
	                    <p class="note"><fmt:message key="text.tags.addmessage"/></p>
	            </c:if>
                <ul class="tags_list tags">
                    <s:iterator value="tags" id="tag">
                        <li>
                    		<c:if test="${!currentUser.publicUser && !currentUser.client && !subProject.project.archived}">
								<span class="delete"><a title="delete this tag?" href="${ctx}/issues/${model.id}/deleteTag?tag=${id}"><fmt:message
	                                    key="action.delete"/></a></span>
	                        </c:if>
                            <a href="${ctx}/issues/?qTag=${id}" rel="tag">${fn:escapeXml(label)}</a>

                        </li>
                    </s:iterator>
                </ul>
            </div>
        </div>
    </c:if>
    <c:if test="${fn:length(watchers) > 0 && currentUser != null}">
	    <div class="PropertyPane">
	    	<h2><fmt:message key="heading.issue.watching"/></h2>
	    	<div class="Pane">
		    	<ul>
		    		<s:iterator value="watchers" id="watcher">
		    			<li><a href="${ctx}/profile/${watcher.id}">${fn:escapeXml(watcher.fullName)}</a></li>
		    		</s:iterator>
		    	</ul>
	    	</div>
	    </div>
    </c:if>
</div>


<c:set var="pageType">
	<c:choose>
		<c:when test="${currentUser != null && validLicense}">realContent</c:when>
		<c:otherwise>fullContent</c:otherwise>
	</c:choose>
</c:set>

<div class="<c:out value="${pageType}"/>">
    <div id="iIssueSummary">
        <div class="TabPanel">
            <div class="Pane scope" >
                <h2><a href="/issues/?qProject=${subProject.project.id}">${subProject.project.name}</a> &raquo; <a href="/issues/?qArea=${subProject.id}">${subProject.name}</a> &raquo;  ${type.name} #${id}</h2>
            </div>
            <div class="Pane">
            	<s:if test="%{currentUser != null && !isNotNormalUser}">
	                <div id="iIssueDetails" class="hide">
	                    <s:form method="post" action="issues/%{id}">
	                        <s:hidden name="_method" id="callbackMethod" value="put"/>
	
	                        <s:if test="%{closed!=true}">
	                        <h2><fmt:message key="heading.issue.edit.aboutthisissue"/></h2>
	                        <span class="Field MediumField"><s:textfield name="title" key="label.issue.title" theme="xhtml"/></span>
	                        <span class="Field MediumField"><s:textarea cssClass="textile" name="description" key="label.issue.description" theme="xhtml"/></span>
	
	                        <h2><fmt:message key="heading.issue.edit.categorise"/></h2>
	                        <span class="Field"><s:select value="subProject.id" name="frmSubProject.id" key="label.issue.subProject" list="subProjects" listKey="id" listValue="name" multiple="false" size="1" theme="xhtml"/></span>
	                        <span class="Field"><s:select value="priority.id" name="frmPriority.id" key="label.issue.priority" list="priorities" listKey="id" listValue="label" multiple="false" size="1" theme="xhtml"/></span>
                            <span class="Field"><s:select name="frmFixIn.id" key="label.issue.affectedVersion" list="versionList" value="affected.id" headerKey="-1" headerValue="%{getText('text.undecided')}" listKey="id" listValue="name" multiple="false" size="1" theme="xhtml"/></span>

	                        <h2><fmt:message key="heading.issue.edit.commentreason"/></h2>
	                        <span class="Field HugeField"><s:textarea cssClass="textile" name="frmComment.text" value="" theme="xhtml" key="label.issue.comment"/></span>
	
	                        <div class="Actions">
	                            <ul>
	                                  <!-- moop -->                         
	                                  <li><s:submit cssClass="Submit" key="action.update"/></li>
	                                  <li><input id="lnkEditIssueCancel" type="button" value="Cancel" onClick="window.location.href='#';" /></li>
	                            </ul>
	                        </div>
	                        </s:if>
	
	                    </s:form>
	                </div>
	            </s:if>

                <s:if test="%{closed!=true && currentUser != null}">
                    <s:form method="post" action="issues/%{id}/addComment" enctype="multipart/form-data">
                        <div class="hide MainPanel" id="iAttachmentContainer">
                            <h2><fmt:message key="heading.issue.edit.commentOrAttach"/></h2>
                            <div class="banner">
                            	<ul>
	                            	<li class="actHelp"><a href="#" id="lnkCommentTags"><fmt:message key="action.helpcommenttags"/></a></li>
	                            </ul>
                            </div>
                            <div class="hide feedback notification Panel" id="helpCommentTags">
                            	<ul>
                            		<li><fmt:message key="help.commenttags"/></li>
                            		<li><fmt:message key="help.commenttags.issue"/></li>
                            		<li><a id="lnkCommentTagsClose" href="#"><fmt:message key="action.close"/></a></li>
                            	</ul>
	                        </div>
                            <span class="Field HugeField"><s:textarea disabled="true" name="frmComment.text" cssClass="textile" theme="xhtml" key="label.issue.comment" /></span>
                            <div class="Panel Cleared hide LargePanel" id="iFileUploadContainer">
	                            <!-- wip -->
	                            <span class="Field "><s:file name="frmFile" cssClass="text file" theme="xhtml" key="label.issue.attach"/><a href="#" class=" _actRemove actRemove"><fmt:message key="action.remove"/></a></span>
                            </div>

                            <div class="Actions">
                                <ul style="float:left;">
                                    <li style="float:left;"><a class="actAttachFile" href="#" id="lnkAddAnotherFile"><fmt:message key="action.addAnotherFile"/></a></li>
                                </ul>
                                <ul>
                                    <li><s:submit cssClass="Submit" key="action.postComment"/></li>
                                <!--    <li><fmt:message key="text.or"/> <a href="#" id="lnkAddAnAttachmentCancel"><fmt:message key="action.cancel"/></a></li> -->
                     				<li><input id="lnkAddAnAttachmentCancel" type="button" value="Cancel" onClick="window.location.href='#';" /></li>     
                                </ul>
                            </div>
                        </div>
                    </s:form>
                    
                    <c:if test="${fn:length(projectsToMove) > 0}">
	                    <s:form method="post" action="issues/%{id}/move">
	                    	<div class="hide MainPanel" id="iMoveContainer">
	                    		<h2><fmt:message key="heading.issue.edit.move"/></h2>
	                    		<span class="Field "><s:select name="frmProject.id" key="label.issue.project" list="projectsToMove" listKey="id" listValue="name" multiple="false" size="1" theme="xhtml" id="frmMoveIssue_project_id"/></span>
	                            <span class="Field "><s:select id="frmMoveIssue_subproject_id" name="subProject_id" key="label.issue.subProject" list="subProjectsToMove" listKey="id" listValue="name" multiple="false" size="1" theme="xhtml"/></span>
	                            <div class="Actions">
		                            <ul>
		                                <li><s:submit cssClass="Submit" key="action.moveissue"/></li>
		                 				<li><input id="lnkMoveCancel" type="button" value="<fmt:message key="action.cancel"/>" onClick="window.location.href='#';" /></li>     
		                            </ul>
		                        </div>
	                    	</div>
	                    </s:form>
	                </c:if>

                    <s:form method="post" action="issues/%{id}/resolve">
                        <s:hidden name="_method" value="put"/>
                        <div class="hide" id="iResolutionContainer">
                            <h2><fmt:message key="heading.issue.edit.resolve"/></h2>
                            <span class="Field"><s:select key="label.issue.resolution" disabled="true" name="frmResolution.id" list="model.subProject.project.resolutions" listKey="id" listValue="name" multiple="false" size="1" theme="xhtml"/></span>
                            <span class="Field MediumField"><s:textarea disabled="true" cssClass="textile" name="frmComment.text"key="label.issue.comment.friendly" theme="xhtml"/></span>
                            <c:if test="${closed!=true && (currentUser.administrator || projectLead)}">
	                            <span class="Field"><input type="checkbox" name="chkCloseWhileResolve" value="true" id="chkCloseWhileResolve" class="inline"/><label for="chkCloseWhileResolve"><fmt:message key="text.closeWhileResolve"/></label></span>
	                        </c:if>
                            <c:if test="${subProject.project.forceLogTime}">
                                <div class="Pane" id="iResolveLogTimeContainer">
                                    <h2><fmt:message key="heading.issue.edit.logTime"/></h2>
                                    <div id="txtForceLogTime" class="feedback">
                                    	<ul>
                                    		<li><fmt:message key="text.forceLogTime"/></li>
                                    	</ul>
                                    </div>
                                    <input type="hidden" name="frmTimeLog.createdBy.id" value="${currentUser.id}"/>
                                <s:set name="frmTimeLogCreatedAt"><s:date name="frmTimeLog.createdAt" format="%{getText('i18n.date.key')}"/></s:set>
                                <span class="Field"><s:textfield key="label.issue.time.date" name="frmTimeLog_createdAt" cssClass="text DateField" value="%{frmTimeLogCreatedAt}" theme="xhtml"/></span>
                                <span class="Field"><s:textfield key="frmTimeLog.effort" maxlength="6" name="frmTimeLog_effort" cssClass="text" label="Hours" theme="xhtml"/></span>
                                <span class="Field MediumField"><s:textarea key="frmTimeLog.description" cssClass="textile" label="Description" theme="xhtml"/></span>
                                     
                               </div>
                                    <span class="Field HugeField"><input type="checkbox" name="chkNoTimeToLog" value="true" id="chkNoTimeToLog" class="inline"/>
                                        <label for="chkNoTimeToLog"><fmt:message key="text.forceLogTime.none"/></label></span>
                            </c:if>

                            <div class="Actions">
                                <ul>
                                    <li>
                                        
                                        <s:submit cssClass="Submit" key="action.resolve" id="btnResolve" theme="xhtml"/>
                                    </li>
                     				<li><input id="lnkResolveIssueCancel" type="button" value="<fmt:message key="action.cancel"/>" onClick="window.location.href='#';" /></li>                                    
                                </ul>
                            </div>
                        </div>
                    </s:form>

                    <s:if test="%{currentUser.administrator || projectLead}">
                        <s:form method="post" action="issues/%{id}/close">
                            <s:hidden name="_method" value="put"/>
                            <div class="hide" id="iCloseContainer">
                                <h2><fmt:message key="heading.issue.edit.close"/></h2>

                                <div class="Panel LargePanel">
                                <span class="Field MediumField">
                                    <s:textarea disabled="true" cssClass="textile" name="frmComment.text" key="label.issue.comment.friendly" theme="xhtml"/>
                                </span>
                                </div>
                                <div class="Actions">
                                    <ul>
                                        <li><s:submit cssClass="Submit" key="action.close"/></li>
                                        <!--<li><fmt:message key="text.or"/> <a href="#" id="lnkCloseIssueCancel"><fmt:message key="action.cancel"/></a></li>-->
 
                     				<li><input id="lnkCloseIssueCancel" type="button" value="Cancel" onClick="window.location.href='#';" /></li>                                       
                                    </ul>
                                </div>
                            </div>
                        </s:form>
                    </s:if>

                    <s:form method="post" action="issues/%{id}">
                        <s:hidden name="_method" value="put"/>
                        <div class="hide" id="iReestimateContainer">
                       <!-- change estimates -->                           
                       <h2><fmt:message key="heading.issue.edit.reestimate"/></h2>	
                            <s:set var="fmtDateDueOn"><s:date name="dueOn" format="%{getText('i18n.date.key')}"/></s:set>
                            <span class="Field"><s:textfield name="frmDueOn" value="%{fmtDateDueOn}" key="label.issue.dueOn" cssClass="DateFieldGreaterThan" id="txtDueOn" theme="xhtml"/></span>
                            <span class="Field"><s:textfield name="estimated_time" value="%{estimatedTime}" key="label.issue.estimated" theme="xhtml" title="%{getText('domtitle.estimatedtime')}"/> <fmt:message key="help.estimatedtime.format"/></span>
                            <span class="Field"><s:select name="frmFixFor.id" key="label.issue.fixforVersion" list="fixForVersions" value="fixfor.id" listKey="id" headerKey="-1" headerValue="%{getText('text.undecided')}" listValue="name" multiple="false" size="1" theme="xhtml"/></span>
                            <span class="Field MediumField"><s:textarea cssClass="textile" disabled="true" name="frmComment.text" key="label.issue.comment.friendly" theme="xhtml"/></span>

                            <div class="Actions">
                                <ul>
                                    <li><s:submit cssClass="Submit" key="action.reestimate"/></li>
                     				<li><input id="lnkReestimateCancel" type="button" value="Cancel" onClick="window.location.href='#';" /></li> 
                                </ul>
                            </div>
                        </div>
                    </s:form>

                    <s:form method="post" action="issues/%{id}">
                        <s:hidden name="_method" value="put"/>
                        <div class="hide MainPanel" id="iReassignContainer">
                            <input type="hidden" name="frmAssignedTo.id" id="frmAssignedTo"/>
                            <input type="hidden" id="currentUserId" value="${currentUser.id}"/>
                            <!-- reassign -->
                            <h2><fmt:message key="heading.issue.edit.reassign"/></h2>
                            <c:set var="booleanFlag" value="false"/>
                            <c:set var="checked" value="false"/>

                            <%//    If the issue is NOT assigned to the current user show the ME field%>
                            <c:if test="${currentUser.id != assignedTo.id}">
                                <span class="Field"><input type="radio" ${(checked==true)?'checked="checked"':''} name="assignTo" value="${currentUser.id}" id="frmAssignedToMe" class="inline"/><label><fmt:message key="label.issue.assignedTo.me"/> (${currentUser.fullName})</label></span>
                                <c:set var="booleanFlag" value="true"/>
                                <c:set var="checked" value="true"/>
                            </c:if>

                            <%//    If the current user did NOT create the issue show the creator field%>
                            <c:if test="${!(currentUser.id == createdBy.id || assignedTo.id==createdBy.id)}">
                                <span class="Field "><input type="radio" ${(checked==true)?'checked="checked"':''} name="assignTo" value="${createdBy.id}" id="frmAssignedToCreator" class="inline"><label for="frmAssignedToCreator"><fmt:message key="label.issue.assignedTo.creator"/> (${model.createdBy.fullName})</label></span>
                                <c:set var="booleanFlag" value="true"/>
                                <c:set var="checked" value="true"/>
                            </c:if>

                            <%//    If the user is NOT the project lead show the project lead field%>
                            <c:if test="${!(currentUser.id == subProject.project.owner.id || assignedTo.id==subProject.project.owner.id)}">
                                <span class="Field"><input type="radio" ${(checked==true)?'checked="checked"':''} name="assignTo" value="${subProject.project.owner.id}" id="frmAssignedToLead" class="inline"/><label for="frmAssignedToLead"><fmt:message key="label.issue.assignedTo.lead"/> (${subProject.project.owner.fullName})</label></span>
                                <c:set var="booleanFlag" value="true"/>
                                <c:set var="checked" value="true"/>
                            </c:if>

                            <%//    Show the OTHER field%>
                            <c:if test="${booleanFlag!=false}">
                                <span class="Field">
                                    <%//    Only show the label and radio if non of the above are true %>
                                    <input type="radio" ${(checked==true)?'checked="checked"':''} id="frmAssignedToOther" class="inline" name="assignTo"/>
                                    <label for="frmAssignedTo.id"><fmt:message key="label.issue.assignedTo.other"/></label>
	                                <span id="spanddlAssignedTo">
	                                    <s:select id="ddlAssignedTo" list="filteredUsers" listKey="id" listValue="fullName" multiple="false" size="1" theme="xhtml" headerKey="" headerValue="%{getText('label.selectone')}"/>
	                                </span>
                                </span>
                            </c:if>
                            <c:if test="${booleanFlag==false}">
                                <span class="Field " id="spanddlAssignedTo">
                                    <s:select id="ddlAssignedTo" list="filteredUsers" listKey="id" listValue="fullName" multiple="false" size="1" theme="xhtml" headerKey="" headerValue="%{getText('label.selectone')}" key="label.issue.user"/>
                                </span>
                            </c:if>

                            <span class="Field MediumField" style=""><s:textarea disabled="true" cssClass="textile" name="frmComment.text" key="label.issue.comment" theme="xhtml"/></span>

                            <div id="divNotifyAssigneeOnReassign">
                            	<h2><fmt:message key="heading.issue.notify"/></h2>
	                            <span class="Field  HugeField">
	                                <input type="checkbox" name="notifyAssignee" id="chknotifyAssigneeOnReassign" value="true" disabled="disabled" class="Checkbox inline"/>
	                             	<label for="notifyAssignee"><fmt:message key="label.issue.notifyassignee"/></label>
	                            </span>                            
	                        </div>
                            <div class="Actions">
                                <ul>
                                    <li><s:submit cssClass="Submit" key="action.reassign"/></li>
                                    <li><input id="lnkReassignCancel" type="button" value="Cancel" onClick="window.location.href='#';" /></li> 
                                </ul>
                            </div>
                        </div>
                    </s:form>
                    
                
				<s:form method="post" action="issues/%{id}/logTime">
				   <div class="hide" id="iLogTimeContainer">
				   		<div class="pane">
				   			<h2><fmt:message key="heading.issue.edit.logTime"/></h2>
                            <input type="hidden" name="frmTimeLog.createdBy.id" value="${currentUser.id}"/>
                            <s:set name="frmTimeLogCreatedAt"><s:date name="frmTimeLog.createdAt" format="%{getText('i18n.date.key')}"/></s:set>
							<span class="Field"><s:textfield key="label.issue.time.date" name="frmTimeLog_createdAt" cssClass="text DateField" value="%{frmTimeLogCreatedAt}" theme="xhtml"/></span>
							<span class="Field"><s:textfield key="frmTimeLog.effort" maxlength="6" name="frmTimeLog_effort" cssClass="text" label="Hours" theme="xhtml"/></span>
							<span class="Field MediumField"><s:textarea key="frmTimeLog.description" cssClass="textile" label="Description" theme="xhtml"/></span>
							<div class="Actions">
								<ul>
									<li><s:submit cssClass="Submit" key="action.addTimeLog"/></li>
									<li><input id="lnkLogTimeCancel" type="button" value="<fmt:message key="action.cancel"/>" onClick="window.location.href='#';" /></li> 
								</ul>
							</div>
						</div><!-- end pane -->
				</div><!-- end hide -->
				</s:form>
				
</s:if><!-- End check for closed -->


                <h2 class="Summary foob"><span class="hide">#${id}</span>
                    <c:if test="${title==null || title==''}"><fmt:message key="text.message.issue.notitle"/></c:if>
                    <c:if test="${!(title==null || title=='')}"><fixx:textileFilter>${title}</fixx:textileFilter></c:if>
                    </h2>
                <table id="FloatFix" class="vevent">
                    <tr>
                        <td  class="issueContainer">
                            <div class="_CommentItem">
                              <div class="_indented" >
                                <div class="entry-content"><fixx:issueLinkFilter context="${ctx}">
                                    <c:if test="${description==null || description==''}"><fmt:message key="text.message.issue.nodescription"/></c:if>
                                    <c:if test="${!(description==null || description=='')}"><fixx:textileFilter>${description}</fixx:textileFilter></c:if>

                                </fixx:issueLinkFilter>
                                </div>
                                </div>                           
                            </div>
                        </td>
                        <td class="secondContainer">
                <div class="SecondaryInformation">
                    <div class="Block">
                        <c:choose>
                            <c:when test="${closed}">
                                <p><fmt:message key="label.issue.metadata.status"/>&nbsp;<strong><fmt:message key="label.issue.status.closed"/></strong></p>
                                <p><fmt:message key="label.issue.metadata.resolution"/> &nbsp;<strong>${resolution.name}</strong></p>
                            </c:when>

                            <c:when test="${!closed && resolution!=null}">
                                <p><fmt:message key="label.issue.metadata.resolution"/> &nbsp;<strong>${resolution.name}</strong></p>
                            </c:when>
                            <c:otherwise>
                                <p><fmt:message key="label.issue.metadata.status"/> &nbsp;<strong><fmt:message key="label.issue.status.open"/></strong></p>

                            </c:otherwise>
                        </c:choose>
                    
                        <p><fmt:message key="label.issue.metadata.priority">&nbsp;<fmt:param value="${priority.name}"/></fmt:message></p>

                    </div>
                    <hr/>
                    <div class="Block">
                        <p class="vcard"><fmt:message key="label.issue.metadata.assignedTo"><span class="fn"><fmt:param value="${assignedTo.fullName}"/></fmt:message></span></p>
                        <p class="vcard"><fmt:message key="label.issue.metadata.createdBy"><span class="fn"><fmt:param value="${createdBy.fullName}"/></fmt:message></span></p>
                    </div>
                    <hr/>
                    <div class="Block">
                        <c:set var="fixForName" scope="request">
                            <c:choose>
                                <c:when test="${fixfor!=null}">${fixfor.name}</c:when>
                                <c:otherwise><fmt:message key="text.undecided"/></c:otherwise>
                            </c:choose>
                        </c:set>
                        <c:set var="affectedName">
                            <c:choose>
                                <c:when test="${affected!=null}">${affected.name}</c:when>
                                <c:otherwise><fmt:message key="text.undecided"/></c:otherwise>
                            </c:choose>
                        </c:set>
                        <p class="category location"><fmt:message key="label.issue.metadata.affected"><fmt:param value="${affectedName}"/></fmt:message></p>
                        <c:if test="${!closed}">
                            <p><fmt:message key="label.issue.metadata.fixFor"><fmt:param value="${fixForName}"/></fmt:message></p>
                            <p><abbr class="dtend" title="<s:date name="dueOn" format="yyyy-MM-dd"/>"><fmt:message key="label.issue.metadata.dueOn"><fmt:param><s:date name="dueOn" nice="true" format="struts.date.format.future"/></fmt:param></fmt:message></abbr></p>
                            <p><abbr class="dtstart" title="<s:date name="createdOn" format="yyyy-MM-dd"/>"><fmt:message key="label.issue.metadata.createdOn"><fmt:param><s:date name="createdOn" nice="true" format="struts.date.format.past"/></fmt:param></fmt:message></abbr></p>
                        </c:if>
                 </div>
                </div>
                        </td>
                    </tr>
                </table>

            </div>
        </div>
    </div>

    <div class="TabPanel"  id="divIssuePropertiesTabPane">
        <div class="Tabs">
            <ul class="">
                <li class="actComments"><a href="#panelComments" accesskey="c"><fmt:message key="tab.comments"/> (${fn:length(comments)})</a></li>
                <li class="actAttachments"><a href="#panelAttachments" accesskey="a"><fmt:message key="tab.attachments"/> (${fn:length(attachments)})</a></li>
                <c:if test="${currentUser != null && !isNotNormalUser && !subProject.project.hideLogTimeFromClient}">
                	<li class="actTimetracking"><a href="#panelTime" accesskey="t"><fmt:message key="tab.timetracking"/> (${fn:length(timeLogList)})</a></li>
                </c:if>
                <li class="actChangeLog"><a href="#panelChangelog" accesskey="h"><fmt:message key="tab.changelog"/> (${fn:length(changeLogList)})</a> </li>
            </ul>
        </div>

        <div class="Pane hide" id="panelComments">
            <c:if test="${fn:length(comments) == 0}">
                <p><fmt:message key="text.comment.nocommentsleft"/> </p>
            </c:if>

            <s:iterator value="commentHistory" status="status" id="comment">
            		<!-- comment item --> 
            		<div class="CommentItem hentry <c:if test="${updatedComment != null && updatedComment.id == id}">highlight</c:if>" id="comment_${id}">
                                <c:choose>
                                    <c:when test="${id != null && editableComment != null && editableComment.id == id}">
                                    	<div class="highlight">
	                                        <h2><fmt:message key="heading.issue.comment.edit"/></h2>
	                                        <s:form method="post" action="issues/%{model.id}/updateComment">
	                                            <span class="Field HugeField" id="comment_${id}">
	                                                <s:hidden name="frmComment.id" value="%{id}"/>
	                                                <s:textarea name="frmComment.text" value="%{text}" theme="xhtml" cssClass="highlight textile"/>
	                                            </span>
	                                            <div class="Actions">
	                                                <ul>
	                                                    <li><s:submit cssClass="Submit" key="action.update"/></li>
	                                                    <li><form action="${ctx}/issues/${model.id}" method="get"><s:submit key="action.cancel"/></form></li>
	                                                </ul>
	                                            </div>
	                                        </s:form>
	                                     </div>
                                    </c:when>
                                    <c:otherwise>
                                    <!-- comments start -->
                                        <h3>
                                             <span class="perma"><a rel="bookmark" href="#comment_${id}" title="Permalink">#</a></span>  
                                             <span class="vcard"><a href="${ctx}/profile/${user.id}"><strong class="fn author">${user.fullName}</strong></a></span>                               
												<em>
													<abbr class="published updated" title="<s:date name="dateAdded" format="yyyyMMdd"/>T<s:date name="dateAdded" format="HHmmZ"/>">
																<s:date name="dateAdded" nice="true"/>
													</abbr>                                             
												</em>
												
												<c:if test="${currentUser != null && currentUser == user}">
	                                                <span class="Editlinks">
	                                                    <span class="delete"><a href="${ctx}/issues/${model.id}/removeComment?commentId=${id}"><fmt:message
	                                                            key="action.delete"/></a></span>
	                                                    <c:if test="${user == currentUser || user.administrator}">
	                                                     <span class="edit"><a href="${ctx}/issues/${model.id}/editComment?commentId=${id}"><fmt:message
	                                                                key="action.edit"/></a></span>
	                                                    </c:if>
	                                                </span>   
	                                            </c:if>
                                        </h3>
                                            <img class=" photo avatar"  src="${ctx}/profile/${user.id}/avatar" alt="${user.fullName}"/>
                                            <div class="indented" style="background-image:url('${ctx}/profile/${user.id}/avatar')">
                                            <div class="entry-content"><fixx:issueLinkFilter context="${ctx}">
                                                    <fixx:textileFilter>${text}</fixx:textileFilter>
                                            </fixx:issueLinkFilter>
                                            </div>
                                            </div>
                                    </c:otherwise>
                                </c:choose>
                            </div><!-- end comment item -->


            </s:iterator>
        </div>

 <div class="Pane hide" id="panelAttachments">
            <div class=" AttachmentsList">

			<h2><fmt:message key="heading.attachments.images"/></h2>

             <c:if test="${fn:length(groupedAttachments.images)==0}">
                <div class="feedback notification ">
                    <p>There are no image attachments for this issue.</p>
                </div>
            </c:if>
            <c:if test="${fn:length(groupedAttachments.images)!=0}">
			<div class="Attachments borderMe">
                <s:iterator value="groupedAttachments.images" id="ttt">
                     <dl id="attach_${id}">
						<dt><a href="${ctx}/attachments/${id}/download" title="${name}">${name}</a></dt>
						<dd><a href="${ctx}/attachments/${id}/download" title="Click to download"><img src="${ctx}/attachments/${id}/download?thumbnail=true" alt="${name}"/></a></dd>
                            <c:if test="${currentUser !=null && validLicense && (ttt.createdBy.id==currentUser.id) || currentUser.administrator}">
                            <dd>
                                <span class="delete"><a  rel="attach_${id}" title="delete this image?" href="${ctx}/attachments/${id}?_method=delete"><fmt:message key="action.delete"/></a></span>
                            </dd>
                        </c:if>
                    </dl>
				</s:iterator>
            </div><!-- end Attachments -->
            </c:if>
            </div><!-- end AttachmentsList -->
        <div class="AttachmentsList">
        <h2><fmt:message key="heading.attachments.documents"/></h2>
            <c:if test="${fn:length(groupedAttachments.documents)==0}">
                <div class="feedback notification ">
                    <p>There are no document attachments for this issue..</p>
                </div>
            </c:if>
            <c:if test="${fn:length(groupedAttachments.documents)!=0}">
            <div class="Attachments">
                <ul>
                <s:iterator value="groupedAttachments.documents" id="qqq">
                   <c:set var="class">
                        <s:bean name="com.hedgehoglab.fixx.utils.MimeTypeHelper" id="mimeHelper">
                            <s:param name="file" value="%{filepath}"/>
                            <s:property value="mimeType"/>
                        </s:bean>
                    </c:set>
                    <s:set var="contentType"><s:property value="contentType"/></s:set>
                    <c:set var="ccc">
                        <s:bean name="com.hedgehoglab.fixx.utils.MimeTypeHelper" id="mimeHelper">
                            <s:param name="contentType" value="%{contentType}"/>
                            <s:property value="contentType"/>
                        </s:bean>
                    </c:set>
                    <c:if test="${currentUser != null && validLicense && (ttt.createdBy.id==currentUser.id) || currentUser.administrator}">
                        <li class="${ccc}"><a href="${ctx}/attachments/${id}/download">${name}</a><span class="delete"><a title="delete this attachment?" href="${ctx}/attachments/${id}?_method=delete"><fmt:message key="action.delete"/></a></span></li>
                    </c:if>
                    </s:iterator>
                </ul>

            </div><!-- end Attachments -->
            </c:if>
        </div><!-- end AttachmentsList -->
</div><!-- end pane -->


    <c:if test="${currentUser != null && !isNotNormalUser && !subProject.project.hideLogTimeFromClient}">
        <div class="Pane hide" id="panelTime" align="center">
			<div class="GenericTable">
                <table id="tblTimeLog">
                    <thead>
                        <th><fmt:message key="label.issue.time.date"/></th>
                        <th><fmt:message key="label.issue.time.person"/></th>
                        <th><fmt:message key="label.issue.time.hours"/></th>
                        <th><fmt:message key="label.issue.time.description"/></th>
                    </thead>
                    <tbody>
                        <s:iterator value="timeLogList" status="status">
                            <tr class="hentry">
                                <td class="date entry-title">
                                	<abbr class="updated" title="<s:date name="createdAt" format="yyyyMMdd"/>T<s:date name="createdAt" format="HHmmZ"/>">
                                    <s:date name="createdAt" format="dd/MM/yyyy"/>
                                    </abbr>
                                </td>
                                <td class="person vcard"><span class="fn author">${fn:escapeXml(createdByUser)}</span></td>
                                <td class="time entry-summary">${effort}</td>
                                <td class="description entry-content">${fn:escapeXml(description)}
								<td class="delete">
									<c:if test="${currentUser != null && validLicense && currentUser == createdBy || currentUser.administrator || model.subProject.project.owner == currentUser}">
                                        <span class="delete"><a href="${ctx}/issues/${model.id}/deleteTime?timelog=${id}"><fmt:message key="action.delete"/></a></span>
                                    </c:if>
                                </td>
                            </tr>
                        </s:iterator>
                    </tbody>
                </table>
		</div><!-- end OuterTable -->
   
                <c:if test="${fn:length(timeLogList)==0}">
                    <p>No time has been tracked against this issue.</p>
                </c:if>
        </div>
    </c:if>

        <div class="Pane hide" id="panelChangelog" align="center">
                <c:if test="${fn:length(changeLogList)==0}">
                    <p>No changes have been logged against this issue.</p>
                </c:if>
			<div class="GenericTable">
                <table id="tblChangeLog">
                <tbody>
                    <s:iterator value="changeLogList" status="status" id="changeLogItem">
                        <tr id="<s:date name="created" format="ddMMyyyyhhmmss"/>" class="hentry">
                            <td class="event entry-title">
                                <c:import url="/common/controls/IssueChangeLogEvent.jsp">
                                    <c:param name="event" value="${event}"/>
                                </c:import>
                            </td>
                            <td class="comment entry-content">
                                <fixx:textileFilter>${comment}</fixx:textileFilter>
                            </td>
                            <td class="assigned vcard">
                            	<span class="fn author">
                                <c:choose>
                                    <c:when test="${user != null}">
                                        ${user.fullName}
                                    </c:when>
                                    <c:otherwise>
                                        ${staticUserName}
                                    </c:otherwise>
                                </c:choose>
                                </span>
                            </td>
							<td class="date">
                            <abbr class="updated" title="<s:date name="created" format="yyyyMMdd"/>T<s:date name="created" format="HHmmZ"/>">
                            	<s:date name="created" format="struts.date.format.past" nice="true"/>
                            </abbr>
                            </td>
                        </tr>
                    </s:iterator>
                </tbody>
                </table>
</div><!-- end OuterTable -->
        </div>
    </div>
    
   
</div>


<script type="text/javascript">
    i18nConfirmDelete = '<div><fmt:message key="text.issue.delete.confirm"/></div>';
    lnkDelete = '${ctx}/issues/${id}?_method=delete&confirm=true';
</script>
