<%@ include file="/common/taglibs.jsp" %>
<head>
    <title>${title}</title>
</head>

<div class="toolbar">
      <h1 id="pageTitle">${type.name} - #${id}</h1>
      <a id="backButton" class="button" href="<fixx:cacheFreeUrl url="${ctx}/iphone/dashboard/"/>"><fmt:message key="menu.dashboard"/></a>      
      <c:if test="${!closed && resolution == null}"><a class="button" href="#editForm"><fmt:message key="action.reassign"/></a></c:if>    
</div>

<div id="issue" class="panel" title="${type.name} - #${id}" selected="true">
    <fieldset>
    <div class="SecondaryInformation">
                    <div class="Block First">
                        <p>${title} </p>                       
                    </div>
                    <hr/>

                    <div class="Block">
                        <c:choose>
                            <c:when test="${closed}">
                                <p><fmt:message key="label.issue.metadata.status"/><strong> <fmt:message key="label.issue.status.closed"/></strong></p>
                                <p><fmt:message key="label.issue.metadata.resolution"/>strong> ${resolution.name}</strong></p>
                            </c:when>

                            <c:when test="${!closed && resolution!=null}">
                                <p><fmt:message key="label.issue.metadata.resolution"/> <strong> ${resolution.name}</strong></p>
                            </c:when>
                            <c:otherwise>
                                <p><fmt:message key="label.issue.metadata.status"/><strong> <fmt:message key="label.issue.status.open"/></strong></p>

                            </c:otherwise>
                        </c:choose>

                        <p><fmt:message key="label.issue.metadata.priority"><fmt:param value="${priority.name}"/></fmt:message></p>
                        <c:if test="${closed!=false && resolution==null}">
                            <p><abbr class="dtend" title="<s:date name="dueOn" format="yyyy-MM-dd"/>"><fmt:message key="label.issue.metadata.dueOn"><fmt:param><s:date name="dueOn" nice="true" format="struts.date.format.future"/></fmt:param></fmt:message></abbr></p>
                            <p><abbr class="dtstart" title="<s:date name="createdOn" format="yyyy-MM-dd"/>"><fmt:message key="label.issue.metadata.createdOn"><fmt:param><s:date name="createdOn" nice="true" format="struts.date.format.past"/></fmt:param></fmt:message></abbr></p>
                        </c:if>

                    </div>
                    <hr/>
                    <div class="Block">
                        <p class="vcard"><fmt:message key="label.issue.metadata.assignedTo"><span class="fn"><fmt:param value="${assignedTo.fullName}"/></fmt:message></span></p>
                        <p class="vcard"><fmt:message key="label.issue.metadata.createdBy"><span class="fn"><fmt:param value="${createdBy.fullName}"/></fmt:message></span></p>
                    </div>
                    <hr/>
                    <div class="Block">
                        <c:set var="fixForName" scope="request">
                            <c:choose>
                                <c:when test="${fixfor!=null}">${fixfor.name}</c:when>
                                <c:otherwise><fmt:message key="text.undecided"/></c:otherwise>
                            </c:choose>
                        </c:set>
                        <c:set var="affectedName">
                            <c:choose>
                                <c:when test="${affected!=null}">${affected.name}</c:when>
                                <c:otherwise><fmt:message key="text.undecided"/></c:otherwise>
                            </c:choose>
                        </c:set>
                        <p class="category location"><fmt:message key="label.issue.metadata.affected"><fmt:param value="${affectedName}"/></fmt:message></p>
                        <c:if test="${closed==false}"><p><fmt:message key="label.issue.metadata.fixFor"><fmt:param value="${fixForName}"/></fmt:message></p></c:if>
                   </div>
                   <hr/>
                   <div class="Block Last">
                        <p>${description}</p>
                   </div>

       </div>
    </fieldset>

     <fieldset>
        <ul>
            <li><a href="${ctx}/iphone/issues/${id}/comments">
            Comments (${fn:length(comments)})</a></li>
        </ul>
    </fieldset>
</div>


<c:if test="${!closed && resolution == null}">
<form id="editForm" class="dialog" action="${ctx}/iphone/issues/${id}" method="POST">
        <input type="hidden" name="_method" value="put"/>
        <fieldset class="panel">
            <h1><fmt:message key="heading.issue.edit.reassign"/></h1>
            <a class="button leftButton" type="cancel"><fmt:message key="action.cancel"/> </a>
            <a class="button blueButton" type="submit"><fmt:message key="action.reassign"/></a>

            <label><fmt:message key="action.reassign"/></label>
            <s:select id="frmAssignedTo.id" name="frmAssignedTo.id" list="users" listKey="id" listValue="fullName" multiple="false" size="1" theme="simple" headerKey="" headerValue="%{getText('label.selectone')}"/>
        </fieldset>
</form>
</c:if>