<%@ include file="/common/taglibs.jsp" %>
<head>
    <title>
        Comments
    </title>
</head>

<style type="text/css">

body > ul > li {
    font-size: 14px;
}

body > ul > li > a {
    padding-left: 54px;
    padding-right: 40px;
    min-height: 34px;
    font-size: 0.9em;
}

</style>

<div class="toolbar">
      <h1 id="pageTitle">
          Comments
      </h1>
      <a id="backButton" class="button" href="${ctx}/iphone/issues/${id}">${type.name} #${id}</a>
      <c:if test="${!closed && resolution == null}"><a id="commentButton" class="button" href="#addComment">Comment</a></c:if>
</div>

    <ul id="comments" title="Comments" selected="true">
        <s:iterator value="commentHistory" status="status" id="comment">
            <li>
                <img width="32" height="32" src="${ctx}/profile/${user.id}/avatar" alt="photo of ${fn:escapeXml(user.fullName)}" class="avatar"/>
                <a class="nolink">
                    ${text}
                    <span class="time">
                        ${user.fullName}
                        <abbr class="published updated" title="<s:date name="dateAdded" format="yyyyMMdd"/>T<s:date name="dateAdded" format="HHmmZ"/>">
																<s:date name="dateAdded" nice="true"/>
													</abbr>
                    </span>
                </a>
            </li>
        </s:iterator>
    </ul>



    <c:if test="${!closed && resolution == null}">
     <form id="addComment" class="dialog" action="${ctx}/iphone/issues/${id}/addComment" method="POST">
         <input type="hidden" name="_method" value="put"/>

        <fieldset>
            <h1>Add Comment</h1>
            <a class="button leftButton" type="cancel">Cancel</a>
            <a class="button blueButton" type="submit">Comment</a>

            <textarea id="frmComment.text" name="frmComment.text"/>
        </fieldset>
    </form>
    </c:if>