<%@ include file="/common/taglibs.jsp" %>
<head>
    <title><fmt:message key="title.dashboard"/></title>
</head>

<div class="toolbar">
      <h1 id="pageTitle"><fmt:message key="title.dashboard"/></h1>
    <a class="button" href="#searchForm">Search</a>
    
</div>

    <ul id="dashboard" title="<fmt:message key="title.dashboard"/>" selected="true">
        <li class="group">
                Latest Activity
        </li>
        <li >
            <a href="${ctx}/iphone/dashboard?view=recently-modified">
                Recently Modified
            </a>
        </li>
        <li >
            <a href="${ctx}/iphone/dashboard?view=recently-created">
                Recently Created
            </a>
        </li>
        <li >
            <a href="${ctx}/iphone/dashboard?view=recently-resolved">
                Recently Resolved 
            </a>
        </li>
        <li class="group">
            My Filters
        </li>
        <li>
            	<a href="${ctx}/iphone/issues?qFilterRemove=true&qTitle=<fmt:message key="action.filter.post.allissues"/>">
            		<fmt:message key="action.filter.pre.allissues"><fmt:param value="${allIssuesCount}"/></fmt:message>
            	</a>
            </li>
            <li>
            	<a href="${ctx}/iphone/issues?qAssignedTo=${currentUser.id}&qTitle=<fmt:message key="action.filter.post.myissues"/>">
            		<fmt:message key="action.filter.pre.myissues"><fmt:param value="${myIssuesCount}"/></fmt:message>
            	</a>
            </li>
            <li>
            	<a href="${ctx}/iphone/issues?qWatcher=${currentUser.id}&qTitle=<fmt:message key="action.filter.post.imwatching"/>">
            		<fmt:message key="action.filter.pre.imwatching"><fmt:param value="${watchingIssuesCount}"/></fmt:message>
            	</a>
            </li>
        <s:iterator value="currentUser.issueFilters" id="currentIssueFilter" status="stat">
            <li>
                <a href="${ctx}/iphone/issues?${currentIssueFilter}">${fn:escapeXml(currentIssueFilter.title)} (<s:property value="getIssueCountForFilter(#currentIssueFilter)"/>)</a>
            </li>
         </s:iterator>
    </ul>

     <form id="searchForm" class="dialog" action="${ctx}/iphone/issues/">
        <fieldset>
            <h1>Search</h1>
            <a class="button leftButton" type="cancel">Cancel</a>
            <a class="button blueButton" type="submit">Search</a>

            <label>Keyword:</label>
            <input id="query" type="text" name="query"/>
        </fieldset>
    </form>