<%@ include file="/common/taglibs.jsp" %>
<head>
    <title><fmt:message key="title.dashboard"/></title>
    <meta name="menu" content="dashboard"/>
    <script type="text/javascript" src="/scripts/com/hedgehoglab/fixx/controller/DashboardController.js"></script>
</head>

<div class="rightPanel">
<c:if test="${currentUser != null && !currentUser.client && !currentUser.publicUser}">
			<div class="PropertyPane">
			    <h2><fmt:message key="heading.dashboard.myprojects"/> (${fn:length(activeProjectsForUser)})</h2>
			    <div class="Pane">
			    <ul>
			        <s:iterator value="activeProjectsForUser" id="project">
			            <li><a href="${ctx}/issues/?qProject=${id}&qAssignedTo=${currentUser.id}">${fn:escapeXml(name)}</a></li>
			        </s:iterator>
			    </ul>
			    </div>
			</div>
</c:if>

<c:if test="${currentUser != null && !currentUser.client }">
	<%@ include file="/common/controls/SavedFilterPanel.jsp" %>
</c:if>
</div>


<c:set var="pageType">
    <c:choose>
    	<c:when test="${currentUser != null && !currentUser.client }">halvedContent</c:when>
    	<c:otherwise>fullContent</c:otherwise>
    </c:choose>
</c:set>

<c:if test="${currentUser.client && fn:length(currentUser.clientProjects) == 0}">
<div class="feedback">
	<ul>
		<li>
			You have not been assigned to any projects in fixx. Please contact the owner of this fixx instance to grant you access to your projects.
	    </li>
	 </ul>
</div>
</c:if>

<div class="<c:out value="${pageType}"/>">


    <!--
       @mf

       This is the extended two column layout

       left is left and doh! right is right (View content.css to see layout diagrams)
    -->
   	<c:if test="${currentUser != null && !currentUser.client}">
	    <div class="left">
		    <div class="TabPanel">
			    <div class="Pane">
			    	<h2><fmt:message key="heading.dashboard.yourstats"/></h2>
			    	<img src="${ctx}/chart/myactivitysummary" class="chart"/>
	       		</div>
			</div>  
	    </div>
	    <div class="right">
	        <div class="TabPanel">
	        <div class="Pane">
	    			<h2><fmt:message key="heading.dashboard.systemstats"/></h2>
		    		<img src="${ctx}/chart/systemactivitysummary"class="chart"/>
				</div>
	        </div>
	    </div>
    </c:if>

    
    <!--
       @mf

       Below is the original dashboard tab panel and panes
    -->
    <div class="TabPanel" id="divDashboardViewsPane">
    <div class="Tabs">
        <ul>
				<li>
					<a href="#allactivity"><fmt:message key="action.dashboard.view.all"/></a>
				</li>
				<c:if test="${currentUser != null && !currentUser.client}">
					<li <c:if test="${view == 'my'}">class="current"</c:if>>
						<a href="#myactivity"><fmt:message key="action.dashboard.view.my"/></a>
					</li>
					<li <c:if test="${view == 'overdue'}">class="current"</c:if>>
					<a href="#myoverdueissues"><fmt:message key="action.dashboard.view.myoverdue"/> (${fn:length(myOverdueIssues)})</a>
					</li>
				</c:if>
		</ul>
    </div>
      
      <div class="Pane hide" id="allactivity">
      	<s:iterator value="allActiveProjects" status="projectStatus" id="project">
            <div>
                <h2>
                	<c:choose>
                		<c:when test="${currentUser.client}">
                			${fn:escapeXml(project.name)}
                		</c:when>
                		<c:otherwise>
                    		<a href="${ctx}/projects/${id}/?view=changelog">${fn:escapeXml(project.name)}</a>
                		</c:otherwise>
                	</c:choose>
                </h2>
                <s:if test="getLogsForProject(#project).size() > 0">
                <div class="GenericTable">
                <table id="tblChangeLog">
                <tbody>


                <c:set value="-1" var="lastIssueId"/>

                <s:iterator value="getLogsForProject(#project)" status="changelogStatus" id="changeLogItem">
                    <c:set var="classAdd">${(lastIssueId==object_reference)?"faded":""}</c:set>
                    <c:set var="lastIssueId" value="${object_reference}"/>

                    <tr class="hentry ${classAdd}">



                    <td class="event entry-summary">
                        
                        <c:import url="/common/controls/IssueChangeLogEvent.jsp">
                            <c:param name="event" value="${event}"/>
                        </c:import>
                    </td>
                    <td class="issue entry-title">

                        <span class="${addClass}"><a href="${ctx}/issues/${object_reference}">${object_reference}</a></span>


                    </td>                    
                    <td class="comment entry-content">
                        <fixx:textileFilter>${comment}</fixx:textileFilter>
                    </td>
                    <td class="assigned vcard">
                    	<span class="fn author">
                        <c:choose>
                            <c:when test="${user != null}">
                                ${fn:escapeXml(user.fullName)}
                            </c:when>
                            <c:otherwise>
                                ${fn:escapeXml(staticUserName)}
                            </c:otherwise>
                        </c:choose>
                        </span>
                    </td>
                    <td class="date">
					<abbr class="updated" title="<s:date name="created" format="yyyyMMdd"/>T<s:date name="created" format="HHmmZ"/>">                    
            			<s:date name="created" format="struts.date.format.past" nice="true"/>
            		</abbr>
            		</td>
                    </tr>
                </s:iterator>
                </tbody>
                </table>
                        </div>

                </s:if>
                <s:else>
                  <p><fmt:message key="text.changelog.noActivityLogged"/></p>
                </s:else>
            </div>
        </s:iterator>
        </div><!-- End of allactivity div -->
        
        <div class="Pane hide" id="myactivity">
        <s:iterator value="activeProjectsForUser" status="projectStatus" id="project">
              <div>
                  <h2>
                  	<c:choose>
                  		<c:when test="${currentUser.client}">
                  			${fn:escapeXml(project.name)}
                  		</c:when>
                  		<c:otherwise>
                      		<a href="${ctx}/projects/${id}/?view=changelog">${fn:escapeXml(project.name)}</a>
                  		</c:otherwise>
                  	</c:choose>
                  </h2>
                  <s:if test="getUserLogsForProject(#project).size() > 0">
                  <div class="GenericTable">
                  <table id="tblChangeLog">
                  <tbody>

                  <c:set value="-1" var="lastIssueId"/>

                  <s:iterator value="getLogsForProject(#project)" status="changelogStatus" id="changeLogItem">
                      <c:set var="classAdd">${(lastIssueId==object_reference)?"faded":""}</c:set>
                      <c:set var="lastIssueId" value="${object_reference}"/>

                      <tr class="hentry ${classAdd}">
                      <td class="event entry-summary">
                          
                          <c:import url="/common/controls/IssueChangeLogEvent.jsp">
                              <c:param name="event" value="${event}"/>
                          </c:import>
                      </td>
                      <td class="issue entry-title">

                          <span class="${addClass}"><a href="${ctx}/issues/${object_reference}">${object_reference}</a></span>


                      </td>                    
                      <td class="comment entry-content">
                          <fixx:textileFilter>${comment}</fixx:textileFilter>
                      </td>
                      <td class="assigned vcard">
                      	<span class="fn author">
                          <c:choose>
                              <c:when test="${user != null}">
                                  ${fn:escapeXml(user.fullName)}
                              </c:when>
                              <c:otherwise>
                                  ${fn:escapeXml(staticUserName)}
                              </c:otherwise>
                          </c:choose>
                          </span>
                      </td>
                      <td class="date">
  					<abbr class="updated" title="<s:date name="created" format="yyyyMMdd"/>T<s:date name="created" format="HHmmZ"/>">                    
              			<s:date name="created" format="struts.date.format.past" nice="true"/>
              		</abbr>
              		</td>
                      </tr>
                  </s:iterator>
                  </tbody>
                  </table>
                          </div>

                  </s:if>
                  <s:else>
                    <p><fmt:message key="text.changelog.noActivityLogged"/></p>
                  </s:else>
              </div>
          </s:iterator>
          </div><!-- End of myactivity div -->
          
          <c:if test="${currentUser != null}">
	          <div class="Pane hide" id="myoverdueissues">
	          <c:if test="${fn:length(myOverdueIssues) == 0}">
	          	<div class="feedback notification">
	          		<ul>
	          			<li><fmt:message key="text.nooverdueissues"/></li>
	          		</ul>
	          	</div>
	          </c:if>
		          <div class="GenericTable">                
			          <table id="tblRoadmap">
			            <tbody>
			              <s:iterator value="myOverdueIssues" id="overdueIssue">
			                <tr class="hentry">
			                  <td class="issue entry-title"><a href="/issues/${id}/edit">${id}</a></td>
			                  <td class="priority">${fn:escapeXml(priority.name)}</td>
			                  <td class="title entry-content">${fn:escapeXml(title)}</td>
			                  <td class="assigned vcard"><abbr class="dtend" title="<s:date name="dueOn" format="yyyy-MM-dd"/>"><fmt:message key="label.issue.metadata.dueOn"><fmt:param><s:date name="dueOn" nice="true" format="struts.date.format.future"/></fmt:param></fmt:message></abbr></td>
			                </tr>
			              </s:iterator>
			            </tbody>
			          </table>
				</div>
			</div><!-- End of myoverdueissues div -->
		</c:if>
		
		</div><!-- End of dashboard views-->
</div>
   
