<%@ include file="/common/taglibs.jsp" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<head>
    <title><fmt:message key="title.admin.users"/> | <fmt:message key="title.admin"/></title>
    <meta name="menu" content="admin"/>
    <script type="text/javascript" src="/scripts/com/hedgehoglab/fixx/controller/admin/UserIndexController.js?<fmt:message key="webapp.version"/>"></script>
</head>

	<s:if test="%{query!=null}">
	<div class="feedback">
	<ul>
		<s:if test="%{model.size > 0}">
			<li><fmt:message key="text.message.search.user">
				<fmt:param value="${fn:escapeXml(query)}"/>
				<fmt:param value="${fn:length(model)}"/>
				<fmt:param value="${ctx}/admin/users"/>
			</fmt:message></li>
		</s:if>
		<s:else>
			<li><fmt:message key="text.message.search.user.empty">
				<fmt:param value="${fn:escapeXml(query)}"/>
				<fmt:param value="${ctx}/admin/users"/>
			</fmt:message></li>
		</s:else>
	</ul>
	</div>
	</s:if>

<c:set var="panelContent">
  <div class="Pane ">
    <div class="FindPanel">
        
        <form action="${request.contextPath}/admin/users" action="get">
            <input type="text" name="query" value="${query}"/>
            <input type="submit" value="<fmt:message key="action.finduser"/>"/>
        </form>
    </div>
     <s:if test="%{model.size > 0}">
         <div id="divContactsView">
                <ul class="Contacts">
                    <s:iterator value="model" id="user">
                    <li>
                        <dl class="Contact vcard">
                            <dt class="fn"><a class="actEdit" href="${ctx}/admin/users/${id}">${fn:escapeXml(fullName)}</a></dt>
                            <dd class="avatar"><img width="32" height="32" src="${ctx}/profile/${id}/avatar" alt="photo of ${fn:escapeXml(fullName)}" class="photo"/></dd>
                            <dd class="tel mob">${fn:escapeXml(phoneNumber)}&nbsp;</dd>
                            <dd class="email"><a href="mailto:${email}">${email}</a></dd>
                        </dl>
                    </li>
                    </s:iterator>
            </ul>
        </div>
     </s:if>




    </div>
</c:set>

<div class="rightPanel">
	<c:if test="${licenseExists}">
	    <div class="PropertyPane">
	        <h2>Actions</h2>
	        <div class="Pane">
	            <ul>
	        			<li id=""><a class="actAddUser" href="${request.contextPath}/admin/users/new"/><fmt:message key='action.newuser'/></a></li>            </ul>
	        	</ul>
	        </div>
	    </div>
    </c:if>
</div>

<div class="realContent">
    <c:import url="/WEB-INF/pages/includes/administration/menu/default.jsp">
        <c:param name="pageName" value="Users"/>
        <c:param name="content" value="${panelContent}"/>
    </c:import>
</div>