<%@ include file="/common/taglibs.jsp" %>

<head>
    <title>${fullName} | <fmt:message key="title.admin"/></title>
    <meta name="menu" content="admin"/>
    <script type="text/javascript" src="/scripts/com/hedgehoglab/fixx/controller/AdminUserController.js?<fmt:message key="webapp.version"/>"></script>
</head>

<s:form method="post" action="users/%{id}">
    <s:hidden name="_method" value="put"/>
    <div class="rightPanel">
    <s:if test="%{id != currentUser.id}">
        <div class="PropertyPane">
            <h2><fmt:message key="heading.actions"/></h2>
            <div class="Pane">
                <ul class="last">
                <li><a class="actEmail" href="mailto:${email}"><fmt:message key="action.contactuser"><fmt:param
                        value="${fullName}"/></fmt:message></a></li>
                <s:if test="%{enabled}">
                    <li><a href="${request.contextPath}/admin/users/${id}/disable"><fmt:message
                            key="action.disableuser"/></a></li>
                </s:if>
                <s:if test="%{!enabled}">
                    <li><a href="${request.contextPath}/admin/users/${id}/enable"><fmt:message
                            key="action.enableuser"/></a></li>
                </s:if>
                <li>
	                <a href="#" id="aResetPassword"><fmt:message
	                key="action.resetpassword"/></a>
	                <div id="iResetPassword" class="hide">
	                	<span class="Field"><s:textfield name="reset_password" key="label.user.password" theme="xhtml" cssClass="text medium"/></span>


                        <a href="#" id="aResetPasswordCancel"><fmt:message key="action.cancel"/></a>
                        <s:submit key="action.resetpassword" theme="simple"/>

	                </div>
                </li>
                <c:if test="${!hasRelationShips && !client}">
                     <li><a href="${request.contextPath}/admin/users/${id}/?_method=delete"><fmt:message
                        key="action.delete"/></a></li>
                </c:if>     
            </ul>
                </div>
        </div>

        </s:if>
    </div>

    <c:set var="panelContent">
        <div class="Pane">
        <h2><fmt:message key='heading.user.edit'/>  ${fullName}</h2>
        	<input type="hidden" class="hide" name="old_username" value="${username}"/>
            <span class="Field MediumField">
            	<s:if test="%{model == currentUser">
            		<s:textfield name="username" key="label.user.username" required="true" theme="xhtml" readonly="true" cssClass="noborder"/>
            	</s:if>
            	<s:else>
            		<s:textfield name="username" key="label.user.username" required="true" theme="xhtml"/>
            	</s:else>
            </span>
            <span class="Field MediumField "><s:textfield name="email" key="label.user.email" required="true" theme="xhtml"/></span>

            <c:if test="${!administrator && !client && !publicUser}">
	            <span class="Field HugeField inline">
		        	<input type="checkbox" name="upgradeadmin" id="upgradeadmin" class="Checkbox inline" value="true"/>
		            <label for="upgradeadmin"><fmt:message key="label.user.upgradeadmin"/></label>
		    	</span>
            </c:if>
            <c:if test="${administrator && !client && model == currentUser }">
	            <span class="Field  inline">
		        	<input type="checkbox" name="downgradeuser" id="downgradeuser" class="Checkbox inline" value="true"/>
		            <label for="upgradeadmin"><fmt:message key="label.user.downgradeuser"/></label>
		    	</span>        		
        	</c:if>
        </div>
        <div class="Pane">
        <h2><fmt:message key='heading.optionalinfo'/></h2>


            <span class="Field MediumField"><s:textfield name="firstName" key="label.user.firstName" theme="xhtml" cssClass="text medium"/></span>
            <span class="Field MediumField"><s:textfield name="lastName" key="label.user.lastName" theme="xhtml" cssClass="text medium"/></span>
            <span class="Field"><s:textfield name="phoneNumber" key="label.user.phoneNumber" theme="xhtml"/></span>
            <span class="Field MediumField"><s:textfield name="website" key="label.user.website" cssClass="text large" theme="xhtml"/></span>

        <div class="Actions">
	       	<ul>
	           <li>
	           <s:submit key="action.update"/></li>
	       </ul>
    	</div>
        </div>
    </c:set>

    <c:set var="pageName">
    	<c:if test="${client}">Clients</c:if>
    	<c:if test="${!client}">Users</c:if>
    </c:set>
    
    <div class="realContent">
        <c:import url="/WEB-INF/pages/includes/administration/menu/default.jsp">
            <c:param name="pageName" value="${pageName}"/>
            <c:param name="content" value="${panelContent}"/>
        </c:import>
    </div>

</s:form>