<%@ include file="/common/taglibs.jsp" %>

<head>
    <title><fmt:message key="title.admin.projects"/> | <fmt:message key="title.admin"/></title>
    <meta name="menu" content="admin"/>
    <script type="text/javascript" src="/scripts/com/hedgehoglab/fixx/admin/projects-index.js?<fmt:message key="webapp.version"/>"></script>
</head>
<c:set var="panelContent">
	<div class="Pane">
	<c:choose>
		<c:when test="${fn:length(model)==0}">
			<div class="feedback notification ">
			    <ul><li>There are no projects in the system.</li></ul>
			</div>
		</c:when>
		<c:otherwise>
		<div class="Pane ProjectListPanel">
	       <div class="GenericTable GreyTable">
	            <display:table name="model" decorator="com.hedgehoglab.fixx.renderer.decorator.AdminProjectListTableDecorator" id="model" requestURI="${ctx}/admin/projects" defaultorder="ascending">
	                <display:column titleKey="label.project.name" class="Name first" property="projectName" sortable="true" sortProperty="name" escapeXml="false"/>
	                <display:column titleKey="label.project.description" class="Description" property="description" sortable="true" escapeXml="true"/>
	                <display:column titleKey="label.project.owner" class="Owner" headerClass="Owner" property="owner.fullName" sortable="true" escapeXml="true"/>
	            </display:table>
	        </div>
	    </div>
	    </c:otherwise>
	 </c:choose>
	 </div><!-- end .pane -->

   
</c:set>

<div class="rightPanel">
    <div class="PropertyPane">
        <h2>Actions</h2>
        <div class="Pane">

            <ul>
                <li id=""><a href="${ctx}/admin/projects/new"><fmt:message key="action.newproject"/></a></li>
            </ul>

        </div>
    </div>
</div>

<div class="realContent">
    <c:import url="/WEB-INF/pages/includes/administration/menu/default.jsp">
        <c:param name="pageName" value="Projects"/>
        <c:param name="content" value="${panelContent}"/>
    </c:import>
</div>