<%@ include file="/common/taglibs.jsp" %>

<head>
    <title>${fn:escapeXml(name)} | <fmt:message key="title.admin"/></title>
    <meta name="menu" content="admin"/>
    <script type="text/javascript" src="/scripts/com/hedgehoglab/fixx/controller/ProjectEditController.js?<fmt:message key="webapp.version"/>"></script>
</head>

<%@ include file="/common/messages.jsp" %>

<div class="rightPanel">
    <div class="PropertyPane">
        <h2><fmt:message key="heading.actions"/></h2>
        <div class="Pane">
            <ul class="last">
                <li>
                    <c:if test="${!archived}">
                        <a class="actArchive" href="${ctx}/admin/projects/${id}/archive"><fmt:message key="action.archiveproject"/></a>
                    </c:if>
                    <c:if test="${archived}">
                        <a class="actActivate" href="${ctx}/admin/projects/${id}/activate"><fmt:message key="action.activateproject"/></a>
                    </c:if>
                </li>
            </ul>
        </div>
        </div>
</div>

<c:set var="panelContent">
	<div class="Pane">
    	<h2 style="margin-bottom:0;"><fmt:message key="heading.projects.edit"/> - ${fn:escapeXml(name)}</h2>
        <div class="TabPanel " id="divProjectPropertiesTabPane" >
    <div class="Tabs">
        <ul class="">
        	<li class=""><a id="tab_overview" href="#overview" accesskey="o"><fmt:message
        			key="tab.overview"/></a></li>
            <li class=""><a id="tab_areas" href="#manageAreas" accesskey="a"><fmt:message
                    key="tab.areas"/></a></li>
            <li class=""><a id="tab_versions" href="#manageVersions" accesskey="v"><fmt:message
                    key="tab.versions"/></a></li>
            <li class=""><a id="tab_resolutions" href="#manageResolutions" accesskey="r"><fmt:message
                    key="tab.resolutions"/></a></li>
            <li class=""><a id="tab_issuetypes" href="#manageIssueTypes" accesskey="i"><fmt:message
                    key="tab.issuetypes"/></a></li>
            <li class=""><a id="tab_clients" href="#manageClients" accesskey="c"><fmt:message
            key="tab.clients"/></a></li>
            <c:if test="${restricted}">
                 <li class=""><a id="tab_users" href="#manageUsers" accesskey="u"><fmt:message
            key="tab.users"/></a></li>
            </c:if>
        </ul>
    </div>
    <div class="Pane hide" id="overview">
    <s:form method="post" action="projects/%{id}">
        <s:hidden name="_method" value="put"/>
        	 <span class="Field MediumField"><s:textfield name="name" key="label.project.name"
        		 								value="%{name}" theme="xhtml"/></span>
             <span class="Field "><s:select key="label.project.owner" name="owner_id" value="owner.id"
                                                      list="userList" listKey="id"
                                                      listValue="fullName" multiple="false" size="1"
                                                      theme="xhtml"/></span>

            <span class="Field MediumField"><s:textarea name="description" key="label.project.description"
                                                      value="%{description}" theme="xhtml"/></span>


        <c:if test="${!archived}">
             <span class="Field HugeField inline">
                <input type="checkbox" name="forceLogTime" id="chkforceLogTime" class="Checkbox inline"  <c:if test="${forceLogTime}">checked="checked"</c:if>/>
                <label for="chkforceLogTime"><fmt:message key="label.project.forceLogTime"/></label>
            </span>
            <span class="Field HugeField inline">
                <input type="checkbox" name="hideLogTimeFromClient" id="chkhideLogTimeFromClient" class="Checkbox inline" <c:if test="${hideLogTimeFromClient}">checked="checked"</c:if>/>
                <label for="chkhideLogTimeFromClient"><fmt:message key="label.project.hideLogTimeFromClient"/></label>
            </span>
            <span class="Field HugeField inline">
                <input type="checkbox" name="restricted" id="chkrestricted" class="Checkbox inline"  <c:if test="${restricted}">checked="checked"</c:if>/>
                <label for="chkrestricted"><fmt:message key="label.project.restricted"/></label>
            </span>
            <input type="hidden" name="_overview" id="_overview" value="true"/>
        </c:if>

        <div class="Actions Cleared">
            <ul>
                <li><s:submit value="Update"/></li>
            </ul>
        </div>

    </s:form>
    </div>
    <div class="Pane hide" id="manageAreas">
        <div class="EditableList">
            <div class="Items">
            <s:iterator value="subprojects" status="status" id="subproject">
                <div class="EditableItem">
                    <ul class="">
                    	<s:if test="canDelete(#subproject) && subprojects.size > 1">
                    		<li class="actRemove"><a href="${ctx}/admin/subprojects/${id}?_method=delete"><fmt:message key="action.delete"/></a></li>
                        </s:if>
                    	<li class="actEdit"><a href="#" title="Click to edit">Edit</a></li>
                        <li class="actDone hide"><a href="#" title="Click to edit">Done</a></li>
                        <li class="actCancel hide"><a href="#" title="Click to edit">Cancel</a></li>
                    </ul>
                  <span class="InfoView ">
                        <span class="Name" rel="name"><s:property value="name"/></span>
                        - <span class="Description" rel="description"><s:property value="description"/></span>
                    </span>
                   <span class="EditView hide">
                       <form action="${ctx}/admin/subprojects/${id}" method="post">
                           <input type="hidden" value="put" name="_method"/>
                           <span class="Field">
                            <label>Name</label>
                               <input class="Name" type="text" name="name" value="<s:property value="name"/>"/>
                           </span>
                           <span class="Field MediumField">
                            <label>Description</label>
                            <input class="Description" type="text" name="description" value="<s:property value="description"/>"/>
                               </span>
                       </form>
                    </span>

                </div>


            </s:iterator>
                <span class="Field HugeField">
                    <a class="actAddFilter" href=""><fmt:message key="heading.projects.area.add"/></a>
                </span>
            </div>

            <c:if test="${!archived}">
                <div class="New">


                <form method="post" action="${ctx}/admin/subprojects?qProject=${model.id}" id="frmAddArea" class="hide">
                    <h2>Add a new area to this project</h2>
                    <span class="Field "><s:textfield id="name" key="label.area.name" name="name" theme="xhtml" value=" "/></span>
                    <span class="Field MediumField"><s:textfield key="label.area.description" name="description" theme="xhtml" value=" "/></span>

                    <div class="Actions">
                        <ul>
                            <li><s:submit key="action.add"/></li>
                            <li><input type="button" class="actCancel" value="<fmt:message key="action.cancel"/>"/></li>
                        </ul>
                    </div>
                </form>

            </div>
            </c:if>
        </div>

    </div>
    <div class="Pane hide" id="manageVersions">
        <div class="EditableList">
             <div class="Items">
                <s:iterator value="orderedVersions" status="status" id="version">

                <div class="EditableItem">
                    <ul>
                        <s:if test="canDelete(#version) && versions.size > 1">
                            <li class="actRemove"><a href="${ctx}/admin/versions/${id}?_method=delete"><fmt:message key="action.delete"/></a></li>
                        </s:if>
                        <li class="actEdit"><a href="#" title="Click to edit">Edit</a></li>
                        <li class="actDone hide"><a href="#" title="Click to edit">Done</a></li>
                        <li class="actCancel hide"><a href="#" title="Click to edit">Cancel</a></li>
                    </ul>
                    
                    <span class="InfoView ">
                        <span class="ReleaseName Name" rel="name"><s:property value="name"/></span>
                        - <c:if test="${!(description==null || description=='')}">
                        <span class="ReleaseDescription" rel="description"><s:property value="description"/>&nbsp;</span>
                        </c:if>
                        <c:if test="${description==null || description==''}">&lt;No Description&gt;</c:if>
                        - <span class="Released Cleared" rel="released"><s:property value="%{(released)?'Released':'Due for release'}"/></span>
                        <span class="ReleaseDate" rel="release">[ <s:date name="release" format="%{getText('i18n.date.key')}"/> ]</span>
                    </span>
                   <span class="EditView hide">
                        <form action="${ctx}/admin/versions/${id}" method="post">
                            <input type="hidden" value="put" name="_method"/>

                            <span class="Field MediumField">
                                <label>Name of release</label>
                            <input class="Name" type="text" name="name" value="<s:property value="name"/>"/>
                            </span>
                            <span class="Field MediumField">
                                <label>Description</label>
                                <input class="Description" type="text" name="description" value="<s:property value="description"/>"/>
                            </span>

                            <span class="Field">
                                <label>Release Date</label><input class="Release DateField" type="text" name="release" value="<s:date name="release" format="%{getText('i18n.date.key')}"/>"/>
                            </span>
                            <span class="Field iInline">
                                <input class="inline" type="checkbox" name="released" value="true" ${(released==true)?"checked=\"checked\"":""} />
                                <label>This version is released</label>
                            </span>
                        </form>
                    </span>

                   </div>
            </s:iterator>
             <span class="Field HugeField">
                <a class="actAddFilter" href=""><fmt:message key="heading.projects.version.add"/></a>
            </span>

            </div>
            <c:if test="${!archived}">
                <div class="New">

                    <form method="post" action="${ctx}/admin/versions?qProject=${id}" class="hide">
                        <h2>Add a new version to this project</h2>
                        <span class="Field"><s:textfield id="version_name" key="label.version.name" name="name" theme="xhtml" value=""/></span>
                        <span class="Field MediumField"><s:textfield id="version_desc" key="label.version.description" name="description" theme="xhtml" value=""/></span>
                        <span class="Field"><s:textfield id="version_release" key="label.version.releasedate" name="release" theme="xhtml" value="" cssClass="DateField"/></span>
                        <div class="Actions">
                            <ul>
                                <li><s:submit key="action.add"/></li>
                                <li><input type="button" class="actCancel" value="<fmt:message key="action.cancel"/>"/></li>
                            </ul>
                        </div>
                    </form>
                </div>
            </c:if>
          </div>
    </div>
    <div class="Pane hide" id="manageResolutions">
            <div class="EditableList"><div class="Items">
                <s:iterator value="resolutions" status="status" id="resolution">
                    <div class="EditableItem">
                    <ul class="">
	                    <s:if test="canDelete(#resolution) && resolutions.size > 1">
		            		<li class="actRemove"><a href="${ctx}/admin/resolutions/${id}?_method=delete"><fmt:message key="action.delete"/></a></li>
		                </s:if>
                        <li class="actEdit"><a href="#" title="Click to edit">Edit</a></li>
                        <li class="actDone hide"><a href="#" title="Click to edit">Done</a></li>
                        <li class="actCancel hide"><a href="#" title="Click to edit">Cancel</a></li>
                    </ul>
                    <span class="InfoView ">
                        <span rel="name" class="Name"><s:property value="name"/></span>
                    </span>
                   <span class="EditView hide">
                        <form action="${ctx}/admin/resolutions/${id}" method="post">
                            <span class="Field MediumField">
                                <label>Name</label>
                                <input class="Name" type="text" name="name" value="<s:property value="name"/>"/>
                            </span>
                            <input type="hidden" value="put" name="_method"/>
                        </form>
                    </span>


                    </div>
            </s:iterator>
                <span class="Field HugeField">
                    <a class="actAddFilter" href=""><fmt:message key="heading.projects.resolution.add"/></a>
                </span>
        </div>
        <c:if test="${!archived}">
                <div class="New">


                    <form method="post" action="${ctx}/admin/resolutions?qProject=${id}" class="hide">
                        <h2>Add a new resolution to this project</h2>
                        <span class="Field"><s:textfield id="resolution_name" key="label.resolution.name" name="name" theme="xhtml" value=""/></span>

                        <div class="Actions">
                            <ul>
                                <li><s:submit key="action.add"/></li>
                                <li><input type="button" class="actCancel" value="<fmt:message key="action.cancel"/>"/></li>
                            </ul>
                        </div>
                    </form>
                </div>
            </c:if>
                </div>
    </div>

    <div class="Pane hide" id="manageIssueTypes">

        <div class="EditableList">
            <div class="Items">
            <s:iterator value="issueTypes" status="status" id="issueType">
                <div class="EditableItem">
                <form method="post" action="${ctx}/admin/issuetypes/${id}">
                    <ul class="">
	                    <s:if test="canDelete(#issueType) && issueTypes.size > 1">
		            		<li class="actRemove"><a href="${ctx}/admin/issuetypes/${id}?_method=delete"><fmt:message key="action.delete"/></a></li>
		                </s:if>
                        <li class="actEdit"><a href="#" title="Click to edit">Edit</a></li>
                        <li class="actDone hide"><a href="#" title="Click to edit">Done</a></li>
                        <li class="actCancel hide"><a href="#" title="Click to edit">Cancel</a></li>
                    </ul>

                    <span class="InfoView ">
                        <span class="Name"><s:property value="name"/></span>
                        - <span class="Description"><s:property value="description"/></span>
                    </span>
                   <span class="EditView hide">

                          <input type="hidden" value="put" name="_method"/>

                       <span class="Field ">
                           <label>Name</label><input class="Name" type="text" name="name" value="<s:property value="name"/>"/>
                       </span>
                       <span class="Field MediumField">
                            <label>Description</label><input class="Description" type="text" name="description" value="<s:property value="description"/>"/>
                       </span>
                    </span>



                    </form>
                </div>

            </s:iterator>
                <span class="Field HugeField">
                        <a class="actAddFilter" href=""><fmt:message key="heading.projects.issuetype.add"/></a>
                    </span>
            </div>

           <c:if test="${!archived}">
                <div class="New">


                    <form method="post" action="${ctx}/admin/issuetypes?qProject=${id}" class="hide">
                        <h2>Add a new issue type to this project</h2>
                        <span class="Field"><s:textfield key="label.issuetype.name" name="name" theme="xhtml" value=""/></span>
                        <span class="Field MediumField"><s:textfield key="label.issuetype.description" name="description" theme="xhtml" value=""/></span>
                        <div class="Actions">
                            <ul>
                                <li><s:submit key="action.add"/></li>
                                <li><input type="button" class="actCancel" value="<fmt:message key="action.cancel"/>"/></li>
                            </ul>
                        </div>
                    </form>
                </div>
            </c:if>
        </div>

    </div>

    <div class="Pane hide" id="manageClients">
        <div class="EditableList">
            <div class="Items">
	        <s:iterator value="clients" status="status" id="client">
	            <div class="EditableItem">
	                <span class="InfoView ">
	                    <a href="${ctx}/admin/users/${id}/edit">${fullName}</a>
	                </span>
	                <ul>
            			<li class="actRemove"><a href="${ctx}/admin/projects/${model.id}/deleteClient?client_id=${id}"><fmt:message key="action.delete"/></a></li>
	                </ul>
	            </div>
	        </s:iterator>
            <span class="Field HugeField">
                    <a class="actAddFilter" href=""><fmt:message key="heading.projects.client.add"/></a>
                </span>
        </div>

            <c:if test="${!archived && fn:length(allClients) > 0}">
                <div class="New">


                    <form method="post" action="${ctx}/admin/projects/${id}" class="hide">
                        <h2><fmt:message key="heading.projects.client.add"/></h2>
                        <input type="hidden" name="_method" value="put">
                        <span class="Field Cleared">
                            <s:select name="client_id"
                                list="allClients" listKey="id"
                                listValue="fullName" multiple="false" size="1"
                                theme="xhtml"/>
                        </span>

                        <div class="Actions">
                            <ul>
                                <li><s:submit key="action.add"/></li>
                                <li><input type="button" class="actCancel" value="<fmt:message key="action.cancel"/>"/></li>
                            </ul>
                        </div>
                   </form>
                </div>
            </c:if>
        </div>
    </div>

    <c:if test="${restricted}">
    <div class="Pane hide" id="manageUsers">
        <div class="EditableList">
            <div class="Items">
	        <s:iterator value="users" status="status" id="user">
	            <div class="EditableItem">
	                <span class="InfoView ">
	                    <a href="${ctx}/admin/users/${id}/edit">${fullName}</a>
	                </span>
	                <ul>
            			<li class="actRemove"><a href="${ctx}/admin/projects/${model.id}/deleteUser?user_id=${id}"><fmt:message key="action.delete"/></a></li>
	                </ul>
	            </div>
	        </s:iterator>
            <span class="Field HugeField">
                    <a class="actAddFilter" href=""><fmt:message key="heading.projects.user.add"/></a>
              </span>
        </div>

            <c:if test="${!archived && fn:length(allUsers) > 0}">
                <div class="New">
                    <form method="post" action="${ctx}/admin/projects/${id}" class="hide">
                        <h2><fmt:message key="heading.projects.user.add"/></h2>
                        <input type="hidden" name="_method" value="put">
                        <span class="Field Cleared">
                            <s:select name="user_id"
                                list="allUsers" listKey="id"
                                listValue="fullName" multiple="false" size="1"
                                theme="xhtml"/>
                        </span>

                        <div class="Actions">
                            <ul>
                                <li><s:submit key="action.add"/></li>
                                <li><input type="button" class="actCancel" value="<fmt:message key="action.cancel"/>"/></li>
                            </ul>
                        </div>
                   </form>
                </div>
            </c:if>
        </div>
    </div>
    </c:if>



</div>
    </div>
</c:set>

<div class="realContent">
    <c:import url="/WEB-INF/pages/includes/administration/menu/default.jsp">
        <c:param name="pageName" value="Projects"/>
        <c:param name="content" value="${panelContent}"/>
    </c:import>


