<%@ include file="/common/taglibs.jsp" %>

<head>
    <title><fmt:message key="title.admin.priorities"/></title>
    <meta name="menu" content="admin"/>
    <script type="text/javascript" src="/scripts/com/hedgehoglab/fixx/controller/PriorityIndexController.js?<fmt:message key="webapp.version"/>"></script>
</head>
<c:set var="panelContent">
    <div class="Pane">
        <h2 id="prioritiesH"><fmt:message key="heading.priorities"/><span class="doing hide">saving</span></h2>
        <div class="feedback notification _floating hide" id="prioritiesF">
            <p><fmt:message key="text.notification.prioritySaved"/></p>
        </div>
        <div class="PriorityList">
            <s:iterator value="priorities" id="item">
                <div class="PriorityItem">

                    <form action="/admin/priorities/${id}">

                         <ul class="">
                        <li class="actEdit"><a href="#" title="Click to edit">Edit</a></li>
                        <li class="actDone hide"><a href="#" title="Click to edit">Done</a></li>
                        <li class="actCancel hide"><a href="#" title="Click to edit">Cancel</a></li>
                        <li class="actMove"><a class="Anchor" href="# "  title="Drag to move.">Move</a></li>
                    </ul>
                         <s:hidden name="_method" value="put"/>
                    <span class="InfoView ">
                        <span class="Weight"><s:property value="weight"/></span>
                        <span class="Name"> <s:property value="name"/></span>
                        -<span class="Description"><s:property value="description"/></span>
                    </span>
                    <span class="EditView hide">
                        <input type="hidden" class="weight" value="<s:property value="id"/>"/>
                        <span class="Field MediumField"><label><fmt:message key="label.priority.name"/></label><input class="Name" type="text" name="name" value="<s:property value="name"/>"/></span>
                        <span class="Field MediumField"><label><fmt:message key="label.priority.description"/></label><input class="Description" type="text" name="description" value="<s:property value="description"/>"/></span>
                    </span>
                        

                    </form>
                </div>
             </s:iterator>

        </div>
        <form action="/admin/priorities/" id="sortOrder" class="hide">
                <input name="new_order" id="new_order"/>
        </form>
        <div id="output">
        </div>
    </div>
</c:set>


<div class="rightPanel">
    <div class="PropertyPane">
        <h2>Help</h2>
        <div class="Pane">
            <h3>Changing the order</h3>
            <p>The order of priorities can be changed by dragging them. Each priority is given a weight
            based on the order in the list from top to bottom.</p>
        </div>
    </div>
</div>

<div class="realContent">
    <c:import url="/WEB-INF/pages/includes/administration/menu/default.jsp">
        <c:param name="pageName" value="Priorities"/>
        <c:param name="content" value="${panelContent}"/>
    </c:import>
</div>