/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.license.ftp;

import de.schlichtherle.license.IllegalPasswordException;
import de.schlichtherle.license.KeyStoreParam;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseNotary;
import de.schlichtherle.license.LicenseParam;
import de.schlichtherle.license.NoLicenseInstalledException;
import de.schlichtherle.license.ftp.Resources;
import de.schlichtherle.util.ObfuscatedString;
import java.util.Calendar;
import java.util.Date;
import javax.security.auth.x500.X500Principal;

public class LicenseManager
extends de.schlichtherle.license.LicenseManager {
    private static final String FTP_KEYSTORE_PARAM = new ObfuscatedString(new long[]{6540942263743768505L, -6059958959638303164L, 6377465279464853391L}).toString();
    private static final String EQUAL_KEY_STORE_PARAMS = new ObfuscatedString(new long[]{5508595700258006979L, 4658549383733098011L, 4696761698113697678L, 7544341226212718087L, 8821059208312938461L, 302546095417378367L, 4227466611521490562L, -1772332321125311578L}).toString();
    private static final String FTP_DAYS = new ObfuscatedString(new long[]{8356037110043899424L, 4664078144517272142L}).toString();
    private LicenseNotary ftpNotary;
    private static final String CN_FTP_USER = CN + Resources.getString(new ObfuscatedString(new long[]{-6534999889298787160L, -4220048377725910008L}).toString());

    protected LicenseManager() {
    }

    public LicenseManager(de.schlichtherle.license.ftp.LicenseParam licenseParam) throws NullPointerException, IllegalPasswordException {
        this.setLicenseParam(licenseParam);
    }

    public synchronized void setLicenseParam(LicenseParam licenseParam) throws NullPointerException, IllegalPasswordException {
        de.schlichtherle.license.ftp.LicenseParam licenseParam2 = (de.schlichtherle.license.ftp.LicenseParam)licenseParam;
        KeyStoreParam keyStoreParam = licenseParam2.getFTPKeyStoreParam();
        if (keyStoreParam == null) {
            throw new NullPointerException(FTP_KEYSTORE_PARAM);
        }
        if (keyStoreParam.equals(licenseParam2.getKeyStoreParam())) {
            throw new IllegalArgumentException(EQUAL_KEY_STORE_PARAMS);
        }
        int n = licenseParam2.getFTPDays();
        if (0 >= n || n > 365) {
            throw new IllegalArgumentException(new ObfuscatedString(new long[]{-8447909007698265338L, 3963998191526449092L}).toString());
        }
        super.setLicenseParam(licenseParam2);
    }

    protected synchronized LicenseContent verify(LicenseNotary licenseNotary) throws Exception {
        try {
            return super.verify(licenseNotary);
        }
        catch (Exception exception) {
            de.schlichtherle.license.ftp.LicenseParam licenseParam = (de.schlichtherle.license.ftp.LicenseParam)this.getLicenseParam();
            LicenseNotary licenseNotary2 = this.getFTPLicenseNotary();
            byte[] byArray = this.getLicenseKey();
            if (byArray != null) {
                return super.verify(licenseNotary2);
            }
            if (!licenseParam.isFTPEligible()) {
                throw new NoLicenseInstalledException(licenseParam.getSubject());
            }
            LicenseContent licenseContent = licenseParam.createFTPLicenseContent();
            licenseContent.setNotAfter(this.ftpNotAfter(licenseParam.getFTPDays()));
            licenseContent = this.install(this.create(licenseContent, licenseNotary2), licenseNotary2);
            licenseParam.removeFTPEligibility();
            licenseParam.ftpGranted(licenseContent);
            return licenseContent;
        }
    }

    protected synchronized void initialize(LicenseContent licenseContent) {
        if (licenseContent.getHolder() == null) {
            licenseContent.setHolder(new X500Principal(CN_FTP_USER));
        }
        super.initialize(licenseContent);
    }

    protected synchronized LicenseNotary getFTPLicenseNotary() throws Exception {
        if (this.ftpNotary == null) {
            this.ftpNotary = new LicenseNotary(((de.schlichtherle.license.ftp.LicenseParam)this.getLicenseParam()).getFTPKeyStoreParam());
        }
        return this.ftpNotary;
    }

    protected Date ftpNotAfter(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(LicenseManager.midnight());
        calendar.add(5, n);
        return calendar.getTime();
    }
}

