/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.license;

import de.schlichtherle.license.CipherParam;
import de.schlichtherle.license.IllegalPasswordException;
import de.schlichtherle.license.LicenseNotary;
import de.schlichtherle.license.Policy;
import de.schlichtherle.util.ObfuscatedString;
import de.schlichtherle.xml.GenericCertificate;
import de.schlichtherle.xml.PersistenceService;
import de.schlichtherle.xml.PersistenceServiceException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class PrivacyGuard {
    private static final String PBE_WITH_MD5_AND_DES = new ObfuscatedString(new long[]{2860604316472308139L, 5030391952891038168L, -6110818099732428353L}).toString();
    private CipherParam param;
    private Cipher cipher;
    private SecretKey key;
    private AlgorithmParameterSpec algoParamSpec;

    protected PrivacyGuard() {
    }

    public PrivacyGuard(CipherParam cipherParam) {
        this.setCipherParam(cipherParam);
    }

    public CipherParam getCipherParam() {
        return this.param;
    }

    public void setCipherParam(CipherParam cipherParam) throws NullPointerException, IllegalPasswordException {
        if (cipherParam == null) {
            throw new NullPointerException(LicenseNotary.PARAM);
        }
        Policy.getCurrent().checkPwd(cipherParam.getKeyPwd());
        this.param = cipherParam;
        this.cipher = null;
        this.key = null;
        this.algoParamSpec = null;
    }

    public byte[] cert2key(GenericCertificate genericCertificate) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(new CipherOutputStream(byteArrayOutputStream, this.getCipher4Encryption()));
        try {
            PersistenceService.store((Object)genericCertificate, (OutputStream)gZIPOutputStream);
        }
        catch (PersistenceServiceException persistenceServiceException) {
            throw new AssertionError((Object)persistenceServiceException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericCertificate key2cert(byte[] byArray) throws Exception {
        GenericCertificate genericCertificate;
        GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(this.getCipher4Decryption().doFinal(byArray)));
        try {
            genericCertificate = (GenericCertificate)PersistenceService.load((InputStream)gZIPInputStream);
        }
        finally {
            try {
                ((InputStream)gZIPInputStream).close();
            }
            catch (IOException iOException) {}
        }
        return genericCertificate;
    }

    protected Cipher getCipher4Encryption() {
        Cipher cipher = this.getCipher();
        try {
            cipher.init(1, (Key)this.key, this.algoParamSpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AssertionError((Object)invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new AssertionError((Object)invalidAlgorithmParameterException);
        }
        return cipher;
    }

    protected Cipher getCipher4Decryption() {
        Cipher cipher = this.getCipher();
        try {
            cipher.init(2, (Key)this.key, this.algoParamSpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AssertionError((Object)invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new AssertionError((Object)invalidAlgorithmParameterException);
        }
        return cipher;
    }

    protected Cipher getCipher() {
        if (this.cipher != null) {
            return this.cipher;
        }
        this.algoParamSpec = new PBEParameterSpec(new byte[]{-50, -5, -34, -84, 5, 2, 25, 113}, 2005);
        try {
            PBEKeySpec pBEKeySpec = new PBEKeySpec(this.getCipherParam().getKeyPwd().toCharArray());
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(PBE_WITH_MD5_AND_DES);
            this.key = secretKeyFactory.generateSecret(pBEKeySpec);
            this.cipher = Cipher.getInstance(PBE_WITH_MD5_AND_DES);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new AssertionError((Object)invalidKeySpecException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new AssertionError((Object)noSuchPaddingException);
        }
        return this.cipher;
    }
}

