/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.Result;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import org.apache.struts2.ServletActionContext;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

public class ChartResult
implements Result {
    private static final long serialVersionUID = -6484761870055986612L;
    private static final String DEFAULT_TYPE = "png";
    private static final String DEFAULT_VALUE = "chart";
    private JFreeChart chart;
    private boolean chartSet;
    Integer height;
    Integer width;
    String type = "png";
    String value = "chart";

    public ChartResult() {
    }

    public ChartResult(JFreeChart chart, int height, int width) {
        this.chart = chart;
        this.height = height;
        this.width = width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public void setChart(JFreeChart chart) {
        this.chartSet = true;
        this.chart = chart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ActionInvocation invocation) throws Exception {
        block10: {
            if (!this.chartSet) {
                this.chart = (JFreeChart)invocation.getStack().findValue(this.value, JFreeChart.class);
            }
            if (this.chart == null) {
                throw new NullPointerException("No JFreeChart object found on the stack with name " + this.value);
            }
            if (this.height == null) {
                throw new NullPointerException("No height parameter was given.");
            }
            if (this.width == null) {
                throw new NullPointerException("No width parameter was given.");
            }
            ServletOutputStream os = ServletActionContext.getResponse().getOutputStream();
            try {
                if (DEFAULT_TYPE.equalsIgnoreCase(this.type)) {
                    ChartUtilities.writeChartAsPNG((OutputStream)os, (JFreeChart)this.chart, (int)this.width, (int)this.height);
                    break block10;
                }
                if ("jpg".equalsIgnoreCase(this.type) || "jpeg".equalsIgnoreCase(this.type)) {
                    ChartUtilities.writeChartAsJPEG((OutputStream)os, (JFreeChart)this.chart, (int)this.width, (int)this.height);
                    break block10;
                }
                throw new IllegalArgumentException(this.type + " is not a supported render type (only JPG and PNG are).");
            }
            finally {
                if (os != null) {
                    os.flush();
                }
            }
        }
    }
}

