/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.intercept.web.DefaultFilterInvocationDefinitionSource;
import org.springframework.security.intercept.web.FIDSToFilterChainMapConverter;
import org.springframework.security.intercept.web.FilterInvocation;
import org.springframework.security.intercept.web.FilterInvocationDefinitionSource;
import org.springframework.security.util.AntUrlPathMatcher;
import org.springframework.security.util.UrlMatcher;
import org.springframework.util.Assert;

public class FilterChainProxy
implements Filter,
InitializingBean,
ApplicationContextAware {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$util$FilterChainProxy == null ? (class$org$springframework$security$util$FilterChainProxy = FilterChainProxy.class$("org.springframework.security.util.FilterChainProxy")) : class$org$springframework$security$util$FilterChainProxy));
    public static final String TOKEN_NONE = "#NONE#";
    private ApplicationContext applicationContext;
    private Map uncompiledFilterChainMap;
    private Map filterChainMap;
    private UrlMatcher matcher = new AntUrlPathMatcher();
    private DefaultFilterInvocationDefinitionSource fids;
    static /* synthetic */ Class class$org$springframework$security$util$FilterChainProxy;
    static /* synthetic */ Class class$org$springframework$security$intercept$web$DefaultFilterInvocationDefinitionSource;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$javax$servlet$Filter;

    public void afterPropertiesSet() throws Exception {
        if (this.fids != null) {
            Assert.isNull((Object)this.uncompiledFilterChainMap, (String)"Set the filterChainMap or FilterInvocationDefinitionSource but not both");
            FIDSToFilterChainMapConverter converter = new FIDSToFilterChainMapConverter(this.fids, this.applicationContext);
            this.setFilterChainMap(converter.getFilterChainMap());
            this.setMatcher(converter.getMatcher());
            this.fids = null;
        }
        Assert.notNull((Object)this.uncompiledFilterChainMap, (String)"filterChainMap must be set");
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        Filter[] filters = this.obtainAllDefinedFilters();
        for (int i = 0; i < filters.length; ++i) {
            if (filters[i] == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Initializing Filter defined in ApplicationContext: '" + filters[i].toString() + "'"));
            }
            filters[i].init(filterConfig);
        }
    }

    public void destroy() {
        Filter[] filters = this.obtainAllDefinedFilters();
        for (int i = 0; i < filters.length; ++i) {
            if (filters[i] == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Destroying Filter defined in ApplicationContext: '" + filters[i].toString() + "'"));
            }
            filters[i].destroy();
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        FilterInvocation fi = new FilterInvocation(request, response, chain);
        List filters = this.getFilters(fi.getRequestUrl());
        if (filters == null || filters.size() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(fi.getRequestUrl() + filters == null ? " has no matching filters" : " has an empty filter list"));
            }
            chain.doFilter(request, response);
            return;
        }
        VirtualFilterChain virtualFilterChain = new VirtualFilterChain(fi, filters);
        virtualFilterChain.doFilter(fi.getRequest(), fi.getResponse());
    }

    List getFilters(String url) {
        Iterator filterChains = this.filterChainMap.entrySet().iterator();
        while (filterChains.hasNext()) {
            Map.Entry entry = filterChains.next();
            Object path = entry.getKey();
            if (this.matcher.requiresLowerCaseUrl()) {
                url = url.toLowerCase();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Converted URL to lowercase, from: '" + url + "'; to: '" + url + "'"));
                }
            }
            boolean matched = this.matcher.pathMatchesUrl(path, url);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Candidate is: '" + url + "'; pattern is " + path + "; matched=" + matched));
            }
            if (!matched) continue;
            return (List)entry.getValue();
        }
        return null;
    }

    protected Filter[] obtainAllDefinedFilters() {
        LinkedHashSet allFilters = new LinkedHashSet();
        Iterator it = this.filterChainMap.values().iterator();
        while (it.hasNext()) {
            allFilters.addAll((List)it.next());
        }
        return new ArrayList(allFilters).toArray(new Filter[0]);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setFilterInvocationDefinitionSource(FilterInvocationDefinitionSource fids) {
        Assert.isInstanceOf((Class)(class$org$springframework$security$intercept$web$DefaultFilterInvocationDefinitionSource == null ? (class$org$springframework$security$intercept$web$DefaultFilterInvocationDefinitionSource = FilterChainProxy.class$("org.springframework.security.intercept.web.DefaultFilterInvocationDefinitionSource")) : class$org$springframework$security$intercept$web$DefaultFilterInvocationDefinitionSource), (Object)fids, (String)"Must be a DefaultFilterInvocationDefinitionSource");
        this.fids = (DefaultFilterInvocationDefinitionSource)fids;
    }

    public void setFilterChainMap(Map filterChainMap) {
        this.uncompiledFilterChainMap = new LinkedHashMap(filterChainMap);
        this.checkPathOrder();
        this.createCompiledMap();
    }

    private void checkPathOrder() {
        String[] paths = this.uncompiledFilterChainMap.keySet().toArray(new String[0]);
        String universalMatch = this.matcher.getUniversalMatchPattern();
        for (int i = 0; i < paths.length - 1; ++i) {
            if (!paths[i].equals(universalMatch)) continue;
            throw new IllegalArgumentException("A universal match pattern " + universalMatch + " is defined " + " before other patterns in the filter chain, causing them to be ignored. Please check the " + "ordering in your <security:http> namespace or FilterChainProxy bean configuration");
        }
    }

    private void createCompiledMap() {
        Iterator paths = this.uncompiledFilterChainMap.keySet().iterator();
        this.filterChainMap = new LinkedHashMap(this.uncompiledFilterChainMap.size());
        while (paths.hasNext()) {
            Object path = paths.next();
            Assert.isInstanceOf((Class)(class$java$lang$String == null ? FilterChainProxy.class$("java.lang.String") : class$java$lang$String), path, (String)"Path pattern must be a String");
            Object compiledPath = this.matcher.compile((String)path);
            Object filters = this.uncompiledFilterChainMap.get(path);
            Assert.isInstanceOf((Class)(class$java$util$List == null ? FilterChainProxy.class$("java.util.List") : class$java$util$List), filters);
            Iterator filterIterator = ((List)filters).iterator();
            while (filterIterator.hasNext()) {
                Object filter = filterIterator.next();
                Assert.isInstanceOf((Class)(class$javax$servlet$Filter == null ? FilterChainProxy.class$("javax.servlet.Filter") : class$javax$servlet$Filter), filter, (String)"Objects in filter chain must be of type Filter. ");
            }
            this.filterChainMap.put(compiledPath, filters);
        }
    }

    public Map getFilterChainMap() {
        return new LinkedHashMap(this.uncompiledFilterChainMap);
    }

    public void setMatcher(UrlMatcher matcher) {
        this.matcher = matcher;
    }

    public UrlMatcher getMatcher() {
        return this.matcher;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("FilterChainProxy[");
        sb.append(" UrlMatcher = ").append(this.matcher);
        sb.append("; Filter Chains: ");
        sb.append(this.uncompiledFilterChainMap);
        sb.append("]");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class VirtualFilterChain
    implements FilterChain {
        private FilterInvocation fi;
        private List additionalFilters;
        private int currentPosition = 0;

        private VirtualFilterChain(FilterInvocation filterInvocation, List additionalFilters) {
            this.fi = filterInvocation;
            this.additionalFilters = additionalFilters;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this.currentPosition == this.additionalFilters.size()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(this.fi.getRequestUrl() + " reached end of additional filter chain; proceeding with original chain"));
                }
                this.fi.getChain().doFilter(request, response);
            } else {
                ++this.currentPosition;
                Filter nextFilter = (Filter)this.additionalFilters.get(this.currentPosition - 1);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(this.fi.getRequestUrl() + " at position " + this.currentPosition + " of " + this.additionalFilters.size() + " in additional filter chain; firing Filter: '" + nextFilter + "'"));
                }
                nextFilter.doFilter(request, response, (FilterChain)this);
            }
        }
    }
}

