/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.userdetails.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.ldap.LdapUtils;
import org.springframework.security.userdetails.ldap.LdapUserDetails;
import org.springframework.security.userdetails.ldap.LdapUserDetailsImpl;
import org.springframework.util.Assert;

public class Person
extends LdapUserDetailsImpl {
    private String sn;
    private List cn = new ArrayList();

    protected Person() {
    }

    public String getSn() {
        return this.sn;
    }

    public String[] getCn() {
        return this.cn.toArray(new String[this.cn.size()]);
    }

    protected void populateContext(DirContextAdapter adapter) {
        adapter.setAttributeValue("sn", (Object)this.sn);
        adapter.setAttributeValues("cn", (Object[])this.getCn());
        if (this.getPassword() != null) {
            adapter.setAttributeValue("userPassword", (Object)this.getPassword());
        }
        adapter.setAttributeValues("objectclass", (Object[])new String[]{"top", "person"});
    }

    public static class Essence
    extends LdapUserDetailsImpl.Essence {
        public Essence() {
        }

        public Essence(DirContextOperations ctx) {
            super(ctx);
            this.setCn(ctx.getStringAttributes("cn"));
            this.setSn(ctx.getStringAttribute("sn"));
            Object passo = ctx.getObjectAttribute("userPassword");
            if (passo != null) {
                String password = LdapUtils.convertPasswordToString(passo);
                this.setPassword(password);
            }
        }

        public Essence(Person copyMe) {
            super(copyMe);
            this.setSn(copyMe.sn);
            ((Person)this.instance).cn = new ArrayList(copyMe.cn);
        }

        protected LdapUserDetailsImpl createTarget() {
            return new Person();
        }

        public void setSn(String sn) {
            ((Person)this.instance).sn = sn;
        }

        public void setCn(String[] cn) {
            ((Person)this.instance).cn = Arrays.asList(cn);
        }

        public void addCn(String value) {
            ((Person)this.instance).cn.add(value);
        }

        public LdapUserDetails createUserDetails() {
            Person p = (Person)super.createUserDetails();
            Assert.hasLength((String)p.sn);
            Assert.notNull((Object)p.cn);
            Assert.notEmpty((Collection)p.cn);
            return p;
        }
    }
}

