/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.userdetails.ldap;

import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.userdetails.ldap.LdapUserDetailsImpl;
import org.springframework.security.userdetails.ldap.Person;

public class InetOrgPerson
extends Person {
    private String mail;
    private String uid;
    private String employeeNumber;
    private String destinationIndicator;

    public String getMail() {
        return this.mail;
    }

    public String getUid() {
        return this.uid;
    }

    public String getEmployeeNumber() {
        return this.employeeNumber;
    }

    public String getDestinationIndicator() {
        return this.destinationIndicator;
    }

    protected void populateContext(DirContextAdapter adapter) {
        super.populateContext(adapter);
        adapter.setAttributeValue("mail", (Object)this.mail);
        adapter.setAttributeValue("uid", (Object)this.uid);
        adapter.setAttributeValue("employeeNumber", (Object)this.employeeNumber);
        adapter.setAttributeValue("destinationIndicator", (Object)this.destinationIndicator);
        adapter.setAttributeValues("objectclass", (Object[])new String[]{"top", "person", "organizationalPerson", "inetOrgPerson"});
    }

    public static class Essence
    extends Person.Essence {
        public Essence() {
        }

        public Essence(InetOrgPerson copyMe) {
            super(copyMe);
            this.setMail(copyMe.getMail());
            this.setUid(copyMe.getUid());
            this.setDestinationIndicator(copyMe.getDestinationIndicator());
            this.setEmployeeNumber(copyMe.getEmployeeNumber());
        }

        public Essence(DirContextOperations ctx) {
            super(ctx);
            this.setMail(ctx.getStringAttribute("mail"));
            this.setUid(ctx.getStringAttribute("uid"));
            this.setEmployeeNumber(ctx.getStringAttribute("employeeNumber"));
            this.setDestinationIndicator(ctx.getStringAttribute("destinationIndicator"));
        }

        protected LdapUserDetailsImpl createTarget() {
            return new InetOrgPerson();
        }

        public void setMail(String email) {
            ((InetOrgPerson)this.instance).mail = email;
        }

        public void setUid(String uid) {
            ((InetOrgPerson)this.instance).uid = uid;
            if (this.instance.getUsername() == null) {
                this.setUsername(uid);
            }
        }

        public void setEmployeeNumber(String no) {
            ((InetOrgPerson)this.instance).employeeNumber = no;
        }

        public void setDestinationIndicator(String destination) {
            ((InetOrgPerson)this.instance).destinationIndicator = destination;
        }
    }
}

