/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.preauth.websphere;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class WASSecurityHelper {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$ui$preauth$websphere$WASSecurityHelper == null ? (class$org$springframework$security$ui$preauth$websphere$WASSecurityHelper = WASSecurityHelper.class$("org.springframework.security.ui.preauth.websphere.WASSecurityHelper")) : class$org$springframework$security$ui$preauth$websphere$WASSecurityHelper));
    private static final String USER_REGISTRY = "UserRegistry";
    private static Method getRunAsSubject = null;
    private static Method getWSCredentialFromSubject = null;
    private static Method getGroupsForUser = null;
    private static Method getSecurityName = null;
    static /* synthetic */ Class class$org$springframework$security$ui$preauth$websphere$WASSecurityHelper;

    WASSecurityHelper() {
    }

    private static final String getSecurityName(Subject subject) {
        Object credential;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Determining Websphere security name for subject " + subject));
        }
        String userSecurityName = null;
        if (subject != null && (credential = WASSecurityHelper.invokeMethod(WASSecurityHelper.getWSCredentialFromSubjectMethod(), null, new Object[]{subject})) != null) {
            userSecurityName = (String)WASSecurityHelper.invokeMethod(WASSecurityHelper.getSecurityNameMethod(), credential, null);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Websphere security name is " + userSecurityName + " for subject " + subject));
        }
        return userSecurityName;
    }

    private static final Subject getRunAsSubject() {
        logger.debug((Object)"Retrieving WebSphere RunAs subject");
        return (Subject)WASSecurityHelper.invokeMethod(WASSecurityHelper.getRunAsSubjectMethod(), null, new Object[0]);
    }

    private static final String[] getWebSphereGroups(Subject subject) {
        return WASSecurityHelper.getWebSphereGroups(WASSecurityHelper.getSecurityName(subject));
    }

    private static final String[] getWebSphereGroups(String securityName) {
        InitialContext ic = null;
        try {
            ic = new InitialContext();
            Object objRef = ic.lookup(USER_REGISTRY);
            Object userReg = PortableRemoteObject.narrow((Object)objRef, Class.forName("com.ibm.websphere.security.UserRegistry"));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Determining WebSphere groups for user " + securityName + " using WebSphere UserRegistry " + userReg));
            }
            Collection groups = (Collection)WASSecurityHelper.invokeMethod(WASSecurityHelper.getGroupsForUserMethod(), userReg, new Object[]{securityName});
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Groups for user " + securityName + ": " + groups.toString()));
            }
            String[] result = new String[groups.size()];
            String[] stringArray = groups.toArray(result);
            return stringArray;
        }
        catch (Exception e) {
            logger.error((Object)"Exception occured while looking up groups for user", (Throwable)e);
            throw new RuntimeException("Exception occured while looking up groups for user", e);
        }
        finally {
            try {
                ic.close();
            }
            catch (NamingException e) {
                logger.debug((Object)"Exception occured while closing context", (Throwable)e);
            }
        }
    }

    public static final String[] getGroupsForCurrentUser() {
        return WASSecurityHelper.getWebSphereGroups(WASSecurityHelper.getRunAsSubject());
    }

    public static final String getCurrentUserName() {
        return WASSecurityHelper.getSecurityName(WASSecurityHelper.getRunAsSubject());
    }

    private static final Object invokeMethod(Method method, Object instance, Object[] args) {
        try {
            return method.invoke(instance, args);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)("Error while invoking method " + method.getClass().getName() + "." + method.getName() + "(" + Arrays.asList(args) + ")"), (Throwable)e);
            throw new RuntimeException("Error while invoking method " + method.getClass().getName() + "." + method.getName() + "(" + Arrays.asList(args) + ")", e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)("Error while invoking method " + method.getClass().getName() + "." + method.getName() + "(" + Arrays.asList(args) + ")"), (Throwable)e);
            throw new RuntimeException("Error while invoking method " + method.getClass().getName() + "." + method.getName() + "(" + Arrays.asList(args) + ")", e);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)("Error while invoking method " + method.getClass().getName() + "." + method.getName() + "(" + Arrays.asList(args) + ")"), (Throwable)e);
            throw new RuntimeException("Error while invoking method " + method.getClass().getName() + "." + method.getName() + "(" + Arrays.asList(args) + ")", e);
        }
    }

    private static final Method getMethod(String className, String methodName, String[] parameterTypeNames) {
        try {
            Class<?> c = Class.forName(className);
            int len = parameterTypeNames.length;
            Class[] parameterTypes = new Class[len];
            for (int i = 0; i < len; ++i) {
                parameterTypes[i] = Class.forName(parameterTypeNames[i]);
            }
            return c.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("Required class" + className + " not found"));
            throw new RuntimeException("Required class" + className + " not found", e);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)("Required method " + methodName + " with parameter types (" + Arrays.asList(parameterTypeNames) + ") not found on class " + className));
            throw new RuntimeException("Required class" + className + " not found", e);
        }
    }

    private static final Method getRunAsSubjectMethod() {
        if (getRunAsSubject == null) {
            getRunAsSubject = WASSecurityHelper.getMethod("com.ibm.websphere.security.auth.WSSubject", "getRunAsSubject", new String[0]);
        }
        return getRunAsSubject;
    }

    private static final Method getWSCredentialFromSubjectMethod() {
        if (getWSCredentialFromSubject == null) {
            getWSCredentialFromSubject = WASSecurityHelper.getMethod("com.ibm.ws.security.auth.SubjectHelper", "getWSCredentialFromSubject", new String[]{"javax.security.auth.Subject"});
        }
        return getWSCredentialFromSubject;
    }

    private static final Method getGroupsForUserMethod() {
        if (getGroupsForUser == null) {
            getGroupsForUser = WASSecurityHelper.getMethod("com.ibm.websphere.security.UserRegistry", "getGroupsForUser", new String[]{"java.lang.String"});
        }
        return getGroupsForUser;
    }

    private static final Method getSecurityNameMethod() {
        if (getSecurityName == null) {
            getSecurityName = WASSecurityHelper.getMethod("com.ibm.websphere.security.cred.WSCredential", "getSecurityName", new String[0]);
        }
        return getSecurityName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

