/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.logout;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.ui.FilterChainOrder;
import org.springframework.security.ui.SpringSecurityFilter;
import org.springframework.security.ui.logout.LogoutHandler;
import org.springframework.security.util.RedirectUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class LogoutFilter
extends SpringSecurityFilter {
    private String filterProcessesUrl = "/j_spring_security_logout";
    private String logoutSuccessUrl;
    private LogoutHandler[] handlers;
    private boolean useRelativeContext;

    public LogoutFilter(String logoutSuccessUrl, LogoutHandler[] handlers) {
        Assert.notEmpty((Object[])handlers, (String)"LogoutHandlers are required");
        this.logoutSuccessUrl = logoutSuccessUrl;
        this.handlers = handlers;
    }

    public void doFilterHttp(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.requiresLogout(request, response)) {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Logging out user '" + auth + "' and redirecting to logout page"));
            }
            for (int i = 0; i < this.handlers.length; ++i) {
                this.handlers[i].logout(request, response, auth);
            }
            String targetUrl = this.determineTargetUrl(request, response);
            this.sendRedirect(request, response, targetUrl);
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected boolean requiresLogout(HttpServletRequest request, HttpServletResponse response) {
        int queryParamIndex;
        String uri = request.getRequestURI();
        int pathParamIndex = uri.indexOf(59);
        if (pathParamIndex > 0) {
            uri = uri.substring(0, pathParamIndex);
        }
        if ((queryParamIndex = uri.indexOf(63)) > 0) {
            uri = uri.substring(0, queryParamIndex);
        }
        if ("".equals(request.getContextPath())) {
            return uri.endsWith(this.filterProcessesUrl);
        }
        return uri.endsWith(request.getContextPath() + this.filterProcessesUrl);
    }

    protected String determineTargetUrl(HttpServletRequest request, HttpServletResponse response) {
        String targetUrl = request.getParameter("logoutSuccessUrl");
        if (!StringUtils.hasLength((String)targetUrl)) {
            targetUrl = this.logoutSuccessUrl;
        }
        if (!StringUtils.hasLength((String)targetUrl)) {
            targetUrl = request.getHeader("Referer");
        }
        if (!StringUtils.hasLength((String)targetUrl)) {
            targetUrl = "/";
        }
        return targetUrl;
    }

    protected void sendRedirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
        RedirectUtils.sendRedirect(request, response, url, this.useRelativeContext);
    }

    public void setFilterProcessesUrl(String filterProcessesUrl) {
        Assert.hasText((String)filterProcessesUrl, (String)"FilterProcessesUrl required");
        this.filterProcessesUrl = filterProcessesUrl;
    }

    protected String getFilterProcessesUrl() {
        return this.filterProcessesUrl;
    }

    public void setUseRelativeContext(boolean useRelativeContext) {
        this.useRelativeContext = useRelativeContext;
    }

    public int getOrder() {
        return FilterChainOrder.LOGOUT_FILTER;
    }
}

