/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.intercept.web;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.intercept.web.FilterInvocation;
import org.springframework.security.intercept.web.FilterInvocationDefinitionSource;
import org.springframework.security.intercept.web.RequestKey;
import org.springframework.security.util.UrlMatcher;

public class DefaultFilterInvocationDefinitionSource
implements FilterInvocationDefinitionSource {
    private static final Set HTTP_METHODS = new HashSet<String>(Arrays.asList("DELETE", "GET", "HEAD", "OPTIONS", "POST", "PUT", "TRACE"));
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Map requestMap = new LinkedHashMap();
    private Map httpMethodMap = new HashMap();
    private UrlMatcher urlMatcher;
    private boolean stripQueryStringFromUrls;
    static /* synthetic */ Class class$org$springframework$security$intercept$web$FilterInvocation;

    DefaultFilterInvocationDefinitionSource(UrlMatcher urlMatcher) {
        this.urlMatcher = urlMatcher;
    }

    public DefaultFilterInvocationDefinitionSource(UrlMatcher urlMatcher, LinkedHashMap requestMap) {
        this.urlMatcher = urlMatcher;
        Iterator iterator = ((HashMap)requestMap).entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            RequestKey reqKey = (RequestKey)entry.getKey();
            this.addSecureUrl(reqKey.getUrl(), reqKey.getMethod(), (ConfigAttributeDefinition)entry.getValue());
        }
    }

    void addSecureUrl(String pattern, ConfigAttributeDefinition attr) {
        this.addSecureUrl(pattern, null, attr);
    }

    void addSecureUrl(String pattern, String method, ConfigAttributeDefinition attr) {
        Map mapToUse = this.getRequestMapForHttpMethod(method);
        mapToUse.put(this.urlMatcher.compile(pattern), attr);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Added URL pattern: " + pattern + "; attributes: " + attr + (method == null ? "" : " for HTTP method '" + method + "'")));
        }
    }

    private Map getRequestMapForHttpMethod(String method) {
        if (method == null) {
            return this.requestMap;
        }
        if (!HTTP_METHODS.contains(method)) {
            throw new IllegalArgumentException("Unrecognised HTTP method: '" + method + "'");
        }
        LinkedHashMap methodRequestmap = (LinkedHashMap)this.httpMethodMap.get(method);
        if (methodRequestmap == null) {
            methodRequestmap = new LinkedHashMap();
            this.httpMethodMap.put(method, methodRequestmap);
        }
        return methodRequestmap;
    }

    public Collection getConfigAttributeDefinitions() {
        return Collections.unmodifiableCollection(this.getRequestMap().values());
    }

    public ConfigAttributeDefinition getAttributes(Object object) throws IllegalArgumentException {
        if (object == null || !this.supports(object.getClass())) {
            throw new IllegalArgumentException("Object must be a FilterInvocation");
        }
        String url = ((FilterInvocation)object).getRequestUrl();
        String method = ((FilterInvocation)object).getHttpRequest().getMethod();
        return this.lookupAttributes(url, method);
    }

    protected ConfigAttributeDefinition lookupAttributes(String url) {
        return this.lookupAttributes(url, null);
    }

    protected ConfigAttributeDefinition lookupAttributes(String url, String method) {
        int firstQuestionMarkIndex;
        if (this.stripQueryStringFromUrls && (firstQuestionMarkIndex = url.indexOf("?")) != -1) {
            url = url.substring(0, firstQuestionMarkIndex);
        }
        if (this.urlMatcher.requiresLowerCaseUrl()) {
            url = url.toLowerCase();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Converted URL to lowercase, from: '" + url + "'; to: '" + url + "'"));
            }
        }
        ConfigAttributeDefinition attributes = null;
        Map methodSpecificMap = (Map)this.httpMethodMap.get(method);
        if (methodSpecificMap != null) {
            attributes = this.lookupUrlInMap(methodSpecificMap, url);
        }
        if (attributes == null) {
            attributes = this.lookupUrlInMap(this.requestMap, url);
        }
        return attributes;
    }

    private ConfigAttributeDefinition lookupUrlInMap(Map requestMap, String url) {
        Iterator entries = requestMap.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            Object p = entry.getKey();
            boolean matched = this.urlMatcher.pathMatchesUrl(p, url);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Candidate is: '" + url + "'; pattern is " + p + "; matched=" + matched));
            }
            if (!matched) continue;
            return (ConfigAttributeDefinition)entry.getValue();
        }
        return null;
    }

    public boolean supports(Class clazz) {
        return (class$org$springframework$security$intercept$web$FilterInvocation == null ? (class$org$springframework$security$intercept$web$FilterInvocation = DefaultFilterInvocationDefinitionSource.class$("org.springframework.security.intercept.web.FilterInvocation")) : class$org$springframework$security$intercept$web$FilterInvocation).isAssignableFrom(clazz);
    }

    public int getMapSize() {
        return this.requestMap.size();
    }

    Map getRequestMap() {
        return this.requestMap;
    }

    protected UrlMatcher getUrlMatcher() {
        return this.urlMatcher;
    }

    public boolean isConvertUrlToLowercaseBeforeComparison() {
        return this.urlMatcher.requiresLowerCaseUrl();
    }

    protected void setStripQueryStringFromUrls(boolean stripQueryStringFromUrls) {
        this.stripQueryStringFromUrls = stripQueryStringFromUrls;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

