/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.intercept.method.aopalliance;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.security.intercept.method.MethodDefinitionSource;
import org.springframework.security.intercept.method.aopalliance.MethodSecurityInterceptor;
import org.springframework.util.Assert;

public class MethodDefinitionSourceAdvisor
extends AbstractPointcutAdvisor {
    private MethodDefinitionSource attributeSource;
    private MethodSecurityInterceptor interceptor;
    private Pointcut pointcut;

    public MethodDefinitionSourceAdvisor(MethodSecurityInterceptor advice) {
        this.interceptor = advice;
        Assert.notNull((Object)advice.getObjectDefinitionSource(), (String)"Cannot construct a MethodDefinitionSourceAdvisor using a MethodSecurityInterceptor that has no ObjectDefinitionSource configured");
        this.attributeSource = advice.getObjectDefinitionSource();
        this.pointcut = new MethodDefinitionSourcePointcut();
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public Advice getAdvice() {
        return this.interceptor;
    }

    class InternalMethodInvocation
    implements MethodInvocation {
        private Method method;
        private Class targetClass;

        public InternalMethodInvocation(Method method, Class targetClass) {
            this.method = method;
            this.targetClass = targetClass;
        }

        protected InternalMethodInvocation() {
            throw new UnsupportedOperationException();
        }

        public Object[] getArguments() {
            throw new UnsupportedOperationException();
        }

        public Method getMethod() {
            return this.method;
        }

        public AccessibleObject getStaticPart() {
            throw new UnsupportedOperationException();
        }

        public Object getThis() {
            return this.targetClass;
        }

        public Object proceed() throws Throwable {
            throw new UnsupportedOperationException();
        }
    }

    class MethodDefinitionSourcePointcut
    extends StaticMethodMatcherPointcut {
        MethodDefinitionSourcePointcut() {
        }

        public boolean matches(Method m, Class targetClass) {
            return MethodDefinitionSourceAdvisor.this.attributeSource.getAttributes(m, targetClass) != null;
        }
    }
}

