/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.ConfigUtils;
import org.springframework.security.ui.preauth.x509.SubjectDnX509PrincipalExtractor;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class X509BeanDefinitionParser
implements BeanDefinitionParser {
    public static final String ATT_REGEX = "subject-principal-regex";
    public static final String ATT_USER_SERVICE_REF = "user-service-ref";
    static /* synthetic */ Class class$org$springframework$security$ui$preauth$x509$X509PreAuthenticatedProcessingFilter;
    static /* synthetic */ Class class$org$springframework$security$ui$preauth$PreAuthenticatedProcessingFilterEntryPoint;
    static /* synthetic */ Class class$org$springframework$security$providers$preauth$PreAuthenticatedAuthenticationProvider;
    static /* synthetic */ Class class$org$springframework$security$userdetails$UserDetailsByNameServiceWrapper;

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder filterBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$springframework$security$ui$preauth$x509$X509PreAuthenticatedProcessingFilter == null ? (class$org$springframework$security$ui$preauth$x509$X509PreAuthenticatedProcessingFilter = X509BeanDefinitionParser.class$("org.springframework.security.ui.preauth.x509.X509PreAuthenticatedProcessingFilter")) : class$org$springframework$security$ui$preauth$x509$X509PreAuthenticatedProcessingFilter));
        RootBeanDefinition entryPoint = new RootBeanDefinition(class$org$springframework$security$ui$preauth$PreAuthenticatedProcessingFilterEntryPoint == null ? (class$org$springframework$security$ui$preauth$PreAuthenticatedProcessingFilterEntryPoint = X509BeanDefinitionParser.class$("org.springframework.security.ui.preauth.PreAuthenticatedProcessingFilterEntryPoint")) : class$org$springframework$security$ui$preauth$PreAuthenticatedProcessingFilterEntryPoint);
        Object source = parserContext.extractSource((Object)element);
        filterBuilder.setSource(source);
        entryPoint.setSource(source);
        String regex = element.getAttribute(ATT_REGEX);
        if (StringUtils.hasText((String)regex)) {
            SubjectDnX509PrincipalExtractor extractor = new SubjectDnX509PrincipalExtractor();
            extractor.setSubjectDnRegex(regex);
            filterBuilder.addPropertyValue("principalExtractor", (Object)extractor);
        }
        RootBeanDefinition provider = new RootBeanDefinition(class$org$springframework$security$providers$preauth$PreAuthenticatedAuthenticationProvider == null ? (class$org$springframework$security$providers$preauth$PreAuthenticatedAuthenticationProvider = X509BeanDefinitionParser.class$("org.springframework.security.providers.preauth.PreAuthenticatedAuthenticationProvider")) : class$org$springframework$security$providers$preauth$PreAuthenticatedAuthenticationProvider);
        ConfigUtils.getRegisteredProviders(parserContext).add(provider);
        parserContext.getRegistry().registerBeanDefinition("_x509AuthenitcationProvider", (BeanDefinition)provider);
        String userServiceRef = element.getAttribute(ATT_USER_SERVICE_REF);
        if (StringUtils.hasText((String)userServiceRef)) {
            RootBeanDefinition preAuthUserService = new RootBeanDefinition(class$org$springframework$security$userdetails$UserDetailsByNameServiceWrapper == null ? (class$org$springframework$security$userdetails$UserDetailsByNameServiceWrapper = X509BeanDefinitionParser.class$("org.springframework.security.userdetails.UserDetailsByNameServiceWrapper")) : class$org$springframework$security$userdetails$UserDetailsByNameServiceWrapper);
            preAuthUserService.setSource(source);
            preAuthUserService.getPropertyValues().addPropertyValue("userDetailsService", (Object)new RuntimeBeanReference(userServiceRef));
            provider.getPropertyValues().addPropertyValue("preAuthenticatedUserDetailsService", (Object)preAuthUserService);
        }
        parserContext.getRegistry().registerBeanDefinition("_preAuthenticatedProcessingFilterEntryPoint", (BeanDefinition)entryPoint);
        filterBuilder.addPropertyValue("authenticationManager", (Object)new RuntimeBeanReference("_authenticationManager"));
        parserContext.getRegistry().registerBeanDefinition("_x509ProcessingFilter", (BeanDefinition)filterBuilder.getBeanDefinition());
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

