/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Ordered;
import org.springframework.security.config.ConfigUtils;
import org.springframework.security.ui.FilterChainOrder;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OrderedFilterBeanDefinitionDecorator
implements BeanDefinitionDecorator {
    public static final String ATT_AFTER = "after";
    public static final String ATT_BEFORE = "before";
    public static final String ATT_POSITION = "position";
    static /* synthetic */ Class class$org$springframework$core$Ordered;

    public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder holder, ParserContext parserContext) {
        Element elt = (Element)node;
        String order = this.getOrder(elt, parserContext);
        BeanDefinition filter = holder.getBeanDefinition();
        BeanDefinitionBuilder wrapper = BeanDefinitionBuilder.rootBeanDefinition((String)"org.springframework.security.config.OrderedFilterBeanDefinitionDecorator$OrderedFilterDecorator");
        wrapper.addConstructorArg((Object)holder.getBeanName());
        wrapper.addConstructorArg((Object)filter);
        if (StringUtils.hasText((String)order)) {
            wrapper.addPropertyValue("order", (Object)order);
        }
        return new BeanDefinitionHolder((BeanDefinition)wrapper.getBeanDefinition(), holder.getBeanName());
    }

    private String getOrder(Element elt, ParserContext pc) {
        String after = elt.getAttribute(ATT_AFTER);
        String before = elt.getAttribute(ATT_BEFORE);
        String position = elt.getAttribute(ATT_POSITION);
        if (ConfigUtils.countNonEmpty(new String[]{after, before, position}) != 1) {
            pc.getReaderContext().error("A single 'after', 'before', or 'position' attribute must be supplied", pc.extractSource((Object)elt));
        }
        if (StringUtils.hasText((String)position)) {
            return Integer.toString(FilterChainOrder.getOrder(position));
        }
        if (StringUtils.hasText((String)after)) {
            return Integer.toString(FilterChainOrder.getOrder(after) + 1);
        }
        if (StringUtils.hasText((String)before)) {
            return Integer.toString(FilterChainOrder.getOrder(before) - 1);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class OrderedFilterDecorator
    implements Filter,
    Ordered {
        private Integer order = null;
        private Filter delegate;
        private String beanName;

        OrderedFilterDecorator(String beanName, Filter delegate) {
            this.delegate = delegate;
            this.beanName = beanName;
        }

        public final void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            this.delegate.doFilter(request, response, chain);
        }

        public final void init(FilterConfig filterConfig) throws ServletException {
            this.delegate.init(filterConfig);
        }

        public final void destroy() {
            this.delegate.destroy();
        }

        public final int getOrder() {
            if (this.order == null) {
                Assert.isInstanceOf((Class)(class$org$springframework$core$Ordered == null ? (class$org$springframework$core$Ordered = OrderedFilterBeanDefinitionDecorator.class$("org.springframework.core.Ordered")) : class$org$springframework$core$Ordered), (Object)this.delegate, (String)("Filter '" + this.beanName + "' must implement the 'Ordered' interface " + " or you must specify one of the attributes '" + OrderedFilterBeanDefinitionDecorator.ATT_AFTER + "' or '" + OrderedFilterBeanDefinitionDecorator.ATT_BEFORE + "' in <" + "custom-filter" + ">"));
                return ((Ordered)this.delegate).getOrder();
            }
            return this.order;
        }

        public final void setOrder(int order) {
            this.order = new Integer(order);
        }

        public String getBeanName() {
            return this.beanName;
        }
    }
}

