/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.AbstractUserDetailsServiceBeanDefinitionParser;
import org.springframework.security.config.LdapConfigUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class LdapUserServiceBeanDefinitionParser
extends AbstractUserDetailsServiceBeanDefinitionParser {
    public static final String ATT_SERVER = "server-ref";
    public static final String ATT_USER_SEARCH_FILTER = "user-search-filter";
    public static final String ATT_USER_SEARCH_BASE = "user-search-base";
    public static final String DEF_USER_SEARCH_BASE = "";
    public static final String ATT_GROUP_SEARCH_FILTER = "group-search-filter";
    public static final String ATT_GROUP_SEARCH_BASE = "group-search-base";
    public static final String ATT_GROUP_ROLE_ATTRIBUTE = "group-role-attribute";
    public static final String DEF_GROUP_SEARCH_FILTER = "(uniqueMember={0})";
    public static final String DEF_GROUP_SEARCH_BASE = "ou=groups";
    static /* synthetic */ Class class$org$springframework$security$userdetails$ldap$LdapUserDetailsService;
    static /* synthetic */ Class class$org$springframework$security$ldap$search$FilterBasedLdapUserSearch;
    static /* synthetic */ Class class$org$springframework$security$ldap$populator$DefaultLdapAuthoritiesPopulator;

    protected Class getBeanClass(Element element) {
        return class$org$springframework$security$userdetails$ldap$LdapUserDetailsService == null ? (class$org$springframework$security$userdetails$ldap$LdapUserDetailsService = LdapUserServiceBeanDefinitionParser.class$("org.springframework.security.userdetails.ldap.LdapUserDetailsService")) : class$org$springframework$security$userdetails$ldap$LdapUserDetailsService;
    }

    protected void doParse(Element elt, ParserContext parserContext, BeanDefinitionBuilder builder) {
        if (!StringUtils.hasText((String)elt.getAttribute(ATT_USER_SEARCH_FILTER))) {
            parserContext.getReaderContext().error("User search filter must be supplied", (Object)elt);
        }
        builder.addConstructorArg((Object)LdapUserServiceBeanDefinitionParser.parseSearchBean(elt, parserContext));
        builder.addConstructorArg((Object)LdapUserServiceBeanDefinitionParser.parseAuthoritiesPopulator(elt, parserContext));
        LdapConfigUtils.registerPostProcessorIfNecessary(parserContext.getRegistry());
    }

    static RootBeanDefinition parseSearchBean(Element elt, ParserContext parserContext) {
        String userSearchFilter = elt.getAttribute(ATT_USER_SEARCH_FILTER);
        String userSearchBase = elt.getAttribute(ATT_USER_SEARCH_BASE);
        Object source = parserContext.extractSource((Object)elt);
        if (StringUtils.hasText((String)userSearchBase)) {
            if (!StringUtils.hasText((String)userSearchFilter)) {
                parserContext.getReaderContext().error("user-search-base cannot be used without a user-search-filter", source);
            }
        } else {
            userSearchBase = DEF_USER_SEARCH_BASE;
        }
        if (!StringUtils.hasText((String)userSearchFilter)) {
            return null;
        }
        RootBeanDefinition search = new RootBeanDefinition(class$org$springframework$security$ldap$search$FilterBasedLdapUserSearch == null ? (class$org$springframework$security$ldap$search$FilterBasedLdapUserSearch = LdapUserServiceBeanDefinitionParser.class$("org.springframework.security.ldap.search.FilterBasedLdapUserSearch")) : class$org$springframework$security$ldap$search$FilterBasedLdapUserSearch);
        search.setSource(source);
        search.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)userSearchBase);
        search.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)userSearchFilter);
        search.getConstructorArgumentValues().addIndexedArgumentValue(2, (Object)LdapUserServiceBeanDefinitionParser.parseServerReference(elt, parserContext));
        return search;
    }

    static RuntimeBeanReference parseServerReference(Element elt, ParserContext parserContext) {
        String server = elt.getAttribute(ATT_SERVER);
        if (!StringUtils.hasText((String)server)) {
            server = "_securityContextSource";
        }
        RuntimeBeanReference contextSource = new RuntimeBeanReference(server);
        contextSource.setSource(parserContext.extractSource((Object)elt));
        return contextSource;
    }

    static RootBeanDefinition parseAuthoritiesPopulator(Element elt, ParserContext parserContext) {
        String groupSearchFilter = elt.getAttribute(ATT_GROUP_SEARCH_FILTER);
        String groupSearchBase = elt.getAttribute(ATT_GROUP_SEARCH_BASE);
        String groupRoleAttribute = elt.getAttribute(ATT_GROUP_ROLE_ATTRIBUTE);
        if (!StringUtils.hasText((String)groupSearchFilter)) {
            groupSearchFilter = DEF_GROUP_SEARCH_FILTER;
        }
        if (!StringUtils.hasText((String)groupSearchBase)) {
            groupSearchBase = DEF_GROUP_SEARCH_BASE;
        }
        RootBeanDefinition populator = new RootBeanDefinition(class$org$springframework$security$ldap$populator$DefaultLdapAuthoritiesPopulator == null ? (class$org$springframework$security$ldap$populator$DefaultLdapAuthoritiesPopulator = LdapUserServiceBeanDefinitionParser.class$("org.springframework.security.ldap.populator.DefaultLdapAuthoritiesPopulator")) : class$org$springframework$security$ldap$populator$DefaultLdapAuthoritiesPopulator);
        populator.setSource(parserContext.extractSource((Object)elt));
        populator.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)LdapUserServiceBeanDefinitionParser.parseServerReference(elt, parserContext));
        populator.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)groupSearchBase);
        populator.getPropertyValues().addPropertyValue("groupSearchFilter", (Object)groupSearchFilter);
        if (StringUtils.hasLength((String)groupRoleAttribute)) {
            populator.getPropertyValues().addPropertyValue("groupRoleAttribute", (Object)groupRoleAttribute);
        }
        return populator;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

