/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.AbstractUserDetailsServiceBeanDefinitionParser;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class JdbcUserServiceBeanDefinitionParser
extends AbstractUserDetailsServiceBeanDefinitionParser {
    static final String ATT_DATA_SOURCE = "data-source-ref";
    static final String ATT_USERS_BY_USERNAME_QUERY = "users-by-username-query";
    static final String ATT_AUTHORITIES_BY_USERNAME_QUERY = "authorities-by-username-query";
    static final String ATT_GROUP_AUTHORITIES_QUERY = "group-authorities-by-username-query";
    static /* synthetic */ Class class$org$springframework$security$userdetails$jdbc$JdbcUserDetailsManager;

    protected Class getBeanClass(Element element) {
        return class$org$springframework$security$userdetails$jdbc$JdbcUserDetailsManager == null ? (class$org$springframework$security$userdetails$jdbc$JdbcUserDetailsManager = JdbcUserServiceBeanDefinitionParser.class$("org.springframework.security.userdetails.jdbc.JdbcUserDetailsManager")) : class$org$springframework$security$userdetails$jdbc$JdbcUserDetailsManager;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String dataSource = element.getAttribute(ATT_DATA_SOURCE);
        if (dataSource == null) {
            throw new BeanDefinitionStoreException("data-source-ref is required for jdbc-user-service");
        }
        builder.addPropertyReference("dataSource", dataSource);
        String usersQuery = element.getAttribute(ATT_USERS_BY_USERNAME_QUERY);
        String authoritiesQuery = element.getAttribute(ATT_AUTHORITIES_BY_USERNAME_QUERY);
        String groupAuthoritiesQuery = element.getAttribute(ATT_GROUP_AUTHORITIES_QUERY);
        if (StringUtils.hasText((String)usersQuery)) {
            builder.addPropertyValue("usersByUsernameQuery", (Object)usersQuery);
        }
        if (StringUtils.hasText((String)authoritiesQuery)) {
            builder.addPropertyValue("authoritiesByUsernameQuery", (Object)authoritiesQuery);
        }
        if (StringUtils.hasText((String)groupAuthoritiesQuery)) {
            builder.addPropertyValue("enableGroups", (Object)Boolean.TRUE);
            builder.addPropertyValue("authoritiesByUsernameQuery", (Object)groupAuthoritiesQuery);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

