/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.Ordered;
import org.springframework.security.config.ConfigUtils;
import org.springframework.util.Assert;

public class HttpSecurityConfigPostProcessor
implements BeanFactoryPostProcessor,
Ordered {
    private Log logger = LogFactory.getLog(this.getClass());
    static /* synthetic */ Class class$org$springframework$security$userdetails$UserDetailsByNameServiceWrapper;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$RuntimeBeanReference;
    static /* synthetic */ Class class$org$springframework$security$ui$AuthenticationEntryPoint;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.injectUserDetailsServiceIntoRememberMeServices(beanFactory);
        this.injectUserDetailsServiceIntoX509Provider(beanFactory);
        this.injectUserDetailsServiceIntoOpenIDProvider(beanFactory);
        this.injectAuthenticationEntryPointIntoExceptionTranslationFilter(beanFactory);
    }

    private void injectUserDetailsServiceIntoRememberMeServices(ConfigurableListableBeanFactory bf) {
        try {
            BeanDefinition rememberMeServices = bf.getBeanDefinition("_rememberMeServices");
            PropertyValue pv = rememberMeServices.getPropertyValues().getPropertyValue("userDetailsService");
            if (pv == null) {
                rememberMeServices.getPropertyValues().addPropertyValue("userDetailsService", (Object)ConfigUtils.getUserDetailsService(bf));
            } else {
                RuntimeBeanReference cachingUserService = this.getCachingUserService(bf, pv.getValue());
                if (cachingUserService != null) {
                    rememberMeServices.getPropertyValues().addPropertyValue("userDetailsService", (Object)cachingUserService);
                }
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
    }

    private void injectUserDetailsServiceIntoX509Provider(ConfigurableListableBeanFactory bf) {
        try {
            BeanDefinition x509AuthProvider = bf.getBeanDefinition("_x509AuthenitcationProvider");
            PropertyValue pv = x509AuthProvider.getPropertyValues().getPropertyValue("preAuthenticatedUserDetailsService");
            if (pv == null) {
                BeanDefinitionBuilder preAuthUserService = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$springframework$security$userdetails$UserDetailsByNameServiceWrapper == null ? (class$org$springframework$security$userdetails$UserDetailsByNameServiceWrapper = HttpSecurityConfigPostProcessor.class$("org.springframework.security.userdetails.UserDetailsByNameServiceWrapper")) : class$org$springframework$security$userdetails$UserDetailsByNameServiceWrapper));
                preAuthUserService.addPropertyValue("userDetailsService", (Object)ConfigUtils.getUserDetailsService(bf));
                x509AuthProvider.getPropertyValues().addPropertyValue("preAuthenticatedUserDetailsService", (Object)preAuthUserService.getBeanDefinition());
            } else {
                RootBeanDefinition preAuthUserService = (RootBeanDefinition)pv.getValue();
                Object userService = preAuthUserService.getPropertyValues().getPropertyValue("userDetailsService").getValue();
                RuntimeBeanReference cachingUserService = this.getCachingUserService(bf, userService);
                if (cachingUserService != null) {
                    preAuthUserService.getPropertyValues().addPropertyValue("userDetailsService", (Object)cachingUserService);
                }
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
    }

    private void injectUserDetailsServiceIntoOpenIDProvider(ConfigurableListableBeanFactory beanFactory) {
        try {
            BeanDefinition openIDProvider = beanFactory.getBeanDefinition("_openIDAuthenticationProvider");
            PropertyValue pv = openIDProvider.getPropertyValues().getPropertyValue("userDetailsService");
            if (pv == null) {
                openIDProvider.getPropertyValues().addPropertyValue("userDetailsService", (Object)ConfigUtils.getUserDetailsService(beanFactory));
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
    }

    private RuntimeBeanReference getCachingUserService(ConfigurableListableBeanFactory bf, Object userServiceRef) {
        Assert.isInstanceOf((Class)(class$org$springframework$beans$factory$config$RuntimeBeanReference == null ? (class$org$springframework$beans$factory$config$RuntimeBeanReference = HttpSecurityConfigPostProcessor.class$("org.springframework.beans.factory.config.RuntimeBeanReference")) : class$org$springframework$beans$factory$config$RuntimeBeanReference), (Object)userServiceRef, (String)"userDetailsService property value must be a RuntimeBeanReference");
        String id = ((RuntimeBeanReference)userServiceRef).getBeanName();
        String cachingId = id + ".caching";
        if (bf.containsBeanDefinition(cachingId)) {
            return new RuntimeBeanReference(cachingId);
        }
        return null;
    }

    private void injectAuthenticationEntryPointIntoExceptionTranslationFilter(ConfigurableListableBeanFactory beanFactory) {
        this.logger.info((Object)"Selecting AuthenticationEntryPoint for use in ExceptionTranslationFilter");
        BeanDefinition etf = beanFactory.getBeanDefinition("_exceptionTranslationFilter");
        String entryPoint = null;
        if (beanFactory.containsBean("_mainEntryPoint")) {
            entryPoint = "_mainEntryPoint";
            this.logger.info((Object)"Using main configured AuthenticationEntryPoint set to _mainEntryPoint");
        } else {
            String[] entryPoints = beanFactory.getBeanNamesForType(class$org$springframework$security$ui$AuthenticationEntryPoint == null ? (class$org$springframework$security$ui$AuthenticationEntryPoint = HttpSecurityConfigPostProcessor.class$("org.springframework.security.ui.AuthenticationEntryPoint")) : class$org$springframework$security$ui$AuthenticationEntryPoint);
            Assert.isTrue((entryPoints.length != 0 ? 1 : 0) != 0, (String)"No AuthenticationEntryPoint instances defined");
            Assert.isTrue((entryPoints.length == 1 ? 1 : 0) != 0, (String)"More than one AuthenticationEntryPoint defined in context");
            entryPoint = entryPoints[0];
        }
        this.logger.info((Object)("Using bean '" + entryPoint + "' as the entry point."));
        etf.getPropertyValues().addPropertyValue("authenticationEntryPoint", (Object)new RuntimeBeanReference(entryPoint));
    }

    public int getOrder() {
        return -2147483647;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

