/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.ConfigAttributeEditor;
import org.springframework.security.config.AnonymousBeanDefinitionParser;
import org.springframework.security.config.BasicAuthenticationBeanDefinitionParser;
import org.springframework.security.config.ConcurrentSessionsBeanDefinitionParser;
import org.springframework.security.config.ConfigUtils;
import org.springframework.security.config.FormLoginBeanDefinitionParser;
import org.springframework.security.config.LogoutBeanDefinitionParser;
import org.springframework.security.config.PortMappingsBeanDefinitionParser;
import org.springframework.security.config.RememberMeBeanDefinitionParser;
import org.springframework.security.config.X509BeanDefinitionParser;
import org.springframework.security.intercept.web.DefaultFilterInvocationDefinitionSource;
import org.springframework.security.intercept.web.RequestKey;
import org.springframework.security.ui.AccessDeniedHandlerImpl;
import org.springframework.security.util.AntUrlPathMatcher;
import org.springframework.security.util.RegexUrlPathMatcher;
import org.springframework.security.util.UrlMatcher;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class HttpSecurityBeanDefinitionParser
implements BeanDefinitionParser {
    protected final Log logger = LogFactory.getLog(this.getClass());
    static final String ATT_REALM = "realm";
    static final String DEF_REALM = "Spring Security Application";
    static final String ATT_PATH_PATTERN = "pattern";
    static final String ATT_SESSION_FIXATION_PROTECTION = "session-fixation-protection";
    static final String OPT_SESSION_FIXATION_NO_PROTECTION = "none";
    static final String OPT_SESSION_FIXATION_CLEAN_SESSION = "newSession";
    static final String OPT_SESSION_FIXATION_MIGRATE_SESSION = "migrateSession";
    static final String ATT_PATH_TYPE = "path-type";
    static final String DEF_PATH_TYPE_ANT = "ant";
    static final String OPT_PATH_TYPE_REGEX = "regex";
    static final String ATT_FILTERS = "filters";
    static final String OPT_FILTERS_NONE = "none";
    static final String ATT_ACCESS_CONFIG = "access";
    static final String ATT_REQUIRES_CHANNEL = "requires-channel";
    static final String OPT_REQUIRES_HTTP = "http";
    static final String OPT_REQUIRES_HTTPS = "https";
    static final String OPT_ANY_CHANNEL = "any";
    static final String ATT_HTTP_METHOD = "method";
    static final String ATT_CREATE_SESSION = "create-session";
    static final String DEF_CREATE_SESSION_IF_REQUIRED = "ifRequired";
    static final String OPT_CREATE_SESSION_ALWAYS = "always";
    static final String OPT_CREATE_SESSION_NEVER = "never";
    static final String ATT_LOWERCASE_COMPARISONS = "lowercase-comparisons";
    static final String DEF_LOWERCASE_COMPARISONS = "true";
    static final String ATT_AUTO_CONFIG = "auto-config";
    static final String DEF_AUTO_CONFIG = "false";
    static final String ATT_SERVLET_API_PROVISION = "servlet-api-provision";
    static final String DEF_SERVLET_API_PROVISION = "true";
    static final String ATT_ACCESS_MGR = "access-decision-manager-ref";
    static final String ATT_USER_SERVICE_REF = "user-service-ref";
    static final String ATT_ENTRY_POINT_REF = "entry-point-ref";
    static final String ATT_ONCE_PER_REQUEST = "once-per-request";
    static final String ATT_ACCESS_DENIED_PAGE = "access-denied-page";
    static /* synthetic */ Class class$org$springframework$security$util$FilterChainProxy;
    static /* synthetic */ Class class$org$springframework$security$context$HttpSessionContextIntegrationFilter;
    static /* synthetic */ Class class$org$springframework$security$intercept$web$FilterSecurityInterceptor;
    static /* synthetic */ Class class$org$springframework$security$ui$ExceptionTranslationFilter;
    static /* synthetic */ Class class$org$springframework$security$wrapper$SecurityContextHolderAwareRequestFilter;
    static /* synthetic */ Class class$org$springframework$security$securechannel$ChannelProcessingFilter;
    static /* synthetic */ Class class$org$springframework$security$securechannel$ChannelDecisionManagerImpl;
    static /* synthetic */ Class class$org$springframework$security$securechannel$SecureChannelProcessor;
    static /* synthetic */ Class class$org$springframework$security$securechannel$RetryWithHttpEntryPoint;
    static /* synthetic */ Class class$org$springframework$security$securechannel$RetryWithHttpsEntryPoint;
    static /* synthetic */ Class class$org$springframework$security$securechannel$InsecureChannelProcessor;
    static /* synthetic */ Class class$org$springframework$security$ui$SessionFixationProtectionFilter;
    static /* synthetic */ Class class$org$springframework$security$config$RememberMeServicesInjectionBeanPostProcessor;
    static /* synthetic */ Class class$org$springframework$security$config$HttpSecurityConfigPostProcessor;
    static /* synthetic */ Class class$org$springframework$security$config$FilterChainProxyPostProcessor;
    static /* synthetic */ Class class$org$springframework$security$ui$webapp$DefaultLoginPageGeneratingFilter;

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Element logoutElt;
        Element rememberMeElt;
        Element anonymousElt;
        String sessionFixationAttribute;
        Element sessionControlElt;
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        RootBeanDefinition filterChainProxy = new RootBeanDefinition(class$org$springframework$security$util$FilterChainProxy == null ? (class$org$springframework$security$util$FilterChainProxy = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.util.FilterChainProxy")) : class$org$springframework$security$util$FilterChainProxy);
        RootBeanDefinition httpScif = new RootBeanDefinition(class$org$springframework$security$context$HttpSessionContextIntegrationFilter == null ? (class$org$springframework$security$context$HttpSessionContextIntegrationFilter = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.context.HttpSessionContextIntegrationFilter")) : class$org$springframework$security$context$HttpSessionContextIntegrationFilter);
        BeanDefinition portMapper = new PortMappingsBeanDefinitionParser().parse(DomUtils.getChildElementByTagName((Element)element, (String)"port-mappings"), parserContext);
        registry.registerBeanDefinition("_portMapper", portMapper);
        RuntimeBeanReference portMapperRef = new RuntimeBeanReference("_portMapper");
        String createSession = element.getAttribute(ATT_CREATE_SESSION);
        if (OPT_CREATE_SESSION_ALWAYS.equals(createSession)) {
            httpScif.getPropertyValues().addPropertyValue("allowSessionCreation", (Object)Boolean.TRUE);
            httpScif.getPropertyValues().addPropertyValue("forceEagerSessionCreation", (Object)Boolean.TRUE);
        } else if (OPT_CREATE_SESSION_NEVER.equals(createSession)) {
            httpScif.getPropertyValues().addPropertyValue("allowSessionCreation", (Object)Boolean.FALSE);
            httpScif.getPropertyValues().addPropertyValue("forceEagerSessionCreation", (Object)Boolean.FALSE);
        } else {
            createSession = DEF_CREATE_SESSION_IF_REQUIRED;
            httpScif.getPropertyValues().addPropertyValue("allowSessionCreation", (Object)Boolean.TRUE);
            httpScif.getPropertyValues().addPropertyValue("forceEagerSessionCreation", (Object)Boolean.FALSE);
        }
        BeanDefinitionBuilder filterSecurityInterceptorBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$springframework$security$intercept$web$FilterSecurityInterceptor == null ? (class$org$springframework$security$intercept$web$FilterSecurityInterceptor = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.intercept.web.FilterSecurityInterceptor")) : class$org$springframework$security$intercept$web$FilterSecurityInterceptor));
        BeanDefinitionBuilder exceptionTranslationFilterBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$springframework$security$ui$ExceptionTranslationFilter == null ? (class$org$springframework$security$ui$ExceptionTranslationFilter = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.ui.ExceptionTranslationFilter")) : class$org$springframework$security$ui$ExceptionTranslationFilter));
        String accessDeniedPage = element.getAttribute(ATT_ACCESS_DENIED_PAGE);
        if (StringUtils.hasText((String)accessDeniedPage)) {
            AccessDeniedHandlerImpl accessDeniedHandler = new AccessDeniedHandlerImpl();
            accessDeniedHandler.setErrorPage(accessDeniedPage);
            exceptionTranslationFilterBuilder.addPropertyValue("accessDeniedHandler", (Object)accessDeniedHandler);
        }
        LinkedHashMap filterChainMap = new LinkedHashMap();
        UrlMatcher matcher = HttpSecurityBeanDefinitionParser.createUrlMatcher(element);
        filterChainProxy.getPropertyValues().addPropertyValue("matcher", (Object)matcher);
        String provideServletApi = element.getAttribute(ATT_SERVLET_API_PROVISION);
        if (!StringUtils.hasText((String)provideServletApi)) {
            provideServletApi = "true";
        }
        if ("true".equals(provideServletApi)) {
            parserContext.getRegistry().registerBeanDefinition("_securityContextHolderAwareRequestFilter", (BeanDefinition)new RootBeanDefinition(class$org$springframework$security$wrapper$SecurityContextHolderAwareRequestFilter == null ? (class$org$springframework$security$wrapper$SecurityContextHolderAwareRequestFilter = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.wrapper.SecurityContextHolderAwareRequestFilter")) : class$org$springframework$security$wrapper$SecurityContextHolderAwareRequestFilter));
        }
        filterChainProxy.getPropertyValues().addPropertyValue("filterChainMap", filterChainMap);
        String accessManagerId = element.getAttribute(ATT_ACCESS_MGR);
        if (!StringUtils.hasText((String)accessManagerId)) {
            ConfigUtils.registerDefaultAccessManagerIfNecessary(parserContext);
            accessManagerId = "_accessManager";
        }
        filterSecurityInterceptorBuilder.addPropertyValue("accessDecisionManager", (Object)new RuntimeBeanReference(accessManagerId));
        filterSecurityInterceptorBuilder.addPropertyValue("authenticationManager", (Object)ConfigUtils.registerProviderManagerIfNecessary(parserContext));
        if ("true".equals(element.getAttribute(ATT_ONCE_PER_REQUEST))) {
            filterSecurityInterceptorBuilder.addPropertyValue("observeOncePerRequest", (Object)Boolean.TRUE);
        }
        boolean convertPathsToLowerCase = matcher instanceof AntUrlPathMatcher && matcher.requiresLowerCaseUrl();
        LinkedHashMap channelRequestMap = new LinkedHashMap();
        LinkedHashMap filterInvocationDefinitionMap = new LinkedHashMap();
        List interceptUrlElts = DomUtils.getChildElementsByTagName((Element)element, (String)"intercept-url");
        this.parseInterceptUrlsForChannelSecurityAndFilterChain(interceptUrlElts, filterChainMap, channelRequestMap, convertPathsToLowerCase, parserContext);
        HttpSecurityBeanDefinitionParser.parseInterceptUrlsForFilterInvocationRequestMap(interceptUrlElts, filterInvocationDefinitionMap, convertPathsToLowerCase, parserContext);
        DefaultFilterInvocationDefinitionSource interceptorFilterInvDefSource = new DefaultFilterInvocationDefinitionSource(matcher, filterInvocationDefinitionMap);
        DefaultFilterInvocationDefinitionSource channelFilterInvDefSource = new DefaultFilterInvocationDefinitionSource(matcher, channelRequestMap);
        filterSecurityInterceptorBuilder.addPropertyValue("objectDefinitionSource", (Object)interceptorFilterInvDefSource);
        if (channelRequestMap.size() > 0) {
            RootBeanDefinition channelFilter = new RootBeanDefinition(class$org$springframework$security$securechannel$ChannelProcessingFilter == null ? (class$org$springframework$security$securechannel$ChannelProcessingFilter = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.securechannel.ChannelProcessingFilter")) : class$org$springframework$security$securechannel$ChannelProcessingFilter);
            channelFilter.getPropertyValues().addPropertyValue("channelDecisionManager", (Object)new RuntimeBeanReference("_channelDecisionManager"));
            channelFilter.getPropertyValues().addPropertyValue("filterInvocationDefinitionSource", (Object)channelFilterInvDefSource);
            RootBeanDefinition channelDecisionManager = new RootBeanDefinition(class$org$springframework$security$securechannel$ChannelDecisionManagerImpl == null ? (class$org$springframework$security$securechannel$ChannelDecisionManagerImpl = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.securechannel.ChannelDecisionManagerImpl")) : class$org$springframework$security$securechannel$ChannelDecisionManagerImpl);
            ManagedList channelProcessors = new ManagedList(3);
            RootBeanDefinition secureChannelProcessor = new RootBeanDefinition(class$org$springframework$security$securechannel$SecureChannelProcessor == null ? (class$org$springframework$security$securechannel$SecureChannelProcessor = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.securechannel.SecureChannelProcessor")) : class$org$springframework$security$securechannel$SecureChannelProcessor);
            RootBeanDefinition retryWithHttp = new RootBeanDefinition(class$org$springframework$security$securechannel$RetryWithHttpEntryPoint == null ? (class$org$springframework$security$securechannel$RetryWithHttpEntryPoint = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.securechannel.RetryWithHttpEntryPoint")) : class$org$springframework$security$securechannel$RetryWithHttpEntryPoint);
            RootBeanDefinition retryWithHttps = new RootBeanDefinition(class$org$springframework$security$securechannel$RetryWithHttpsEntryPoint == null ? (class$org$springframework$security$securechannel$RetryWithHttpsEntryPoint = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.securechannel.RetryWithHttpsEntryPoint")) : class$org$springframework$security$securechannel$RetryWithHttpsEntryPoint);
            retryWithHttp.getPropertyValues().addPropertyValue("portMapper", (Object)portMapperRef);
            retryWithHttps.getPropertyValues().addPropertyValue("portMapper", (Object)portMapperRef);
            secureChannelProcessor.getPropertyValues().addPropertyValue("entryPoint", (Object)retryWithHttps);
            RootBeanDefinition inSecureChannelProcessor = new RootBeanDefinition(class$org$springframework$security$securechannel$InsecureChannelProcessor == null ? (class$org$springframework$security$securechannel$InsecureChannelProcessor = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.securechannel.InsecureChannelProcessor")) : class$org$springframework$security$securechannel$InsecureChannelProcessor);
            inSecureChannelProcessor.getPropertyValues().addPropertyValue("entryPoint", (Object)retryWithHttp);
            channelProcessors.add(secureChannelProcessor);
            channelProcessors.add(inSecureChannelProcessor);
            channelDecisionManager.getPropertyValues().addPropertyValue("channelProcessors", (Object)channelProcessors);
            registry.registerBeanDefinition("_channelProcessingFilter", (BeanDefinition)channelFilter);
            registry.registerBeanDefinition("_channelDecisionManager", (BeanDefinition)channelDecisionManager);
        }
        if ((sessionControlElt = DomUtils.getChildElementByTagName((Element)element, (String)"concurrent-session-control")) != null) {
            new ConcurrentSessionsBeanDefinitionParser().parse(sessionControlElt, parserContext);
            this.logger.info((Object)"Concurrent session filter in use, setting 'forceEagerSessionCreation' to true");
            httpScif.getPropertyValues().addPropertyValue("forceEagerSessionCreation", (Object)Boolean.TRUE);
        }
        if (!StringUtils.hasText((String)(sessionFixationAttribute = element.getAttribute(ATT_SESSION_FIXATION_PROTECTION)))) {
            sessionFixationAttribute = OPT_SESSION_FIXATION_MIGRATE_SESSION;
        }
        if (!sessionFixationAttribute.equals("none")) {
            BeanDefinitionBuilder sessionFixationFilter = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$springframework$security$ui$SessionFixationProtectionFilter == null ? (class$org$springframework$security$ui$SessionFixationProtectionFilter = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.ui.SessionFixationProtectionFilter")) : class$org$springframework$security$ui$SessionFixationProtectionFilter));
            sessionFixationFilter.addPropertyValue("migrateSessionAttributes", (Object)sessionFixationAttribute.equals(OPT_SESSION_FIXATION_MIGRATE_SESSION));
            if (sessionControlElt != null) {
                sessionFixationFilter.addPropertyReference("sessionRegistry", "_sessionRegistry");
            }
            parserContext.getRegistry().registerBeanDefinition("_sessionFixationProtectionFilter", (BeanDefinition)sessionFixationFilter.getBeanDefinition());
        }
        boolean autoConfig = false;
        if ("true".equals(element.getAttribute(ATT_AUTO_CONFIG))) {
            autoConfig = true;
        }
        if ((anonymousElt = DomUtils.getChildElementByTagName((Element)element, (String)"anonymous")) != null || autoConfig) {
            new AnonymousBeanDefinitionParser().parse(anonymousElt, parserContext);
        }
        if ((rememberMeElt = DomUtils.getChildElementByTagName((Element)element, (String)"remember-me")) != null || autoConfig) {
            new RememberMeBeanDefinitionParser().parse(rememberMeElt, parserContext);
            RootBeanDefinition rememberMeInjectionPostProcessor = new RootBeanDefinition(class$org$springframework$security$config$RememberMeServicesInjectionBeanPostProcessor == null ? (class$org$springframework$security$config$RememberMeServicesInjectionBeanPostProcessor = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.config.RememberMeServicesInjectionBeanPostProcessor")) : class$org$springframework$security$config$RememberMeServicesInjectionBeanPostProcessor);
            rememberMeInjectionPostProcessor.setRole(2);
            registry.registerBeanDefinition("_rememberMeServicesInjectionBeanPostProcessor", (BeanDefinition)rememberMeInjectionPostProcessor);
        }
        if ((logoutElt = DomUtils.getChildElementByTagName((Element)element, (String)"logout")) != null || autoConfig) {
            new LogoutBeanDefinitionParser().parse(logoutElt, parserContext);
        }
        this.parseBasicFormLoginAndOpenID(element, parserContext, autoConfig);
        Element x509Elt = DomUtils.getChildElementByTagName((Element)element, (String)"x509");
        if (x509Elt != null) {
            new X509BeanDefinitionParser().parse(x509Elt, parserContext);
        }
        registry.registerBeanDefinition("_filterChainProxy", (BeanDefinition)filterChainProxy);
        registry.registerAlias("_filterChainProxy", "springSecurityFilterChain");
        registry.registerBeanDefinition("_httpSessionContextIntegrationFilter", (BeanDefinition)httpScif);
        registry.registerBeanDefinition("_exceptionTranslationFilter", (BeanDefinition)exceptionTranslationFilterBuilder.getBeanDefinition());
        registry.registerBeanDefinition("_filterSecurityInterceptor", (BeanDefinition)filterSecurityInterceptorBuilder.getBeanDefinition());
        RootBeanDefinition postProcessor = new RootBeanDefinition(class$org$springframework$security$config$HttpSecurityConfigPostProcessor == null ? (class$org$springframework$security$config$HttpSecurityConfigPostProcessor = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.config.HttpSecurityConfigPostProcessor")) : class$org$springframework$security$config$HttpSecurityConfigPostProcessor);
        postProcessor.setRole(2);
        registry.registerBeanDefinition("_httpConfigBeanFactoryPostProcessor", (BeanDefinition)postProcessor);
        RootBeanDefinition filterChainPostProcessor = new RootBeanDefinition(class$org$springframework$security$config$FilterChainProxyPostProcessor == null ? (class$org$springframework$security$config$FilterChainProxyPostProcessor = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.config.FilterChainProxyPostProcessor")) : class$org$springframework$security$config$FilterChainProxyPostProcessor);
        filterChainPostProcessor.setRole(2);
        registry.registerBeanDefinition("_filterChainProxyPostProcessor", (BeanDefinition)filterChainPostProcessor);
        return null;
    }

    private void parseBasicFormLoginAndOpenID(Element element, ParserContext parserContext, boolean autoConfig) {
        String customEntryPoint;
        Element openIDLoginElt;
        Element formLoginElt;
        Element basicAuthElt;
        RootBeanDefinition formLoginFilter = null;
        RootBeanDefinition formLoginEntryPoint = null;
        String formLoginPage = null;
        RootBeanDefinition openIDFilter = null;
        RootBeanDefinition openIDEntryPoint = null;
        String openIDLoginPage = null;
        String realm = element.getAttribute(ATT_REALM);
        if (!StringUtils.hasText((String)realm)) {
            realm = DEF_REALM;
        }
        if ((basicAuthElt = DomUtils.getChildElementByTagName((Element)element, (String)"http-basic")) != null || autoConfig) {
            new BasicAuthenticationBeanDefinitionParser(realm).parse(basicAuthElt, parserContext);
        }
        if ((formLoginElt = DomUtils.getChildElementByTagName((Element)element, (String)"form-login")) != null || autoConfig) {
            FormLoginBeanDefinitionParser parser = new FormLoginBeanDefinitionParser("/j_spring_security_check", "org.springframework.security.ui.webapp.AuthenticationProcessingFilter");
            parser.parse(formLoginElt, parserContext);
            formLoginFilter = parser.getFilterBean();
            formLoginEntryPoint = parser.getEntryPointBean();
            formLoginPage = parser.getLoginPage();
        }
        if ((openIDLoginElt = DomUtils.getChildElementByTagName((Element)element, (String)"openid-login")) != null) {
            FormLoginBeanDefinitionParser parser = new FormLoginBeanDefinitionParser("/j_spring_openid_security_check", "org.springframework.security.ui.openid.OpenIDAuthenticationProcessingFilter");
            parser.parse(openIDLoginElt, parserContext);
            openIDFilter = parser.getFilterBean();
            openIDEntryPoint = parser.getEntryPointBean();
            openIDLoginPage = parser.getLoginPage();
            BeanDefinitionBuilder openIDProviderBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)"org.springframework.security.providers.openid.OpenIDAuthenticationProvider");
            String userService = openIDLoginElt.getAttribute(ATT_USER_SERVICE_REF);
            if (StringUtils.hasText((String)userService)) {
                openIDProviderBuilder.addPropertyReference("userDetailsService", userService);
            }
            AbstractBeanDefinition openIDProvider = openIDProviderBuilder.getBeanDefinition();
            ConfigUtils.getRegisteredProviders(parserContext).add(openIDProvider);
            parserContext.getRegistry().registerBeanDefinition("_openIDAuthenticationProvider", (BeanDefinition)openIDProvider);
        }
        boolean needLoginPage = false;
        if (formLoginFilter != null) {
            needLoginPage = true;
            parserContext.getRegistry().registerBeanDefinition("_formLoginFilter", (BeanDefinition)formLoginFilter);
            parserContext.getRegistry().registerBeanDefinition("_formLoginEntryPoint", (BeanDefinition)formLoginEntryPoint);
        }
        if (openIDFilter != null) {
            needLoginPage = true;
            parserContext.getRegistry().registerBeanDefinition("_openIDFilter", openIDFilter);
            parserContext.getRegistry().registerBeanDefinition("_openIDFilterEntryPoint", (BeanDefinition)openIDEntryPoint);
        }
        if (needLoginPage && formLoginPage == null && openIDLoginPage == null) {
            this.logger.info((Object)"No login page configured. The default internal one will be used. Use the 'login-page' attribute to set the URL of the login page.");
            BeanDefinitionBuilder loginPageFilter = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$springframework$security$ui$webapp$DefaultLoginPageGeneratingFilter == null ? (class$org$springframework$security$ui$webapp$DefaultLoginPageGeneratingFilter = HttpSecurityBeanDefinitionParser.class$("org.springframework.security.ui.webapp.DefaultLoginPageGeneratingFilter")) : class$org$springframework$security$ui$webapp$DefaultLoginPageGeneratingFilter));
            if (formLoginFilter != null) {
                loginPageFilter.addConstructorArg((Object)new RuntimeBeanReference("_formLoginFilter"));
            }
            if (openIDFilter != null) {
                loginPageFilter.addConstructorArg((Object)new RuntimeBeanReference("_openIDFilter"));
            }
            parserContext.getRegistry().registerBeanDefinition("_defaultLoginPageFilter", (BeanDefinition)loginPageFilter.getBeanDefinition());
        }
        if (StringUtils.hasText((String)(customEntryPoint = element.getAttribute(ATT_ENTRY_POINT_REF)))) {
            parserContext.getRegistry().registerAlias(customEntryPoint, "_mainEntryPoint");
            return;
        }
        if (basicAuthElt != null && formLoginElt == null && openIDLoginElt == null) {
            parserContext.getRegistry().registerAlias("_basicAuthenticationEntryPoint", "_mainEntryPoint");
            return;
        }
        if (formLoginFilter != null && openIDLoginPage == null) {
            parserContext.getRegistry().registerAlias("_formLoginEntryPoint", "_mainEntryPoint");
            return;
        }
        if (openIDFilter != null && formLoginFilter == null) {
            parserContext.getRegistry().registerAlias("_openIDFilterEntryPoint", "_mainEntryPoint");
            return;
        }
        parserContext.getReaderContext().error("No AuthenticationEntryPoint could be established. Pleasemake sure you have a login mechanism configured through the namespace (such as form-login) orspecify a custom AuthenticationEntryPoint with the custom-entry-point-ref  ", parserContext.extractSource((Object)element));
    }

    static UrlMatcher createUrlMatcher(Element element) {
        String lowercaseComparisons;
        String patternType = element.getAttribute(ATT_PATH_TYPE);
        if (!StringUtils.hasText((String)patternType)) {
            patternType = DEF_PATH_TYPE_ANT;
        }
        boolean useRegex = patternType.equals(OPT_PATH_TYPE_REGEX);
        UrlMatcher matcher = new AntUrlPathMatcher();
        if (useRegex) {
            matcher = new RegexUrlPathMatcher();
        }
        if (!StringUtils.hasText((String)(lowercaseComparisons = element.getAttribute(ATT_LOWERCASE_COMPARISONS)))) {
            lowercaseComparisons = null;
        }
        if ("true".equals(lowercaseComparisons)) {
            if (useRegex) {
                ((RegexUrlPathMatcher)matcher).setRequiresLowerCaseUrl(true);
            }
        } else if (DEF_AUTO_CONFIG.equals(lowercaseComparisons) && !useRegex) {
            ((AntUrlPathMatcher)matcher).setRequiresLowerCaseUrl(false);
        }
        return matcher;
    }

    void parseInterceptUrlsForChannelSecurityAndFilterChain(List urlElts, Map filterChainMap, Map channelRequestMap, boolean useLowerCasePaths, ParserContext parserContext) {
        Iterator urlEltsIterator = urlElts.iterator();
        ConfigAttributeEditor editor = new ConfigAttributeEditor();
        while (urlEltsIterator.hasNext()) {
            String filters;
            String requiredChannel;
            Element urlElt = (Element)urlEltsIterator.next();
            String path = urlElt.getAttribute(ATT_PATH_PATTERN);
            if (!StringUtils.hasText((String)path)) {
                parserContext.getReaderContext().error("path attribute cannot be empty or null", (Object)urlElt);
            }
            if (useLowerCasePaths) {
                path = path.toLowerCase();
            }
            if (StringUtils.hasText((String)(requiredChannel = urlElt.getAttribute(ATT_REQUIRES_CHANNEL)))) {
                String channelConfigAttribute = null;
                if (requiredChannel.equals(OPT_REQUIRES_HTTPS)) {
                    channelConfigAttribute = "REQUIRES_SECURE_CHANNEL";
                } else if (requiredChannel.equals(OPT_REQUIRES_HTTP)) {
                    channelConfigAttribute = "REQUIRES_INSECURE_CHANNEL";
                } else if (requiredChannel.equals(OPT_ANY_CHANNEL)) {
                    channelConfigAttribute = "ANY_CHANNEL";
                } else {
                    parserContext.getReaderContext().error("Unsupported channel " + requiredChannel, (Object)urlElt);
                }
                editor.setAsText(channelConfigAttribute);
                channelRequestMap.put(new RequestKey(path), (ConfigAttributeDefinition)editor.getValue());
            }
            if (!StringUtils.hasText((String)(filters = urlElt.getAttribute(ATT_FILTERS)))) continue;
            if (!filters.equals("none")) {
                parserContext.getReaderContext().error("Currently only 'none' is supported as the custom filters attribute", (Object)urlElt);
            }
            filterChainMap.put(path, Collections.EMPTY_LIST);
        }
    }

    static void parseInterceptUrlsForFilterInvocationRequestMap(List urlElts, Map filterInvocationDefinitionMap, boolean useLowerCasePaths, ParserContext parserContext) {
        Iterator urlEltsIterator = urlElts.iterator();
        ConfigAttributeEditor editor = new ConfigAttributeEditor();
        while (urlEltsIterator.hasNext()) {
            String access;
            String method;
            Element urlElt = (Element)urlEltsIterator.next();
            String path = urlElt.getAttribute(ATT_PATH_PATTERN);
            if (!StringUtils.hasText((String)path)) {
                parserContext.getReaderContext().error("path attribute cannot be empty or null", (Object)urlElt);
            }
            if (useLowerCasePaths) {
                path = path.toLowerCase();
            }
            if (!StringUtils.hasText((String)(method = urlElt.getAttribute(ATT_HTTP_METHOD)))) {
                method = null;
            }
            if (!StringUtils.hasText((String)(access = urlElt.getAttribute(ATT_ACCESS_CONFIG)))) continue;
            editor.setAsText(access);
            filterInvocationDefinitionMap.put(new RequestKey(path, method), editor.getValue());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

