/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.aop.config.AopNamespaceUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.config.ConfigUtils;
import org.springframework.security.intercept.method.MapBasedMethodDefinitionSource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class GlobalMethodSecurityBeanDefinitionParser
implements BeanDefinitionParser {
    public static final String SECURED_DEPENDENCY_CLASS = "org.springframework.security.annotation.Secured";
    public static final String SECURED_METHOD_DEFINITION_SOURCE_CLASS = "org.springframework.security.annotation.SecuredMethodDefinitionSource";
    public static final String JSR_250_SECURITY_METHOD_DEFINITION_SOURCE_CLASS = "org.springframework.security.annotation.Jsr250MethodDefinitionSource";
    public static final String JSR_250_VOTER_CLASS = "org.springframework.security.annotation.Jsr250Voter";
    private static final String ATT_ACCESS = "access";
    private static final String ATT_EXPRESSION = "expression";
    private static final String ATT_ACCESS_MGR = "access-decision-manager-ref";
    private static final String ATT_USE_JSR250 = "jsr250-annotations";
    private static final String ATT_USE_SECURED = "secured-annotations";
    static /* synthetic */ Class class$org$springframework$security$intercept$method$ProtectPointcutPostProcessor;
    static /* synthetic */ Class class$org$springframework$security$intercept$method$DelegatingMethodDefinitionSource;
    static /* synthetic */ Class class$org$springframework$security$intercept$method$aopalliance$MethodSecurityInterceptor;
    static /* synthetic */ Class class$org$springframework$security$intercept$method$aopalliance$MethodDefinitionSourceAdvisor;

    GlobalMethodSecurityBeanDefinitionParser() {
    }

    private void validatePresent(String className, Element element, ParserContext parserContext) {
        if (!ClassUtils.isPresent((String)className, (ClassLoader)parserContext.getReaderContext().getBeanClassLoader())) {
            parserContext.getReaderContext().error("Cannot locate '" + className + "'", (Object)element);
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        boolean useJsr250 = "enabled".equals(element.getAttribute(ATT_USE_JSR250));
        boolean useSecured = "enabled".equals(element.getAttribute(ATT_USE_SECURED));
        if (useSecured) {
            this.validatePresent(SECURED_METHOD_DEFINITION_SOURCE_CLASS, element, parserContext);
            this.validatePresent(SECURED_DEPENDENCY_CLASS, element, parserContext);
        }
        if (useJsr250) {
            this.validatePresent(JSR_250_SECURITY_METHOD_DEFINITION_SOURCE_CLASS, element, parserContext);
            this.validatePresent(JSR_250_VOTER_CLASS, element, parserContext);
        }
        LinkedHashMap<String, ConfigAttributeDefinition> pointcutMap = new LinkedHashMap<String, ConfigAttributeDefinition>();
        List protect = DomUtils.getChildElementsByTagName((Element)element, (String)"protect-pointcut");
        Iterator i = protect.iterator();
        while (i.hasNext()) {
            Element childElt = (Element)i.next();
            String accessConfig = childElt.getAttribute(ATT_ACCESS);
            String expression = childElt.getAttribute(ATT_EXPRESSION);
            Assert.hasText((String)accessConfig, (String)("Access configuration required for '" + childElt + "'"));
            Assert.hasText((String)expression, (String)("Expression required for '" + childElt + "'"));
            ConfigAttributeDefinition def = new ConfigAttributeDefinition(StringUtils.commaDelimitedListToStringArray((String)accessConfig));
            pointcutMap.put(expression, def);
        }
        MapBasedMethodDefinitionSource mapBasedMethodDefinitionSource = new MapBasedMethodDefinitionSource();
        if (pointcutMap.size() > 0) {
            RootBeanDefinition ppbp = new RootBeanDefinition(class$org$springframework$security$intercept$method$ProtectPointcutPostProcessor == null ? (class$org$springframework$security$intercept$method$ProtectPointcutPostProcessor = GlobalMethodSecurityBeanDefinitionParser.class$("org.springframework.security.intercept.method.ProtectPointcutPostProcessor")) : class$org$springframework$security$intercept$method$ProtectPointcutPostProcessor);
            ppbp.setRole(2);
            ppbp.setSource(parserContext.extractSource((Object)element));
            ppbp.getConstructorArgumentValues().addGenericArgumentValue((Object)mapBasedMethodDefinitionSource);
            ppbp.getPropertyValues().addPropertyValue("pointcutMap", pointcutMap);
            parserContext.getRegistry().registerBeanDefinition("_protectPointcutPostProcessor", (BeanDefinition)ppbp);
        }
        ManagedList delegates = new ManagedList();
        delegates.add(mapBasedMethodDefinitionSource);
        if (useSecured) {
            delegates.add(BeanDefinitionBuilder.rootBeanDefinition((String)SECURED_METHOD_DEFINITION_SOURCE_CLASS).getBeanDefinition());
        }
        if (useJsr250) {
            delegates.add(BeanDefinitionBuilder.rootBeanDefinition((String)JSR_250_SECURITY_METHOD_DEFINITION_SOURCE_CLASS).getBeanDefinition());
        }
        RootBeanDefinition delegatingMethodDefinitionSource = new RootBeanDefinition(class$org$springframework$security$intercept$method$DelegatingMethodDefinitionSource == null ? (class$org$springframework$security$intercept$method$DelegatingMethodDefinitionSource = GlobalMethodSecurityBeanDefinitionParser.class$("org.springframework.security.intercept.method.DelegatingMethodDefinitionSource")) : class$org$springframework$security$intercept$method$DelegatingMethodDefinitionSource);
        delegatingMethodDefinitionSource.setRole(2);
        delegatingMethodDefinitionSource.setSource(parserContext.extractSource((Object)element));
        delegatingMethodDefinitionSource.getPropertyValues().addPropertyValue("methodDefinitionSources", (Object)delegates);
        parserContext.getRegistry().registerBeanDefinition("_delegatingMethodDefinitionSource", (BeanDefinition)delegatingMethodDefinitionSource);
        String accessManagerId = element.getAttribute(ATT_ACCESS_MGR);
        if (!StringUtils.hasText((String)accessManagerId)) {
            ConfigUtils.registerDefaultAccessManagerIfNecessary(parserContext);
            if (useJsr250) {
                ConfigUtils.addVoter((BeanDefinition)new RootBeanDefinition(JSR_250_VOTER_CLASS, null, null), parserContext);
            }
            accessManagerId = "_accessManager";
        }
        RootBeanDefinition interceptor = new RootBeanDefinition(class$org$springframework$security$intercept$method$aopalliance$MethodSecurityInterceptor == null ? (class$org$springframework$security$intercept$method$aopalliance$MethodSecurityInterceptor = GlobalMethodSecurityBeanDefinitionParser.class$("org.springframework.security.intercept.method.aopalliance.MethodSecurityInterceptor")) : class$org$springframework$security$intercept$method$aopalliance$MethodSecurityInterceptor);
        interceptor.setRole(2);
        interceptor.setSource(parserContext.extractSource((Object)element));
        interceptor.getPropertyValues().addPropertyValue("accessDecisionManager", (Object)new RuntimeBeanReference(accessManagerId));
        interceptor.getPropertyValues().addPropertyValue("authenticationManager", (Object)new RuntimeBeanReference("_authenticationManager"));
        interceptor.getPropertyValues().addPropertyValue("objectDefinitionSource", (Object)new RuntimeBeanReference("_delegatingMethodDefinitionSource"));
        parserContext.getRegistry().registerBeanDefinition("_methodSecurityInterceptor", (BeanDefinition)interceptor);
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)interceptor, "_methodSecurityInterceptor"));
        RootBeanDefinition advisor = new RootBeanDefinition(class$org$springframework$security$intercept$method$aopalliance$MethodDefinitionSourceAdvisor == null ? (class$org$springframework$security$intercept$method$aopalliance$MethodDefinitionSourceAdvisor = GlobalMethodSecurityBeanDefinitionParser.class$("org.springframework.security.intercept.method.aopalliance.MethodDefinitionSourceAdvisor")) : class$org$springframework$security$intercept$method$aopalliance$MethodDefinitionSourceAdvisor);
        advisor.setRole(2);
        advisor.setSource(parserContext.extractSource((Object)element));
        advisor.getConstructorArgumentValues().addGenericArgumentValue((Object)interceptor);
        parserContext.getRegistry().registerBeanDefinition("_methodDefinitionSourceAdvisor", (BeanDefinition)advisor);
        AopNamespaceUtils.registerAutoProxyCreatorIfNecessary((ParserContext)parserContext, (Object)element);
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

