/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.OrderComparator;
import org.springframework.core.Ordered;
import org.springframework.security.util.FilterChainProxy;
import org.springframework.util.Assert;

public class FilterChainProxyPostProcessor
implements BeanPostProcessor,
BeanFactoryAware {
    private Log logger = LogFactory.getLog(this.getClass());
    private ListableBeanFactory beanFactory;
    static /* synthetic */ Class class$javax$servlet$Filter;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (!beanName.equals("_filterChainProxy")) {
            return bean;
        }
        FilterChainProxy filterChainProxy = (FilterChainProxy)bean;
        List defaultFilterChain = this.orderFilters(this.beanFactory);
        Map filterMap = filterChainProxy.getFilterChainMap();
        String allUrlsMatch = filterChainProxy.getMatcher().getUniversalMatchPattern();
        filterMap.put(allUrlsMatch, defaultFilterChain);
        filterChainProxy.setFilterChainMap(filterMap);
        this.logger.info((Object)("Configured filter chain(s): " + filterChainProxy));
        return bean;
    }

    private List orderFilters(ListableBeanFactory beanFactory) {
        Map filters = beanFactory.getBeansOfType(class$javax$servlet$Filter == null ? (class$javax$servlet$Filter = FilterChainProxyPostProcessor.class$("javax.servlet.Filter")) : class$javax$servlet$Filter);
        Assert.notEmpty((Map)filters, (String)"No filters found in app context!");
        Iterator ids = filters.keySet().iterator();
        ArrayList<Filter> orderedFilters = new ArrayList<Filter>();
        while (ids.hasNext()) {
            String id = (String)ids.next();
            Filter filter = (Filter)filters.get(id);
            if (filter instanceof FilterChainProxy || !filter.getClass().getName().startsWith("org.springframework.security")) continue;
            if (!(filter instanceof Ordered)) {
                this.logger.info((Object)("Filter " + id + " doesn't implement the Ordered interface, skipping it."));
                continue;
            }
            orderedFilters.add(filter);
        }
        Collections.sort(orderedFilters, new OrderComparator());
        return orderedFilters;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

