/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.AuthenticationManager;
import org.springframework.util.StringUtils;

public abstract class ConfigUtils {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$config$ConfigUtils == null ? (class$org$springframework$security$config$ConfigUtils = ConfigUtils.class$("org.springframework.security.config.ConfigUtils")) : class$org$springframework$security$config$ConfigUtils));
    static /* synthetic */ Class class$org$springframework$security$config$ConfigUtils;
    static /* synthetic */ Class class$org$springframework$security$vote$RoleVoter;
    static /* synthetic */ Class class$org$springframework$security$vote$AuthenticatedVoter;
    static /* synthetic */ Class class$org$springframework$security$vote$AffirmativeBased;
    static /* synthetic */ Class class$org$springframework$security$providers$ProviderManager;
    static /* synthetic */ Class class$org$springframework$security$config$CachingUserDetailsService;
    static /* synthetic */ Class class$org$springframework$security$userdetails$UserDetailsService;
    static /* synthetic */ Class class$org$springframework$security$AuthenticationManager;

    static void registerDefaultAccessManagerIfNecessary(ParserContext parserContext) {
        if (!parserContext.getRegistry().containsBeanDefinition("_accessManager")) {
            ManagedList defaultVoters = new ManagedList(2);
            defaultVoters.add(new RootBeanDefinition(class$org$springframework$security$vote$RoleVoter == null ? (class$org$springframework$security$vote$RoleVoter = ConfigUtils.class$("org.springframework.security.vote.RoleVoter")) : class$org$springframework$security$vote$RoleVoter));
            defaultVoters.add(new RootBeanDefinition(class$org$springframework$security$vote$AuthenticatedVoter == null ? (class$org$springframework$security$vote$AuthenticatedVoter = ConfigUtils.class$("org.springframework.security.vote.AuthenticatedVoter")) : class$org$springframework$security$vote$AuthenticatedVoter));
            BeanDefinitionBuilder accessMgrBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$springframework$security$vote$AffirmativeBased == null ? (class$org$springframework$security$vote$AffirmativeBased = ConfigUtils.class$("org.springframework.security.vote.AffirmativeBased")) : class$org$springframework$security$vote$AffirmativeBased));
            accessMgrBuilder.addPropertyValue("decisionVoters", (Object)defaultVoters);
            AbstractBeanDefinition accessMgr = accessMgrBuilder.getBeanDefinition();
            parserContext.getRegistry().registerBeanDefinition("_accessManager", (BeanDefinition)accessMgr);
        }
    }

    public static int countNonEmpty(String[] objects) {
        int nonNulls = 0;
        for (int i = 0; i < objects.length; ++i) {
            if (!StringUtils.hasText((String)objects[i])) continue;
            ++nonNulls;
        }
        return nonNulls;
    }

    public static void addVoter(BeanDefinition voter, ParserContext parserContext) {
        ConfigUtils.registerDefaultAccessManagerIfNecessary(parserContext);
        BeanDefinition accessMgr = parserContext.getRegistry().getBeanDefinition("_accessManager");
        ManagedList voters = (ManagedList)accessMgr.getPropertyValues().getPropertyValue("decisionVoters").getValue();
        voters.add(voter);
        accessMgr.getPropertyValues().addPropertyValue("decisionVoters", (Object)voters);
    }

    static BeanDefinition registerProviderManagerIfNecessary(ParserContext parserContext) {
        if (parserContext.getRegistry().containsBeanDefinition("_authenticationManager")) {
            return parserContext.getRegistry().getBeanDefinition("_authenticationManager");
        }
        RootBeanDefinition authManager = new RootBeanDefinition(class$org$springframework$security$providers$ProviderManager == null ? (class$org$springframework$security$providers$ProviderManager = ConfigUtils.class$("org.springframework.security.providers.ProviderManager")) : class$org$springframework$security$providers$ProviderManager);
        authManager.getPropertyValues().addPropertyValue("providers", (Object)new ManagedList());
        parserContext.getRegistry().registerBeanDefinition("_authenticationManager", (BeanDefinition)authManager);
        return authManager;
    }

    static RuntimeBeanReference getUserDetailsService(ConfigurableListableBeanFactory bf) {
        String[] services = bf.getBeanNamesForType(class$org$springframework$security$config$CachingUserDetailsService == null ? (class$org$springframework$security$config$CachingUserDetailsService = ConfigUtils.class$("org.springframework.security.config.CachingUserDetailsService")) : class$org$springframework$security$config$CachingUserDetailsService, false, false);
        if (services.length == 0) {
            services = bf.getBeanNamesForType(class$org$springframework$security$userdetails$UserDetailsService == null ? (class$org$springframework$security$userdetails$UserDetailsService = ConfigUtils.class$("org.springframework.security.userdetails.UserDetailsService")) : class$org$springframework$security$userdetails$UserDetailsService);
        }
        if (services.length == 0) {
            throw new IllegalArgumentException("No UserDetailsService registered.");
        }
        if (services.length > 1) {
            throw new IllegalArgumentException("More than one UserDetailsService registered. Pleaseuse a specific Id in your configuration");
        }
        return new RuntimeBeanReference(services[0]);
    }

    private static AuthenticationManager getAuthenticationManager(ConfigurableListableBeanFactory bf) {
        Map authManagers = bf.getBeansOfType(class$org$springframework$security$AuthenticationManager == null ? (class$org$springframework$security$AuthenticationManager = ConfigUtils.class$("org.springframework.security.AuthenticationManager")) : class$org$springframework$security$AuthenticationManager);
        if (authManagers.size() == 0) {
            throw new IllegalArgumentException("No AuthenticationManager registered. Make sure you have configured at least one AuthenticationProvider?");
        }
        if (authManagers.size() > 1) {
            throw new IllegalArgumentException("More than one AuthenticationManager registered.");
        }
        return (AuthenticationManager)authManagers.values().toArray()[0];
    }

    static ManagedList getRegisteredProviders(ParserContext parserContext) {
        BeanDefinition authManager = ConfigUtils.registerProviderManagerIfNecessary(parserContext);
        return (ManagedList)authManager.getPropertyValues().getPropertyValue("providers").getValue();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

