/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.reader;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.hibernate.search.SearchException;
import org.hibernate.search.reader.CacheableMultiReader;

public abstract class ReaderProviderHelper {
    public static IndexReader buildMultiReader(int length, IndexReader[] readers) {
        if (length == 0) {
            return null;
        }
        if (length == 1) {
            try {
                return new CacheableMultiReader(readers);
            }
            catch (Exception e) {
                ReaderProviderHelper.clean(new SearchException("Unable to open a MultiReader", e), readers);
                return null;
            }
        }
        try {
            return new CacheableMultiReader(readers);
        }
        catch (Exception e) {
            ReaderProviderHelper.clean(new SearchException("Unable to open a MultiReader", e), readers);
            return null;
        }
    }

    public static void clean(SearchException e, IndexReader ... readers) {
        for (IndexReader reader : readers) {
            if (reader == null) continue;
            try {
                reader.close();
            }
            catch (IOException ee) {
                // empty catch block
            }
        }
        throw e;
    }
}

