/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.validator.validators;

import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.validator.DelegatingValidatorContext;
import com.opensymphony.xwork2.validator.ShortCircuitableValidator;
import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.Validator;
import com.opensymphony.xwork2.validator.ValidatorContext;

public abstract class ValidatorSupport
implements Validator,
ShortCircuitableValidator {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected String defaultMessage = "";
    protected String messageKey;
    private ValidatorContext validatorContext;
    private boolean shortCircuit;
    private boolean parse;
    private String type;
    private ValueStack stack;

    public void setValueStack(ValueStack stack) {
        this.stack = stack;
    }

    public void setDefaultMessage(String message) {
        this.defaultMessage = message;
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public void setParse(boolean parse) {
        this.parse = parse;
    }

    public boolean getParse() {
        return this.parse;
    }

    public String getMessage(Object object) {
        String message;
        boolean pop = false;
        if (!this.stack.getRoot().contains(object)) {
            this.stack.push(object);
            pop = true;
        }
        this.stack.push(this);
        if (this.messageKey != null) {
            if (this.defaultMessage == null || this.defaultMessage.trim().equals("")) {
                this.defaultMessage = this.messageKey;
            }
            if (this.validatorContext == null) {
                this.validatorContext = new DelegatingValidatorContext(object);
            }
            message = this.validatorContext.getText(this.messageKey, this.defaultMessage);
        } else {
            message = this.defaultMessage;
        }
        message = TextParseUtil.translateVariables(message, this.stack);
        this.stack.pop();
        if (pop) {
            this.stack.pop();
        }
        return message;
    }

    public void setMessageKey(String key) {
        this.messageKey = key;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public void setShortCircuit(boolean shortcircuit) {
        this.shortCircuit = shortcircuit;
    }

    public boolean isShortCircuit() {
        return this.shortCircuit;
    }

    public void setValidatorContext(ValidatorContext validatorContext) {
        this.validatorContext = validatorContext;
    }

    public ValidatorContext getValidatorContext() {
        return this.validatorContext;
    }

    public void setValidatorType(String type) {
        this.type = type;
    }

    public String getValidatorType() {
        return this.type;
    }

    protected Object conditionalParse(String expression) {
        if (this.parse) {
            return TextParseUtil.translateVariables('$', expression, this.stack);
        }
        return expression;
    }

    protected Object getFieldValue(String name, Object object) throws ValidationException {
        boolean pop = false;
        if (!this.stack.getRoot().contains(object)) {
            this.stack.push(object);
            pop = true;
        }
        Object retVal = this.stack.findValue(name);
        if (pop) {
            this.stack.pop();
        }
        return retVal;
    }

    protected void addActionError(Object object) {
        this.validatorContext.addActionError(this.getMessage(object));
    }

    protected void addFieldError(String propertyName, Object object) {
        this.validatorContext.addFieldError(propertyName, this.getMessage(object));
    }
}

